/*
 * Decompiled with CFR 0.152.
 */
package herddb.jdbc;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import herddb.client.ClientSideMetadataProviderException;
import herddb.client.DMLResult;
import herddb.client.HDBException;
import herddb.client.ScanResultSet;
import herddb.client.impl.EmptyScanResultSet;
import herddb.client.impl.SingletonScanResultSet;
import herddb.jdbc.HerdDBConnection;
import herddb.jdbc.HerdDBResultSet;
import herddb.jdbc.utils.SQLExceptionUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class HerdDBStatement
implements Statement {
    protected static final Pattern EXPECTS_RESULTSET = Pattern.compile("[\\s]*(SELECT|EXPLAIN|SHOW).*", 34);
    private static final Logger LOG = Logger.getLogger(HerdDBStatement.class.getName());
    private static final AtomicLong IDGENERATOR = new AtomicLong(1L);
    protected final HerdDBConnection parent;
    protected int maxRows;
    protected int fetchSize = 1000;
    protected ResultSet lastResultSet;
    protected long lastUpdateCount = -1L;
    protected Object lastKey;
    private final Long id = IDGENERATOR.incrementAndGet();
    private final ConcurrentHashMap<Long, HerdDBResultSet> openResultSets = new ConcurrentHashMap();
    private boolean closed;
    private int queryTimeout;
    protected boolean moreResults = false;

    public HerdDBStatement(HerdDBConnection parent) {
        this.parent = parent;
        this.parent.registerOpenStatement(this);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        try {
            this.parent.discoverTableSpace(sql);
            ScanResultSet scanResult = this.parent.getConnection().executeScan(this.parent.getTableSpace(), sql, false, Collections.emptyList(), this.parent.ensureTransaction(), this.maxRows, this.fetchSize);
            this.parent.bindToTransaction(scanResult.transactionId);
            this.lastResultSet = new HerdDBResultSet(scanResult, this);
            return this.lastResultSet;
        }
        catch (ClientSideMetadataProviderException | HDBException | InterruptedException ex) {
            throw SQLExceptionUtils.wrapException(ex);
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return (int)this.executeLargeUpdate(sql);
    }

    @Override
    public void close() throws SQLException {
        for (HerdDBResultSet rs : this.openResultSets.values()) {
            LOG.log(Level.FINE, "closing abandoned result set {0}", rs);
            try {
                rs.close();
            }
            catch (SQLException err) {
                LOG.log(Level.SEVERE, "Error while closing open resultset", err);
            }
        }
        this.openResultSets.clear();
        this.parent.releaseStatement(this);
        this.closed = true;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.queryTimeout = seconds;
    }

    @Override
    public void cancel() throws SQLException {
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public boolean execute(String sql) throws SQLException {
        if (EXPECTS_RESULTSET.matcher(sql).matches()) {
            this.executeQuery(sql);
            this.moreResults = true;
            return true;
        }
        this.executeUpdate(sql);
        this.moreResults = false;
        return false;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.moreResults = false;
        return this.lastResultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return (int)this.lastUpdateCount;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.lastUpdateCount = -1L;
        return this.moreResults;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 1003;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.parent;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        if (this.lastKey != null) {
            return new HerdDBResultSet((ScanResultSet)new SingletonScanResultSet(0L, this.lastKey), this);
        }
        return new HerdDBResultSet((ScanResultSet)new EmptyScanResultSet(0L), this);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return (int)this.executeLargeUpdateImpl(sql, autoGeneratedKeys == 1);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return (int)this.executeLargeUpdateImpl(sql, columnIndexes != null && columnIndexes.length > 0);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return (int)this.executeLargeUpdateImpl(sql, columnNames != null && columnNames.length > 0);
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        return this.executeLargeUpdateImpl(sql, false);
    }

    private long executeLargeUpdateImpl(String sql, boolean returnValues) throws SQLException {
        try {
            this.parent.discoverTableSpace(sql);
            DMLResult result = this.parent.getConnection().executeUpdate(this.parent.getTableSpace(), sql, this.parent.ensureTransaction(), returnValues, false, Collections.emptyList());
            this.parent.bindToTransaction(result.transactionId);
            this.lastUpdateCount = result.updateCount;
            this.lastKey = result.key;
            return this.lastUpdateCount;
        }
        catch (ClientSideMetadataProviderException | HDBException err) {
            throw SQLExceptionUtils.wrapException(err);
        }
    }

    @Override
    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        if (sql.toLowerCase().contains("select")) {
            this.executeQuery(sql);
            return true;
        }
        this.executeUpdate(sql, autoGeneratedKeys);
        return false;
    }

    @Override
    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        if (sql.toLowerCase().contains("select")) {
            this.executeQuery(sql);
            return true;
        }
        this.executeUpdate(sql, columnIndexes);
        return false;
    }

    @Override
    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        if (sql.toLowerCase().contains("select")) {
            this.executeQuery(sql);
            return true;
        }
        this.executeUpdate(sql, columnNames);
        return false;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    final Long getId() {
        return this.id;
    }

    void releaseResultSet(HerdDBResultSet rs) {
        this.openResultSets.remove(rs.getId());
    }

    void registerResultSet(HerdDBResultSet rs) {
        this.openResultSets.put(rs.getId(), rs);
    }
}

