/*
 * Decompiled with CFR 0.152.
 */
package herddb.sql.functions;

import herddb.core.AbstractTableManager;
import herddb.model.Column;
import herddb.model.ColumnTypes;
import herddb.model.Index;
import herddb.model.Table;
import herddb.model.TableDoesNotExistException;
import java.util.List;
import java.util.StringJoiner;

public class ShowCreateTableCalculator {
    public static String calculate(boolean showCreateIndex, String tableName, String tableSpace, AbstractTableManager tableManager) {
        List<Index> indexes;
        Table t = tableManager.getTable();
        if (t == null) {
            throw new TableDoesNotExistException(String.format("Table %s does not exist.", tableName));
        }
        StringBuilder sb = new StringBuilder("CREATE TABLE " + tableSpace + "." + tableName);
        StringJoiner joiner = new StringJoiner(",", "(", ")");
        for (Column c : t.getColumns()) {
            joiner.add(c.name + " " + ColumnTypes.typeToString(c.type) + ShowCreateTableCalculator.autoIncrementColumn(t, c));
        }
        if (t.getPrimaryKey().length > 0) {
            joiner.add("PRIMARY KEY(" + String.join((CharSequence)",", t.getPrimaryKey()) + ")");
        }
        if (showCreateIndex && !(indexes = tableManager.getAvailableIndexes()).isEmpty()) {
            indexes.forEach(idx -> joiner.add("INDEX " + idx.name + "(" + String.join((CharSequence)",", idx.columnNames) + ")"));
        }
        sb.append(joiner.toString());
        return sb.toString();
    }

    private static String autoIncrementColumn(Table t, Column c) {
        if (t.auto_increment && c.name.equals(t.primaryKey[0]) && (c.type == 2 || c.type == 12 || c.type == 1 || c.type == 13)) {
            return " auto_increment";
        }
        return "";
    }
}

