/*
 * Decompiled with CFR 0.152.
 */
package herddb.sql.functions;

import herddb.model.Column;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.sql.AggregatedColumnCalculator;
import herddb.sql.expressions.CompiledSQLExpression;
import herddb.sql.functions.CountColumnCalculator;
import herddb.sql.functions.MaxColumnCalculator;
import herddb.sql.functions.MinColumnCalculator;
import herddb.sql.functions.SingleValueCalculator;
import herddb.sql.functions.SumColumnCalculator;
import net.sf.jsqlparser.expression.Function;

public class BuiltinFunctions {
    public static final String COUNT = "count";
    public static final String SUM = "sum";
    public static final String SUM0 = "$sum0";
    public static final String MIN = "min";
    public static final String MAX = "max";
    public static final String SINGLEVALUE = "single_value";
    public static final String LOWER = "lower";
    public static final String UPPER = "upper";
    public static final String ABS = "abs";
    public static final String ROUND = "round";
    public static final String CURRENT_TIMESTAMP = "current_timestamp";
    public static final String BOOLEAN_TRUE = "true";
    public static final String BOOLEAN_FALSE = "false";
    public static final String NAME_COUNT = "COUNT";
    public static final String NAME_SUM = "SUM";
    public static final String NAME_MIN = "MIN";
    public static final String NAME_MAX = "MAX";
    public static final String NAME_LOWERCASE = "LOWER";
    public static final String NAME_UPPER = "UPPER";
    public static final String NAME_ABS = "ABS";
    public static final String NAME_ROUND = "ROUND";
    public static final String NAME_CURRENT_TIMESTAMP = "CURRENT_TIMESTAMP";

    public static Column toAggregatedOutputColumn(String fieldName, Function f) {
        if (f.getName().equalsIgnoreCase(COUNT)) {
            return Column.column(fieldName, 1);
        }
        if (f.getName().equalsIgnoreCase(SUM) && f.getParameters() != null && f.getParameters().getExpressions() != null && f.getParameters().getExpressions().size() == 1) {
            return Column.column(fieldName, 1);
        }
        if (f.getName().equalsIgnoreCase(MIN) && f.getParameters() != null && f.getParameters().getExpressions() != null && f.getParameters().getExpressions().size() == 1) {
            return Column.column(fieldName, 1);
        }
        if (f.getName().equalsIgnoreCase(MAX) && f.getParameters() != null && f.getParameters().getExpressions() != null && f.getParameters().getExpressions().size() == 1) {
            return Column.column(fieldName, 1);
        }
        return null;
    }

    public static AggregatedColumnCalculator getColumnCalculator(String functionName, String fieldName, CompiledSQLExpression firstParam, StatementEvaluationContext context) throws StatementExecutionException {
        switch (functionName) {
            case "count": {
                return new CountColumnCalculator(fieldName);
            }
            case "sum": 
            case "$sum0": {
                return new SumColumnCalculator(fieldName, firstParam, context);
            }
            case "min": {
                return new MinColumnCalculator(fieldName, firstParam, context);
            }
            case "max": {
                return new MaxColumnCalculator(fieldName, firstParam, context);
            }
            case "single_value": {
                return new SingleValueCalculator(fieldName, firstParam, context);
            }
        }
        return null;
    }

    public static boolean isScalarFunction(String name) {
        switch (name) {
            case "lower": 
            case "upper": 
            case "abs": 
            case "round": {
                return true;
            }
        }
        return false;
    }

    public static boolean isAggregateFunction(String name) {
        switch (name) {
            case "count": 
            case "sum": 
            case "min": 
            case "max": {
                return true;
            }
        }
        return false;
    }

    public static int typeOfFunction(String lowerCaseName) throws StatementExecutionException {
        switch (lowerCaseName) {
            case "count": 
            case "sum": 
            case "min": 
            case "max": 
            case "abs": 
            case "round": {
                return 1;
            }
            case "lower": 
            case "upper": {
                return 0;
            }
        }
        throw new StatementExecutionException("unhandled function " + lowerCaseName);
    }
}

