/*
 * Decompiled with CFR 0.152.
 */
package herddb.sql.expressions;

import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.sql.SQLRecordPredicate;
import herddb.sql.expressions.CompiledSQLExpression;
import herddb.utils.DataAccessor;

public class TypedJdbcParameterExpression
implements CompiledSQLExpression {
    private final int index;
    private final int type;

    public TypedJdbcParameterExpression(int index, int type) {
        this.index = index;
        this.type = type;
    }

    @Override
    public Object evaluate(DataAccessor bean, StatementEvaluationContext context) throws StatementExecutionException {
        Object value = context.getJdbcParameter(this.index);
        try {
            return SQLRecordPredicate.cast(value, this.type);
        }
        catch (IllegalArgumentException err) {
            throw new StatementExecutionException("Unexpected cast to type " + this.type + " for value " + value + " while accessing JDBC paramter #" + this.index, err);
        }
    }

    @Override
    public void validate(StatementEvaluationContext context) throws StatementExecutionException {
        context.getJdbcParameter(this.index);
    }

    public String toString() {
        return System.identityHashCode(this) + " TypedJdbcParameterExpression{type=" + this.type + ", index=" + this.index + '}';
    }

    @Override
    public CompiledSQLExpression cast(int type) {
        return new TypedJdbcParameterExpression(this.index, type);
    }

    @Override
    public CompiledSQLExpression remapPositionalAccessToToPrimaryKeyAccessor(int[] projection) {
        return this;
    }
}

