/*
 * Decompiled with CFR 0.152.
 */
package herddb.sql.expressions;

import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.sql.expressions.CompiledSQLExpression;
import herddb.utils.DataAccessor;

public class CompiledSignedExpression
implements CompiledSQLExpression {
    private final CompiledSQLExpression inner;
    private final char sign;

    public CompiledSignedExpression(char sign, CompiledSQLExpression inner) {
        this.inner = inner;
        this.sign = sign;
    }

    @Override
    public Object evaluate(DataAccessor bean, StatementEvaluationContext context) throws StatementExecutionException {
        Object innerValue = this.inner.evaluate(bean, context);
        switch (this.sign) {
            case '-': {
                if (innerValue instanceof Integer) {
                    return (Integer)innerValue * -1;
                }
                if (innerValue instanceof Long) {
                    return (Long)innerValue * -1L;
                }
                if (innerValue instanceof Double) {
                    return (Double)innerValue * -1.0;
                }
                if (innerValue instanceof Float) {
                    return Float.valueOf(((Float)innerValue).floatValue() * -1.0f);
                }
                if (innerValue instanceof Short) {
                    return (Short)innerValue * -1;
                }
                if (innerValue instanceof Byte) {
                    return (Byte)innerValue * -1;
                }
                throw new StatementExecutionException("invalid signed expression, value=" + innerValue + "; class=" + innerValue.getClass() + "; exp=" + this.inner);
            }
            case '+': {
                return innerValue;
            }
        }
        throw new StatementExecutionException("invalid sign '" + this.sign + "'");
    }

    @Override
    public void validate(StatementEvaluationContext context) throws StatementExecutionException {
        this.inner.validate(context);
    }
}

