/*
 * Decompiled with CFR 0.152.
 */
package herddb.sql.expressions;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.sql.expressions.CompiledSQLExpression;
import herddb.utils.DataAccessor;
import herddb.utils.SQLRecordPredicateFunctions;
import java.util.Arrays;

@SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
public class CompiledMultiOrExpression
implements CompiledSQLExpression {
    private final CompiledSQLExpression[] operands;

    public CompiledMultiOrExpression(CompiledSQLExpression[] operands) {
        this.operands = operands;
    }

    @Override
    public Object evaluate(DataAccessor bean, StatementEvaluationContext context) throws StatementExecutionException {
        for (int i = 0; i < this.operands.length; ++i) {
            boolean ok = SQLRecordPredicateFunctions.toBoolean((Object)this.operands[i].evaluate(bean, context));
            if (!ok) continue;
            return true;
        }
        return false;
    }

    @Override
    public void validate(StatementEvaluationContext context) throws StatementExecutionException {
        for (CompiledSQLExpression op : this.operands) {
            op.validate(context);
        }
    }

    public String toString() {
        return "OR{" + Arrays.toString(this.operands) + '}';
    }

    @Override
    public CompiledSQLExpression remapPositionalAccessToToPrimaryKeyAccessor(int[] projection) {
        CompiledSQLExpression[] ops = new CompiledSQLExpression[this.operands.length];
        int i = 0;
        for (CompiledSQLExpression exp : this.operands) {
            ops[i++] = exp.remapPositionalAccessToToPrimaryKeyAccessor(projection);
        }
        return new CompiledMultiOrExpression(ops);
    }
}

