/*
 * Decompiled with CFR 0.152.
 */
package herddb.sql.expressions;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.sql.expressions.BindableTableScanColumnNameResolver;
import herddb.sql.expressions.CompiledSQLExpression;
import herddb.utils.DataAccessor;
import herddb.utils.SQLRecordPredicateFunctions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
public class CompiledMultiAndExpression
implements CompiledSQLExpression {
    private final CompiledSQLExpression[] operands;

    public CompiledMultiAndExpression(CompiledSQLExpression[] operands) {
        this.operands = operands;
    }

    @Override
    public Object evaluate(DataAccessor bean, StatementEvaluationContext context) throws StatementExecutionException {
        for (int i = 0; i < this.operands.length; ++i) {
            boolean ok = SQLRecordPredicateFunctions.toBoolean((Object)this.operands[i].evaluate(bean, context));
            if (ok) continue;
            return false;
        }
        return true;
    }

    @Override
    public void validate(StatementEvaluationContext context) throws StatementExecutionException {
        for (CompiledSQLExpression op : this.operands) {
            op.validate(context);
        }
    }

    public String toString() {
        return "AND{" + Arrays.toString(this.operands) + '}';
    }

    @Override
    public List<CompiledSQLExpression> scanForConstraintsOnColumn(String column, BindableTableScanColumnNameResolver columnNameResolver) {
        ArrayList<CompiledSQLExpression> res = new ArrayList<CompiledSQLExpression>();
        for (CompiledSQLExpression exp : this.operands) {
            res.addAll(exp.scanForConstraintsOnColumn(column, columnNameResolver));
        }
        return res;
    }

    @Override
    public List<CompiledSQLExpression> scanForConstraintedValueOnColumnWithOperator(String column, String operator, BindableTableScanColumnNameResolver columnNameResolver) {
        ArrayList<CompiledSQLExpression> res = new ArrayList<CompiledSQLExpression>();
        for (CompiledSQLExpression exp : this.operands) {
            res.addAll(exp.scanForConstraintedValueOnColumnWithOperator(column, operator, columnNameResolver));
        }
        return res;
    }

    @Override
    public CompiledSQLExpression remapPositionalAccessToToPrimaryKeyAccessor(int[] projection) {
        CompiledSQLExpression[] ops = new CompiledSQLExpression[this.operands.length];
        int i = 0;
        for (CompiledSQLExpression exp : this.operands) {
            ops[i++] = exp.remapPositionalAccessToToPrimaryKeyAccessor(projection);
        }
        return new CompiledMultiAndExpression(ops);
    }
}

