/*
 * Decompiled with CFR 0.152.
 */
package herddb.sql.expressions;

import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.sql.expressions.CompiledSQLExpression;
import herddb.utils.DataAccessor;
import java.util.List;

public class CompiledFunction
implements CompiledSQLExpression {
    private final String name;
    private final List<CompiledSQLExpression> parameters;
    private final long roundMultiplier;
    private final double roundSign;

    public CompiledFunction(String name, List<CompiledSQLExpression> parameters) {
        this.name = name;
        this.parameters = parameters;
        if (name.equals("round") && parameters.size() == 2) {
            if (parameters.size() == 2) {
                long precision;
                try {
                    precision = ((Number)parameters.get(1).evaluate(DataAccessor.NULL, null)).longValue();
                }
                catch (NullPointerException ex) {
                    throw new IllegalArgumentException("round second parameter must be a constant value");
                }
                long mult = 1L;
                int i = 0;
                while ((long)i < Math.abs(precision)) {
                    mult *= 10L;
                    ++i;
                }
                this.roundMultiplier = mult;
                this.roundSign = Math.signum(precision);
            } else {
                this.roundMultiplier = 0L;
                this.roundSign = 0.0;
            }
        } else {
            this.roundMultiplier = 0L;
            this.roundSign = 0.0;
        }
    }

    @Override
    public Object evaluate(DataAccessor bean, StatementEvaluationContext context) throws StatementExecutionException {
        switch (this.name) {
            case "count": 
            case "sum": 
            case "min": 
            case "max": {
                return null;
            }
            case "lower": {
                Object parValue = this.parameters.get(0).evaluate(bean, context);
                return parValue.toString().toLowerCase();
            }
            case "upper": {
                Object parValue = this.parameters.get(0).evaluate(bean, context);
                return parValue.toString().toUpperCase();
            }
            case "abs": {
                Object parValue = this.parameters.get(0).evaluate(bean, context);
                if (parValue instanceof Double) {
                    return Math.abs((Double)parValue);
                }
                return Math.abs((Long)parValue);
            }
            case "current_timestamp": {
                return context.getCurrentTimestamp();
            }
            case "round": {
                Object parValue = this.parameters.get(0).evaluate(bean, context);
                if (this.roundSign == 0.0) {
                    return (double)Math.round((Double)parValue);
                }
                if (this.roundSign > 0.0) {
                    return (double)Math.round((Double)parValue * (double)this.roundMultiplier) / (double)this.roundMultiplier;
                }
                return (double)Math.round((Double)parValue / (double)this.roundMultiplier) * (double)this.roundMultiplier;
            }
        }
        throw new StatementExecutionException("unhandled function " + this.name);
    }

    @Override
    public void validate(StatementEvaluationContext context) throws StatementExecutionException {
        if (this.parameters != null) {
            this.parameters.forEach(expression -> expression.validate(context));
        }
    }
}

