/*
 * Decompiled with CFR 0.152.
 */
package herddb.sql.expressions;

import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.sql.expressions.CompiledSQLExpression;
import herddb.utils.DataAccessor;
import herddb.utils.SQLRecordPredicateFunctions;
import java.util.List;
import java.util.Map;

public class CompiledCaseExpression
implements CompiledSQLExpression {
    private final List<Map.Entry<CompiledSQLExpression, CompiledSQLExpression>> whenExpressions;
    private final CompiledSQLExpression elseExpression;

    public CompiledCaseExpression(List<Map.Entry<CompiledSQLExpression, CompiledSQLExpression>> whenExpressions, CompiledSQLExpression elseExpression) {
        this.whenExpressions = whenExpressions;
        this.elseExpression = elseExpression;
    }

    @Override
    public Object evaluate(DataAccessor bean, StatementEvaluationContext context) throws StatementExecutionException {
        if (this.whenExpressions != null) {
            for (Map.Entry<CompiledSQLExpression, CompiledSQLExpression> entry : this.whenExpressions) {
                Object whenValue = entry.getKey().evaluate(bean, context);
                if (!SQLRecordPredicateFunctions.toBoolean((Object)whenValue)) continue;
                return entry.getValue().evaluate(bean, context);
            }
        }
        if (this.elseExpression != null) {
            return this.elseExpression.evaluate(bean, context);
        }
        return null;
    }

    @Override
    public void validate(StatementEvaluationContext context) throws StatementExecutionException {
        if (this.whenExpressions != null) {
            for (Map.Entry<CompiledSQLExpression, CompiledSQLExpression> entry : this.whenExpressions) {
                entry.getKey().validate(context);
                entry.getValue().validate(context);
            }
        }
        if (this.elseExpression != null) {
            this.elseExpression.validate(context);
        }
    }
}

