/*
 * Decompiled with CFR 0.152.
 */
package herddb.sql;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import herddb.model.ExecutionPlan;
import herddb.utils.IntHolder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PlansCache {
    private static final Logger LOG;
    private final Cache<String, ExecutionPlanContainer> cache;
    private static final boolean KRYO_AVAILABLE;

    public PlansCache(long maxBytes) {
        LOG.log(Level.INFO, "Max query plan cache size: {0} bytes", maxBytes + "");
        this.cache = CacheBuilder.newBuilder().recordStats().weigher((sql, plan) -> ((ExecutionPlanContainer)plan).weight).maximumWeight(maxBytes).removalListener(notification -> LOG.log(Level.FINE, "Removed query {0} -> {1} size {2} bytes", new Object[]{notification.getCause(), notification.getKey(), ((ExecutionPlanContainer)notification.getValue()).weight})).build();
    }

    public long getCacheSize() {
        return this.cache.size();
    }

    public long getCacheHits() {
        return this.cache.stats().hitCount();
    }

    public long getCacheMisses() {
        return this.cache.stats().missCount();
    }

    public ExecutionPlan get(String sql) {
        ExecutionPlanContainer res = (ExecutionPlanContainer)this.cache.getIfPresent((Object)sql);
        return res != null ? res.plan : null;
    }

    public void put(String sql, ExecutionPlan statement) {
        this.cache.put((Object)sql, (Object)new ExecutionPlanContainer(statement));
    }

    public void clear() {
        this.cache.invalidateAll();
    }

    static {
        boolean _KRYO_AVAILABLE;
        LOG = Logger.getLogger(PlansCache.class.getName());
        try {
            new Kryo().writeObject(new Output((OutputStream)new ByteArrayOutputStream()), (Object)"");
            _KRYO_AVAILABLE = true;
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, "Kryo is not available", t);
            _KRYO_AVAILABLE = false;
        }
        KRYO_AVAILABLE = _KRYO_AVAILABLE;
    }

    private static class ExecutionPlanContainer {
        private final ExecutionPlan plan;
        private final int weight;

        public ExecutionPlanContainer(ExecutionPlan plan) {
            this.plan = plan;
            this.weight = this.computeWeigth(plan);
        }

        private int computeWeigth(ExecutionPlan plan) {
            if (!KRYO_AVAILABLE) {
                return 1;
            }
            Kryo kryo = new Kryo();
            final IntHolder res = new IntHolder();
            try (Output oo = new Output(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    ++res.value;
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    res.value += len;
                }

                @Override
                public void write(byte[] b) throws IOException {
                    res.value += b.length;
                }
            });){
                kryo.writeObject(oo, (Object)plan);
            }
            return res.value;
        }
    }
}

