/*
 * Decompiled with CFR 0.152.
 */
package herddb.server;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalNodeIdManager {
    private static final Logger LOG = Logger.getLogger(LocalNodeIdManager.class.getName());
    private final Path dataPath;

    public LocalNodeIdManager(Path dataPath) {
        this.dataPath = dataPath;
    }

    public String readLocalNodeId() throws IOException {
        Path file = this.dataPath.resolve("nodeid");
        try {
            LOG.log(Level.INFO, "Looking for local node id into file {0}", file);
            if (!Files.isRegularFile(file, new LinkOption[0])) {
                LOG.log(Level.SEVERE, "Cannot find file {0}", file);
                return null;
            }
            List<String> lines = Files.readAllLines(file, StandardCharsets.UTF_8);
            for (String line : lines) {
                if ((line = line.trim().toLowerCase()).startsWith("#") || line.isEmpty()) continue;
                return line;
            }
            throw new IOException("Cannot find any valid line inside file " + file.toAbsolutePath());
        }
        catch (IOException error) {
            LOG.log(Level.SEVERE, "Error while reading file " + file.toAbsolutePath(), error);
            throw error;
        }
    }

    public void persistLocalNodeId(String nodeId) throws IOException {
        Files.createDirectories(this.dataPath, new FileAttribute[0]);
        Path file = this.dataPath.resolve("nodeid");
        StringBuilder message = new StringBuilder();
        message.append("# This file contains the id of this node\n");
        message.append("# Do not change the contents of this file, otherwise the beheaviour of the system will\n");
        message.append("# lead eventually to data loss\n");
        message.append("# \n");
        message.append("# Any line which starts with '#' and and blank line will be ignored\n");
        message.append("# The system will consider the first non-blank line as node id, making it lowercase\n");
        message.append("\n\n");
        message.append(nodeId);
        Files.write(file, message.toString().getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE_NEW);
    }
}

