/*
 * Decompiled with CFR 0.152.
 */
package herddb.security.sasl;

import herddb.security.sasl.SaslUtils;
import herddb.server.Server;
import java.io.IOException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.zookeeper.server.auth.KerberosName;

public class SaslNettyServer {
    private static final Logger LOG = Logger.getLogger(SaslNettyServer.class.getName());
    private static final String JASS_SERVER_SECTION = "HerdDBServer";
    private SaslServer saslServer;
    private Server server;

    public SaslNettyServer(Server server, String mech) throws IOException {
        this.server = server;
        try {
            Subject subject = this.loginServer();
            this.saslServer = this.createSaslServer(mech, subject);
            if (this.saslServer == null) {
                throw new IOException("Cannot create JVM SASL Server");
            }
        }
        catch (Exception e) {
            LOG.severe("SaslNettyServer: Could not create SaslServer: " + e);
            throw new IOException(e);
        }
    }

    private SaslServer createSaslServer(String mech, Subject subject) throws IOException {
        if (subject == null) {
            SaslDigestCallbackHandler ch = new SaslDigestCallbackHandler();
            return Sasl.createSaslServer(mech, null, "default", SaslUtils.getSaslProps(), ch);
        }
        final SaslServerCallbackHandler callbackHandler = new SaslServerCallbackHandler(Configuration.getConfiguration());
        if (subject.getPrincipals().size() > 0) {
            try {
                String serviceHostname;
                String servicePrincipalName;
                Object[] principals = subject.getPrincipals().toArray();
                Principal servicePrincipal = (Principal)principals[0];
                String servicePrincipalNameAndHostname = servicePrincipal.getName();
                int indexOf = servicePrincipalNameAndHostname.indexOf("/");
                String serviceHostnameAndKerbDomain = servicePrincipalNameAndHostname.substring(indexOf + 1);
                int indexOfAt = serviceHostnameAndKerbDomain.indexOf("@");
                if (indexOf > 0) {
                    servicePrincipalName = servicePrincipalNameAndHostname.substring(0, indexOf);
                    serviceHostname = serviceHostnameAndKerbDomain.substring(0, indexOfAt);
                } else {
                    servicePrincipalName = servicePrincipalNameAndHostname.substring(0, indexOfAt);
                    serviceHostname = null;
                }
                String _mech = "GSSAPI";
                LOG.log(Level.INFO, "serviceHostname is ''{0}'', servicePrincipalName is ''{1}'', SASL mechanism(mech) is ''GSSAPI'', Subject is ''{2}''", new Object[]{serviceHostname, servicePrincipalName, subject});
                try {
                    return Subject.doAs(subject, new PrivilegedExceptionAction<SaslServer>(){

                        @Override
                        public SaslServer run() {
                            try {
                                SaslServer saslServer = Sasl.createSaslServer("GSSAPI", servicePrincipalName, serviceHostname, null, callbackHandler);
                                return saslServer;
                            }
                            catch (SaslException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    e.printStackTrace();
                }
            }
            catch (IndexOutOfBoundsException e) {
                throw new RuntimeException(e);
            }
        } else {
            try {
                SaslServer saslServer = Sasl.createSaslServer("DIGEST-MD5", "herddb", "herddb", null, callbackHandler);
                return saslServer;
            }
            catch (SaslException e) {
                e.printStackTrace();
            }
        }
        LOG.severe("failed to create saslServer object.");
        return null;
    }

    private Subject loginServer() throws SaslException, PrivilegedActionException, LoginException {
        AppConfigurationEntry[] entries = Configuration.getConfiguration().getAppConfigurationEntry(JASS_SERVER_SECTION);
        if (entries == null) {
            return null;
        }
        LoginContext loginContext = new LoginContext(JASS_SERVER_SECTION, new ClientCallbackHandler(null));
        loginContext.login();
        return loginContext.getSubject();
    }

    public boolean isComplete() {
        return this.saslServer.isComplete();
    }

    public String getUserName() {
        return this.saslServer.getAuthorizationID();
    }

    public byte[] response(byte[] token) throws SaslException {
        try {
            byte[] retval = this.saslServer.evaluateResponse(token);
            return retval;
        }
        catch (SaslException e) {
            LOG.severe("response: Failed to evaluate client token of length: " + token.length + " : " + e);
            throw e;
        }
    }

    private class SaslDigestCallbackHandler
    implements CallbackHandler {
        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            String expectedPassword;
            NameCallback nc = null;
            PasswordCallback pc = null;
            AuthorizeCallback ac = null;
            for (Callback callback : callbacks) {
                if (callback instanceof AuthorizeCallback) {
                    ac = (AuthorizeCallback)callback;
                    continue;
                }
                if (callback instanceof NameCallback) {
                    nc = (NameCallback)callback;
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    pc = (PasswordCallback)callback;
                    continue;
                }
                if (callback instanceof RealmCallback) continue;
                throw new UnsupportedCallbackException(callback, "handle: Unrecognized SASL DIGEST-MD5 Callback");
            }
            String authenticatingUser = null;
            if (nc != null) {
                authenticatingUser = nc.getDefaultName();
                LOG.finest("SASL server auth user " + authenticatingUser);
                nc.setName(nc.getDefaultName());
            }
            if (pc != null && (expectedPassword = SaslNettyServer.this.server.getUserManager().getExpectedPassword(authenticatingUser)) != null) {
                pc.setPassword(expectedPassword.toCharArray());
            }
            if (ac != null) {
                String authzid;
                String authid = ac.getAuthenticationID();
                if (authid.equals(authzid = ac.getAuthorizationID())) {
                    ac.setAuthorized(true);
                } else {
                    ac.setAuthorized(false);
                }
                if (ac.isAuthorized()) {
                    ac.setAuthorizedID(authzid);
                }
            }
        }
    }

    private static class SaslServerCallbackHandler
    implements CallbackHandler {
        private static final String USER_PREFIX = "user_";
        private String userName;
        private final Map<String, String> credentials = new HashMap<String, String>();

        public SaslServerCallbackHandler(Configuration configuration) throws IOException {
            AppConfigurationEntry[] configurationEntries = configuration.getAppConfigurationEntry(SaslNettyServer.JASS_SERVER_SECTION);
            if (configurationEntries == null) {
                String errorMessage = "Could not find a 'HerdDBServer' entry in this configuration: Server cannot start.";
                throw new IOException(errorMessage);
            }
            this.credentials.clear();
            for (AppConfigurationEntry entry : configurationEntries) {
                Map<String, ?> options = entry.getOptions();
                for (Map.Entry<String, ?> pair : options.entrySet()) {
                    String key = pair.getKey();
                    if (!key.startsWith(USER_PREFIX)) continue;
                    String userName = key.substring(USER_PREFIX.length());
                    this.credentials.put(userName, (String)pair.getValue());
                }
            }
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    this.handleNameCallback((NameCallback)callback);
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    this.handlePasswordCallback((PasswordCallback)callback);
                    continue;
                }
                if (callback instanceof RealmCallback) {
                    this.handleRealmCallback((RealmCallback)callback);
                    continue;
                }
                if (!(callback instanceof AuthorizeCallback)) continue;
                this.handleAuthorizeCallback((AuthorizeCallback)callback);
            }
        }

        private void handleNameCallback(NameCallback nc) {
            if (this.credentials.get(nc.getDefaultName()) == null) {
                LOG.severe("User '" + nc.getDefaultName() + "' not found in list of JAAS DIGEST-MD5 users.");
                return;
            }
            nc.setName(nc.getDefaultName());
            this.userName = nc.getDefaultName();
        }

        private void handlePasswordCallback(PasswordCallback pc) {
            if (this.credentials.containsKey(this.userName)) {
                pc.setPassword(this.credentials.get(this.userName).toCharArray());
            } else {
                LOG.severe("No password found for user: " + this.userName);
            }
        }

        private void handleRealmCallback(RealmCallback rc) {
            LOG.info("client supplied realm: " + rc.getDefaultText());
            rc.setText(rc.getDefaultText());
        }

        private void handleAuthorizeCallback(AuthorizeCallback ac) {
            String authenticationID = ac.getAuthenticationID();
            String authorizationID = ac.getAuthorizationID();
            LOG.info("Successfully authenticated client: authenticationID=" + authenticationID + ";  authorizationID=" + authorizationID + ".");
            ac.setAuthorized(true);
            KerberosName kerberosName = new KerberosName(authenticationID);
            try {
                StringBuilder userNameBuilder = new StringBuilder(kerberosName.getShortName());
                userNameBuilder.append("/").append(kerberosName.getHostName());
                userNameBuilder.append("@").append(kerberosName.getRealm());
                LOG.info("Setting authorizedID: " + userNameBuilder);
                ac.setAuthorizedID(userNameBuilder.toString());
            }
            catch (IOException e) {
                LOG.severe("Failed to set name based on Kerberos authentication rules.");
            }
        }
    }

    private static class ClientCallbackHandler
    implements CallbackHandler {
        private String password = null;

        public ClientCallbackHandler(String password) {
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callback;
                    nc.setName(nc.getDefaultName());
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)callback;
                    if (this.password == null) continue;
                    pc.setPassword(this.password.toCharArray());
                    continue;
                }
                if (callback instanceof RealmCallback) {
                    RealmCallback rc = (RealmCallback)callback;
                    rc.setText(rc.getDefaultText());
                    continue;
                }
                if (callback instanceof AuthorizeCallback) {
                    String authzid;
                    AuthorizeCallback ac = (AuthorizeCallback)callback;
                    String authid = ac.getAuthenticationID();
                    if (authid.equals(authzid = ac.getAuthorizationID())) {
                        ac.setAuthorized(true);
                    } else {
                        ac.setAuthorized(false);
                    }
                    if (!ac.isAuthorized()) continue;
                    ac.setAuthorizedID(authzid);
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "Unrecognized SASL ClientCallback");
            }
        }
    }
}

