/*
 * Decompiled with CFR 0.152.
 */
package herddb.model.planner;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import herddb.core.TableSpaceManager;
import herddb.model.Column;
import herddb.model.DataScanner;
import herddb.model.DataScannerException;
import herddb.model.ScanResult;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.model.StatementExecutionResult;
import herddb.model.Transaction;
import herddb.model.TransactionContext;
import herddb.model.Tuple;
import herddb.model.planner.PlannerOp;
import herddb.sql.expressions.CompiledSQLExpression;
import herddb.utils.DataAccessor;
import java.util.Iterator;
import java.util.List;

@SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
public class ValuesOp
implements PlannerOp {
    private final String tablespace;
    private final String[] fieldNames;
    private final Column[] columns;
    private final List<List<CompiledSQLExpression>> tuples;

    public ValuesOp(String tablespace, String[] fieldNames, Column[] columns, List<List<CompiledSQLExpression>> tuples) {
        this.tablespace = tablespace;
        this.fieldNames = fieldNames;
        this.columns = columns;
        this.tuples = tuples;
    }

    @Override
    public String getTablespace() {
        return this.tablespace;
    }

    @Override
    public StatementExecutionResult execute(TableSpaceManager tableSpaceManager, TransactionContext transactionContext, final StatementEvaluationContext context, boolean lockRequired, boolean forWrite) throws StatementExecutionException {
        final Iterator<List<CompiledSQLExpression>> it = this.tuples.iterator();
        Transaction transaction = tableSpaceManager.getTransaction(transactionContext.transactionId);
        DataScanner res = new DataScanner(transaction, this.fieldNames, this.columns){

            @Override
            public boolean hasNext() throws DataScannerException {
                return it.hasNext();
            }

            @Override
            public DataAccessor next() throws DataScannerException {
                Object[] values = new Object[ValuesOp.this.fieldNames.length];
                List tuple = (List)it.next();
                for (int i = 0; i < values.length; ++i) {
                    Object value;
                    values[i] = value = ((CompiledSQLExpression)tuple.get(i)).evaluate(DataAccessor.NULL, context);
                }
                return new Tuple(ValuesOp.this.fieldNames, values);
            }
        };
        return new ScanResult(transactionContext.transactionId, res);
    }
}

