/*
 * Decompiled with CFR 0.152.
 */
package herddb.model.planner;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import herddb.core.TableSpaceManager;
import herddb.model.Column;
import herddb.model.ScanResult;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.model.StatementExecutionResult;
import herddb.model.TransactionContext;
import herddb.model.planner.EnumerableDataScanner;
import herddb.model.planner.JoinKey;
import herddb.model.planner.PlannerOp;
import herddb.utils.DataAccessor;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.EnumerableDefaults;

@SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
public class SemiJoinOp
implements PlannerOp {
    private final int[] leftKeys;
    private final PlannerOp left;
    private final int[] rightKeys;
    private final PlannerOp right;
    private final String[] fieldNames;
    private final Column[] columns;

    public SemiJoinOp(String[] fieldNames, Column[] columns, int[] leftKeys, PlannerOp left, int[] rightKeys, PlannerOp right) {
        this.fieldNames = fieldNames;
        this.columns = columns;
        this.leftKeys = leftKeys;
        this.left = left.optimize();
        this.rightKeys = rightKeys;
        this.right = right.optimize();
    }

    @Override
    public String getTablespace() {
        return this.left.getTablespace();
    }

    @Override
    public StatementExecutionResult execute(TableSpaceManager tableSpaceManager, TransactionContext transactionContext, StatementEvaluationContext context, boolean lockRequired, boolean forWrite) throws StatementExecutionException {
        ScanResult resLeft = (ScanResult)this.left.execute(tableSpaceManager, transactionContext, context, lockRequired, forWrite);
        transactionContext = new TransactionContext(resLeft.transactionId);
        ScanResult resRight = (ScanResult)this.right.execute(tableSpaceManager, transactionContext, context, lockRequired, forWrite);
        long resTransactionId = resRight.transactionId;
        Enumerable result = EnumerableDefaults.semiJoin(resLeft.dataScanner.createRewindOnCloseEnumerable(), resRight.dataScanner.createRewindOnCloseEnumerable(), JoinKey.keyExtractor(this.leftKeys), JoinKey.keyExtractor(this.rightKeys));
        EnumerableDataScanner joinedScanner = new EnumerableDataScanner(resRight.dataScanner.getTransaction(), this.fieldNames, this.columns, (Enumerable<DataAccessor>)result, resLeft.dataScanner, resRight.dataScanner);
        return new ScanResult(resTransactionId, joinedScanner);
    }
}

