/*
 * Decompiled with CFR 0.152.
 */
package herddb.model.planner;

import herddb.core.HerdDBInternalException;
import herddb.core.TableSpaceManager;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.model.StatementExecutionResult;
import herddb.model.TransactionContext;
import herddb.utils.Wrapper;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.bookkeeper.common.concurrent.FutureUtils;

public interface PlannerOp
extends Wrapper {
    public String getTablespace();

    default public StatementExecutionResult execute(TableSpaceManager tableSpaceManager, TransactionContext transactionContext, StatementEvaluationContext context, boolean lockRequired, boolean forWrite) throws StatementExecutionException {
        CompletableFuture<StatementExecutionResult> res = this.executeAsync(tableSpaceManager, transactionContext, context, lockRequired, forWrite);
        try {
            return res.get();
        }
        catch (InterruptedException err) {
            Thread.currentThread().interrupt();
            throw new StatementExecutionException(err);
        }
        catch (ExecutionException err) {
            Throwable cause = err.getCause();
            if (cause instanceof HerdDBInternalException && cause.getCause() != null) {
                cause = cause.getCause();
            }
            if (cause instanceof StatementExecutionException) {
                throw (StatementExecutionException)((Object)cause);
            }
            throw new StatementExecutionException(cause);
        }
        catch (Throwable t) {
            throw new StatementExecutionException(t);
        }
    }

    default public CompletableFuture<StatementExecutionResult> executeAsync(TableSpaceManager tableSpaceManager, TransactionContext transactionContext, StatementEvaluationContext context, boolean lockRequired, boolean forWrite) {
        try {
            return CompletableFuture.completedFuture(this.execute(tableSpaceManager, transactionContext, context, lockRequired, forWrite));
        }
        catch (StatementExecutionException err) {
            return FutureUtils.exception((Throwable)((Object)err));
        }
        catch (RuntimeException err) {
            return FutureUtils.exception((Throwable)((Object)new StatementExecutionException(err)));
        }
    }

    default public PlannerOp optimize() {
        return this;
    }

    default public boolean isSimpleStatementWrapper() {
        return false;
    }
}

