/*
 * Decompiled with CFR 0.152.
 */
package herddb.model.planner;

import herddb.core.TableSpaceManager;
import herddb.model.DataScanner;
import herddb.model.ScanResult;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.model.StatementExecutionResult;
import herddb.model.TransactionContext;
import herddb.model.commands.ScanStatement;
import herddb.model.planner.PlannerOp;
import herddb.utils.Wrapper;

public class LimitedSortedBindableTableScanOp
implements PlannerOp {
    final ScanStatement statement;

    public LimitedSortedBindableTableScanOp(ScanStatement scan) {
        this.statement = scan;
    }

    @Override
    public String getTablespace() {
        return this.statement.getTableSpace();
    }

    public ScanStatement getStatement() {
        return this.statement;
    }

    @Override
    public StatementExecutionResult execute(TableSpaceManager tableSpaceManager, TransactionContext transactionContext, StatementEvaluationContext context, boolean lockRequired, boolean forWrite) throws StatementExecutionException {
        DataScanner scan = tableSpaceManager.scan(this.statement, context, transactionContext, lockRequired, forWrite);
        return new ScanResult(transactionContext.transactionId, scan);
    }

    public <T> T unwrap(Class<T> clazz) {
        Object unwrapped = this.statement.unwrap(clazz);
        if (unwrapped != null) {
            return (T)unwrapped;
        }
        return (T)Wrapper.unwrap((Object)this, clazz);
    }

    public String toString() {
        return "LimitedSortedBindableTableScanOp{statement=" + this.statement + '}';
    }
}

