/*
 * Decompiled with CFR 0.152.
 */
package herddb.model.planner;

import herddb.core.TableSpaceManager;
import herddb.model.DataScanner;
import herddb.model.DataScannerException;
import herddb.model.LimitedDataScanner;
import herddb.model.ScanLimits;
import herddb.model.ScanResult;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.model.StatementExecutionResult;
import herddb.model.TransactionContext;
import herddb.model.commands.ScanStatement;
import herddb.model.planner.BindableTableScanOp;
import herddb.model.planner.LimitedBindableTableScanOp;
import herddb.model.planner.LimitedSortedBindableTableScanOp;
import herddb.model.planner.PlannerOp;
import herddb.model.planner.SortedBindableTableScanOp;
import herddb.sql.expressions.CompiledSQLExpression;
import herddb.utils.DataAccessor;
import herddb.utils.Wrapper;

public class LimitOp
implements PlannerOp,
ScanLimits {
    private final PlannerOp input;
    private final CompiledSQLExpression maxRows;
    private final CompiledSQLExpression offset;

    public LimitOp(PlannerOp input, CompiledSQLExpression maxRows, CompiledSQLExpression offset) {
        this.input = input.optimize();
        this.maxRows = maxRows;
        this.offset = offset;
    }

    @Override
    public String getTablespace() {
        return this.input.getTablespace();
    }

    public <T> T unwrap(Class<T> clazz) {
        Object unwrapped = this.input.unwrap(clazz);
        if (unwrapped != null) {
            return (T)unwrapped;
        }
        return (T)Wrapper.unwrap((Object)this, clazz);
    }

    @Override
    public StatementExecutionResult execute(TableSpaceManager tableSpaceManager, TransactionContext transactionContext, StatementEvaluationContext context, boolean lockRequired, boolean forWrite) throws StatementExecutionException {
        try {
            StatementExecutionResult input = this.input.execute(tableSpaceManager, transactionContext, context, lockRequired, forWrite);
            ScanResult downstreamScanResult = (ScanResult)input;
            DataScanner inputScanner = downstreamScanResult.dataScanner;
            int offset = this.computeOffset(context);
            int maxrows = this.computeMaxRows(context);
            if (maxrows <= 0 && offset == 0) {
                return downstreamScanResult;
            }
            LimitedDataScanner limited = new LimitedDataScanner(inputScanner, maxrows, offset, context);
            return new ScanResult(downstreamScanResult.transactionId, limited);
        }
        catch (DataScannerException ex) {
            throw new StatementExecutionException(ex);
        }
    }

    @Override
    public int computeMaxRows(StatementEvaluationContext context) throws StatementExecutionException {
        return this.maxRows == null ? -1 : ((Number)this.maxRows.evaluate(DataAccessor.NULL, context)).intValue();
    }

    @Override
    public int computeOffset(StatementEvaluationContext context) throws StatementExecutionException {
        return this.offset == null ? 0 : ((Number)this.offset.evaluate(DataAccessor.NULL, context)).intValue();
    }

    @Override
    public PlannerOp optimize() {
        if (this.input instanceof SortedBindableTableScanOp) {
            SortedBindableTableScanOp op = (SortedBindableTableScanOp)this.input;
            ScanStatement statement = op.getStatement();
            statement.setLimits(this);
            return new LimitedSortedBindableTableScanOp(statement);
        }
        if (this.input instanceof BindableTableScanOp) {
            BindableTableScanOp op = (BindableTableScanOp)this.input;
            ScanStatement statement = op.getStatement();
            statement.setLimits(this);
            return new LimitedBindableTableScanOp(statement);
        }
        return this;
    }
}

