/*
 * Decompiled with CFR 0.152.
 */
package herddb.model.planner;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import herddb.utils.DataAccessor;
import herddb.utils.SQLRecordPredicateFunctions;
import java.util.Arrays;
import java.util.Objects;
import org.apache.calcite.linq4j.function.Function1;

@SuppressFBWarnings(value={"BC_EQUALS_METHOD_SHOULD_WORK_FOR_ALL_OBJECTS"})
class JoinKey
implements Comparable<JoinKey> {
    private final DataAccessor dataAccessor;
    private final int[] selectedFields;
    private int hashcode = Integer.MIN_VALUE;

    public static Function1<DataAccessor, JoinKey> keyExtractor(int[] projection) {
        return a -> new JoinKey((DataAccessor)a, projection);
    }

    public JoinKey(DataAccessor dataAccessor, int[] selectedFields) {
        this.dataAccessor = dataAccessor;
        this.selectedFields = selectedFields;
    }

    public Object get(int i) {
        return this.dataAccessor.get(this.selectedFields[i]);
    }

    public boolean equals(Object obj) {
        JoinKey da = (JoinKey)obj;
        int size = this.selectedFields.length;
        for (int i = 0; i < size; ++i) {
            Object fromThat;
            Object fromThis = this.get(i);
            if (SQLRecordPredicateFunctions.compare((Object)fromThis, (Object)(fromThat = da.get(i))) == 0) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hashcode == Integer.MIN_VALUE) {
            int size = this.selectedFields.length;
            int res = 0;
            for (int i = 0; i < size; ++i) {
                res += Objects.hashCode(this.get(i));
            }
            this.hashcode = res;
        }
        return this.hashcode;
    }

    @Override
    public int compareTo(JoinKey o) {
        JoinKey da = o;
        int size = this.selectedFields.length;
        for (int i = 0; i < size; ++i) {
            Object fromObj;
            Object fromThis = this.get(i);
            int res = SQLRecordPredicateFunctions.compare((Object)fromThis, (Object)(fromObj = da.get(i)));
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    public String toString() {
        return "RecordKey{dataAccessor=" + this.dataAccessor + ", selectedFields=" + Arrays.toString(this.selectedFields) + '}';
    }
}

