/*
 * Decompiled with CFR 0.152.
 */
package herddb.model;

import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import herddb.model.Column;
import herddb.model.ColumnsList;
import herddb.model.commands.AlterTableStatement;
import herddb.sql.expressions.BindableTableScanColumnNameResolver;
import herddb.utils.ExtendedDataInputStream;
import herddb.utils.ExtendedDataOutputStream;
import herddb.utils.SimpleByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public class Table
implements ColumnsList,
BindableTableScanColumnNameResolver {
    private static final Logger LOG = Logger.getLogger(Table.class.getName());
    public final String uuid;
    public final String name;
    public final String tablespace;
    public final Column[] columns;
    public final String[] columnNames;
    public final Map<String, Column> columnsByName;
    public final Map<Integer, Column> columnsBySerialPosition;
    public final String[] primaryKey;
    public final int[] primaryKeyProjection;
    public final boolean auto_increment;
    private final Set<String> primaryKeyColumns;
    public final int maxSerialPosition;
    public final boolean physicalLayoutLikeLogicalLayout;

    private Table(String uuid, String name, Column[] columns, String[] primaryKey, String tablespace, boolean auto_increment, int maxSerialPosition) {
        this.uuid = uuid;
        this.name = name;
        this.columns = columns;
        this.maxSerialPosition = maxSerialPosition;
        this.primaryKey = primaryKey;
        this.tablespace = tablespace;
        this.columnsByName = new HashMap<String, Column>();
        this.columnsBySerialPosition = new HashMap<Integer, Column>();
        this.auto_increment = auto_increment;
        this.columnNames = new String[columns.length];
        int i = 0;
        this.primaryKeyProjection = new int[columns.length];
        for (Column c : this.columns) {
            String cname = c.name.toLowerCase();
            this.columnsByName.put(cname, c);
            if (c.serialPosition < 0) {
                throw new IllegalArgumentException();
            }
            this.columnsBySerialPosition.put(c.serialPosition, c);
            this.columnNames[i] = cname;
            this.primaryKeyProjection[i] = Table.findPositionInArray(cname, primaryKey);
            ++i;
        }
        this.primaryKeyColumns = ImmutableSet.builder().addAll(Arrays.asList(primaryKey)).build();
        boolean primaryKeyIsInKeyAndOrdered = true;
        for (int k = 0; k < primaryKey.length; ++k) {
            if (this.columnNames[k].equals(primaryKey[k])) continue;
            primaryKeyIsInKeyAndOrdered = false;
        }
        boolean columnsOrderedAsInPhysicalOrder = false;
        List<String> columnsNamesAsList = Arrays.asList(this.columnNames);
        ArrayList<String> columnsNamesOrderedBySerialPosition = new ArrayList<String>(columnsNamesAsList);
        columnsNamesOrderedBySerialPosition.sort(Comparator.comparingInt(s -> this.columnsByName.get((Object)s).serialPosition));
        columnsOrderedAsInPhysicalOrder = columnsNamesOrderedBySerialPosition.equals(columnsNamesAsList);
        boolean bl = this.physicalLayoutLikeLogicalLayout = primaryKeyIsInKeyAndOrdered && columnsOrderedAsInPhysicalOrder;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "Table: ", tablespace + "." + name + "\nColumns: " + columnsNamesAsList + "\nPrimaryKey: " + Arrays.asList(primaryKey) + "\nColumns ordered physically: " + columnsNamesOrderedBySerialPosition + "\nPrimaryKeyIsInKeyAndOrdered: " + primaryKeyIsInKeyAndOrdered + "\nColumnsOrderedAsInPhysicalOrder: " + columnsOrderedAsInPhysicalOrder + "\nPhysicalLayoutLikeLogicalLayout: " + this.physicalLayoutLikeLogicalLayout + "\n");
        }
    }

    public boolean isPrimaryKeyColumn(String column) {
        return this.primaryKeyColumns.contains(column);
    }

    public boolean isPrimaryKeyColumn(int index) {
        return this.primaryKeyProjection[index] >= 0;
    }

    public static Builder builder() {
        return new Builder();
    }

    @SuppressFBWarnings(value={"OS_OPEN_STREAM"})
    public static Table deserialize(byte[] data) {
        try {
            SimpleByteArrayInputStream ii = new SimpleByteArrayInputStream(data);
            ExtendedDataInputStream dii = new ExtendedDataInputStream((InputStream)ii);
            long tversion = dii.readVLong();
            long tflags = dii.readVLong();
            if (tversion != 1L || tflags != 0L) {
                throw new IOException("corrupted table file");
            }
            String tablespace = dii.readUTF();
            String name = dii.readUTF();
            String uuid = dii.readUTF();
            boolean auto_increment = dii.readByte() > 0;
            int maxSerialPosition = dii.readVInt();
            int pkcols = dii.readByte();
            String[] primaryKey = new String[pkcols];
            for (int i = 0; i < pkcols; ++i) {
                primaryKey[i] = dii.readUTF();
            }
            dii.readVInt();
            int ncols = dii.readVInt();
            Column[] columns = new Column[ncols];
            for (int i = 0; i < ncols; ++i) {
                long cversion = dii.readVLong();
                long cflags = dii.readVLong();
                if (cversion != 1L || cflags != 0L) {
                    throw new IOException("corrupted table file");
                }
                String cname = dii.readUTF();
                int type = dii.readVInt();
                int serialPosition = dii.readVInt();
                columns[i] = Column.column(cname, type, serialPosition);
            }
            return new Table(uuid, name, columns, primaryKey, tablespace, auto_increment, maxSerialPosition);
        }
        catch (IOException err) {
            throw new IllegalArgumentException(err);
        }
    }

    public byte[] serialize() {
        ByteArrayOutputStream oo = new ByteArrayOutputStream();
        try (ExtendedDataOutputStream doo = new ExtendedDataOutputStream((OutputStream)oo);){
            doo.writeVLong(1L);
            doo.writeVLong(0L);
            doo.writeUTF(this.tablespace);
            doo.writeUTF(this.name);
            doo.writeUTF(this.uuid);
            doo.writeByte(this.auto_increment ? 1 : 0);
            doo.writeVInt(this.maxSerialPosition);
            doo.writeByte(this.primaryKey.length);
            for (String primaryKeyColumn : this.primaryKey) {
                doo.writeUTF(primaryKeyColumn);
            }
            doo.writeVInt(0);
            doo.writeVInt(this.columns.length);
            for (Column c : this.columns) {
                doo.writeVLong(1L);
                doo.writeVLong(0L);
                doo.writeUTF(c.name);
                doo.writeVInt(c.type);
                doo.writeVInt(c.serialPosition);
            }
        }
        catch (IOException ee) {
            throw new RuntimeException(ee);
        }
        return oo.toByteArray();
    }

    @Override
    public Column getColumn(String cname) {
        return this.columnsByName.get(cname);
    }

    @Override
    public Column[] getColumns() {
        return this.columns;
    }

    @Override
    public Column resolveColumName(int columnReference) {
        return this.columns[columnReference];
    }

    @Override
    public String[] getPrimaryKey() {
        return this.primaryKey;
    }

    public Table applyAlterTable(AlterTableStatement alterTableStatement) {
        int new_maxSerialPosition = this.maxSerialPosition;
        String newTableName = alterTableStatement.getNewTableName() != null ? alterTableStatement.getNewTableName().toLowerCase() : this.name;
        Builder builder = Table.builder().name(newTableName).uuid(this.uuid).tablespace(this.tablespace);
        List dropColumns = alterTableStatement.getDropColumns().stream().map(String::toLowerCase).collect(Collectors.toList());
        for (String dropColumn : dropColumns) {
            if (this.getColumn(dropColumn) == null) {
                throw new IllegalArgumentException("column " + dropColumn + " not found int table " + this.name);
            }
            if (!this.isPrimaryKeyColumn(dropColumn)) continue;
            throw new IllegalArgumentException("column " + dropColumn + " cannot be dropped because is part of the primary key of table " + this.name);
        }
        HashSet<String> changedColumns = new HashSet<String>();
        Map realStructure = Stream.of(this.columns).collect(Collectors.toMap(t -> t.serialPosition, Function.identity()));
        if (alterTableStatement.getModifyColumns() != null) {
            for (Column newColumn : alterTableStatement.getModifyColumns()) {
                Column oldColumn = (Column)realStructure.get(newColumn.serialPosition);
                if (oldColumn == null) {
                    throw new IllegalArgumentException("column " + newColumn.name + " not found int table " + this.name + ", looking for serialPosition = " + newColumn.serialPosition);
                }
                changedColumns.add(oldColumn.name);
            }
        }
        for (Column c : this.columns) {
            String lowercase = c.name.toLowerCase();
            if (!dropColumns.contains(lowercase) && !changedColumns.contains(lowercase)) {
                builder.column(c.name, c.type, c.serialPosition);
            }
            new_maxSerialPosition = Math.max(new_maxSerialPosition, c.serialPosition);
        }
        if (alterTableStatement.getAddColumns() != null) {
            for (Column c : alterTableStatement.getAddColumns()) {
                if (this.getColumn(c.name) != null) {
                    throw new IllegalArgumentException("column " + c.name + " already found int table " + this.name);
                }
                builder.column(c.name, c.type, ++new_maxSerialPosition);
            }
        }
        String[] newPrimaryKey = new String[this.primaryKey.length];
        System.arraycopy(this.primaryKey, 0, newPrimaryKey, 0, this.primaryKey.length);
        if (alterTableStatement.getModifyColumns() != null) {
            for (Column c : alterTableStatement.getModifyColumns()) {
                builder.column(c.name, c.type, c.serialPosition);
                new_maxSerialPosition = Math.max(new_maxSerialPosition, c.serialPosition);
                Column oldcolumn = (Column)realStructure.get(c.serialPosition);
                if (!this.isPrimaryKeyColumn(oldcolumn.name)) continue;
                for (int i = 0; i < newPrimaryKey.length; ++i) {
                    if (!newPrimaryKey[i].equals(oldcolumn.name)) continue;
                    newPrimaryKey[i] = c.name;
                }
            }
        }
        boolean new_auto_increment = alterTableStatement.getChangeAutoIncrement() != null ? alterTableStatement.getChangeAutoIncrement() : this.auto_increment;
        for (String pk : newPrimaryKey) {
            builder.primaryKey(pk, new_auto_increment);
        }
        builder.maxSerialPosition(new_maxSerialPosition);
        return builder.build();
    }

    public Column getColumnBySerialPosition(int serialPosition) {
        return this.columnsBySerialPosition.get(serialPosition);
    }

    public int[] getPrimaryKeyProjection() {
        return this.primaryKeyProjection;
    }

    private static int findPositionInArray(String cname, String[] primaryKey) {
        for (int i = 0; i < primaryKey.length; ++i) {
            if (!primaryKey[i].equals(cname)) continue;
            return i;
        }
        return -1;
    }

    public Column getColumn(int index) {
        return this.columns[index];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Table [name=").append(this.name).append(", tablespace=").append(this.tablespace).append("]");
        return sb.toString();
    }

    public static class Builder {
        private final List<Column> columns = new ArrayList<Column>();
        private String name;
        private String uuid;
        private final List<String> primaryKey = new ArrayList<String>();
        private String tablespace = "herd";
        private boolean auto_increment;
        private int maxSerialPosition = 0;

        private Builder() {
        }

        public Builder uuid(String uuid) {
            this.uuid = uuid.toLowerCase();
            return this;
        }

        public Builder name(String name) {
            this.name = name.toLowerCase();
            return this;
        }

        public Builder maxSerialPosition(int maxSerialPosition) {
            this.maxSerialPosition = maxSerialPosition;
            return this;
        }

        public Builder tablespace(String tablespace) {
            this.tablespace = tablespace;
            return this;
        }

        public Builder primaryKey(String pk) {
            return this.primaryKey(pk, false);
        }

        public Builder primaryKey(String pk, boolean auto_increment) {
            if (pk == null || pk.isEmpty()) {
                throw new IllegalArgumentException();
            }
            if (this.auto_increment && auto_increment) {
                throw new IllegalArgumentException("auto_increment can be used only on one column");
            }
            pk = pk.toLowerCase();
            if (auto_increment) {
                this.auto_increment = true;
            }
            if (!this.primaryKey.contains(pk)) {
                this.primaryKey.add(pk);
            }
            return this;
        }

        public Builder column(String name, int type) {
            if (name == null || name.isEmpty()) {
                throw new IllegalArgumentException();
            }
            String _name = name.toLowerCase();
            if (this.columns.stream().filter(c -> c.name.equals(_name)).findAny().isPresent()) {
                throw new IllegalArgumentException("column " + name + " already exists");
            }
            this.columns.add(Column.column(_name, type, this.maxSerialPosition++));
            return this;
        }

        public Builder column(String name, int type, int serialPosition) {
            if (name == null || name.isEmpty()) {
                throw new IllegalArgumentException();
            }
            String _name = name.toLowerCase();
            if (this.columns.stream().filter(c -> c.name.equals(_name)).findAny().isPresent()) {
                throw new IllegalArgumentException("column " + name + " already exists");
            }
            this.columns.add(Column.column(_name, type, serialPosition));
            return this;
        }

        public Table build() {
            if (this.name == null || this.name.isEmpty()) {
                throw new IllegalArgumentException("name is not defined");
            }
            if (this.uuid == null || this.uuid.isEmpty()) {
                this.uuid = UUID.randomUUID().toString();
            }
            if (this.primaryKey.isEmpty()) {
                throw new IllegalArgumentException("primary key is not defined");
            }
            for (String pkColumn : this.primaryKey) {
                Column pk = this.columns.stream().filter(c -> c.name.equals(pkColumn)).findAny().orElse(null);
                if (pk == null) {
                    throw new IllegalArgumentException("column " + pkColumn + " is not defined in table");
                }
                if (Builder.validatePrimaryKeyDataType(pk.type)) continue;
                throw new IllegalArgumentException("primary key " + pkColumn + " must be a string or long or integer or timestamp");
            }
            this.columns.sort((o1, o2) -> o1.serialPosition - o2.serialPosition);
            return new Table(this.uuid, this.name, this.columns.toArray(new Column[this.columns.size()]), this.primaryKey.toArray(new String[this.primaryKey.size()]), this.tablespace, this.auto_increment, this.maxSerialPosition);
        }

        private static boolean validatePrimaryKeyDataType(int type) {
            switch (type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 11: 
                case 12: 
                case 13: {
                    return true;
                }
            }
            return false;
        }

        public Builder cloning(Table tableSchema) {
            this.columns.addAll(Arrays.asList(tableSchema.columns));
            this.name = tableSchema.name;
            this.uuid = tableSchema.uuid;
            this.primaryKey.addAll(Arrays.asList(tableSchema.primaryKey));
            this.tablespace = tableSchema.tablespace;
            this.auto_increment = tableSchema.auto_increment;
            this.maxSerialPosition = tableSchema.maxSerialPosition;
            return this;
        }
    }
}

