/*
 * Decompiled with CFR 0.152.
 */
package herddb.model;

import herddb.codec.RecordSerializer;
import herddb.model.Table;
import herddb.utils.Bytes;
import herddb.utils.DataAccessor;
import herddb.utils.MapDataAccessor;
import herddb.utils.SizeAwareObject;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Objects;

public final class Record
implements SizeAwareObject {
    private static final long CONSTANT_BYTE_SIZE = 56L;
    public final Bytes key;
    public final Bytes value;
    private WeakReference<Map<String, Object>> cache;

    public static long estimateSize(Bytes key, byte[] value) {
        return key.getEstimatedSize() + Bytes.estimateSize((byte[])value) + 56L;
    }

    public Record(Bytes key, Bytes value) {
        this.key = key;
        this.value = value;
    }

    public Record(Bytes key, Bytes value, Map<String, Object> cache) {
        this.key = key;
        this.value = value;
        this.cache = new WeakReference<Map<String, Object>>(cache);
    }

    private Record(Bytes key, Bytes value, WeakReference<Map<String, Object>> cache) {
        this.key = key;
        this.value = value;
        this.cache = cache;
    }

    public long getEstimatedSize() {
        return this.key.getEstimatedSize() + this.value.getEstimatedSize() + 56L;
    }

    public Record nonShared() {
        if (this.key.isShared() || this.value.isShared()) {
            return new Record(this.key.nonShared(), this.value.nonShared(), this.cache);
        }
        return this;
    }

    public Map<String, Object> toBean(Table table) {
        Map<String, Object> res;
        WeakReference<Map<String, Object>> cachedRef = this.cache;
        Map<String, Object> map = res = cachedRef != null ? (Map<String, Object>)cachedRef.get() : null;
        if (res != null) {
            return res;
        }
        res = RecordSerializer.toBean(this, table);
        this.cache = new WeakReference<Map<String, Object>>(res);
        return res;
    }

    public DataAccessor getDataAccessor(Table table) {
        Map res;
        WeakReference<Map<String, Object>> cachedRef = this.cache;
        Map map = res = cachedRef != null ? (Map)cachedRef.get() : null;
        if (res != null) {
            return new MapDataAccessor(res, table.columnNames);
        }
        return RecordSerializer.buildRawDataAccessor(this, table);
    }

    public String toString() {
        return "Record{key=" + this.key + ", value=" + this.value + '}';
    }

    public void clearCache() {
        this.cache = null;
    }

    public int hashCode() {
        int hash = 3;
        hash = 53 * hash + Objects.hashCode(this.key);
        hash = 53 * hash + Objects.hashCode(this.value);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Record other = (Record)obj;
        if (!Objects.equals(this.key, other.key)) {
            return false;
        }
        return Objects.equals(this.value, other.value);
    }
}

