/*
 * Decompiled with CFR 0.152.
 */
package herddb.model;

import herddb.utils.SimpleByteArrayInputStream;
import herddb.utils.VisibleByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class NodeMetadata {
    public final String nodeId;
    public final Object metadataStorageVersion;
    public final String host;
    public final int port;
    public final boolean ssl;

    private NodeMetadata(String nodeId, Object metadataStorageVersion, String host, int port, boolean ssl) {
        this.nodeId = nodeId;
        this.metadataStorageVersion = metadataStorageVersion;
        this.host = host;
        this.port = port;
        this.ssl = ssl;
    }

    public String toString() {
        return "NodeMetadata{nodeId=" + this.nodeId + ", metadataStorageVersion=" + this.metadataStorageVersion + ", host=" + this.host + ", port=" + this.port + ", ssl=" + this.ssl + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static NodeMetadata deserialize(byte[] data, Object metadataStorageVersion) throws IOException {
        return NodeMetadata.deserialize(new DataInputStream((InputStream)new SimpleByteArrayInputStream(data)), metadataStorageVersion);
    }

    public static NodeMetadata deserialize(DataInputStream in, Object metadataStorageVersion) throws IOException {
        String nodeId = in.readUTF();
        in.readInt();
        String host = in.readUTF();
        int port = in.readInt();
        boolean ssl = in.readInt() == 1;
        return new NodeMetadata(nodeId, metadataStorageVersion, host, port, ssl);
    }

    public byte[] serialize() throws IOException {
        VisibleByteArrayOutputStream oo = new VisibleByteArrayOutputStream();
        try (DataOutputStream doo = new DataOutputStream((OutputStream)oo);){
            this.serialize(doo);
        }
        return oo.toByteArray();
    }

    public void serialize(DataOutputStream out) throws IOException {
        out.writeUTF(this.nodeId);
        out.writeInt(0);
        out.writeUTF(this.host);
        out.writeInt(this.port);
        out.writeInt(this.ssl ? 1 : 0);
    }

    public static class Builder {
        private String nodeId = "localhost";
        private String host = "localhost";
        private int port = 7000;
        private boolean ssl = false;

        private Builder() {
        }

        public Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder ssl(boolean ssl) {
            this.ssl = ssl;
            return this;
        }

        public NodeMetadata build() {
            if (this.nodeId == null || this.nodeId.isEmpty()) {
                throw new IllegalArgumentException("nodeId is not defined");
            }
            return new NodeMetadata(this.nodeId, null, this.host, this.port, this.ssl);
        }
    }
}

