/*
 * Decompiled with CFR 0.152.
 */
package herddb.model;

import herddb.model.StatementExecutionException;

public class ColumnTypes {
    public static final int STRING = 0;
    public static final int LONG = 1;
    public static final int INTEGER = 2;
    public static final int BYTEARRAY = 3;
    public static final int TIMESTAMP = 4;
    public static final int NULL = 5;
    public static final int DOUBLE = 6;
    public static final int BOOLEAN = 7;
    public static final int ANYTYPE = 10;
    public static final int NOTNULL_STRING = 11;
    public static final int NOTNULL_INTEGER = 12;
    public static final int NOTNULL_LONG = 13;

    public static String typeToString(int type) {
        switch (type) {
            case 0: {
                return "string";
            }
            case 1: {
                return "long";
            }
            case 2: {
                return "integer";
            }
            case 3: {
                return "bytearray";
            }
            case 4: {
                return "timestamp";
            }
            case 5: {
                return "null";
            }
            case 6: {
                return "double";
            }
            case 7: {
                return "boolean";
            }
            case 11: {
                return "string not null";
            }
            case 12: {
                return "integer not null";
            }
            case 13: {
                return "long not null";
            }
        }
        return "type?" + type;
    }

    public static boolean isNotNullDataType(int type) {
        switch (type) {
            case 11: 
            case 12: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    public static int getNonNullTypeForPrimitiveType(int type) throws StatementExecutionException {
        switch (type) {
            case 0: {
                return 11;
            }
            case 2: {
                return 12;
            }
            case 1: {
                return 13;
            }
        }
        throw new StatementExecutionException("Not null constraints not supported for column type " + type);
    }

    public static String sqlDataType(int type) {
        switch (type) {
            case 0: 
            case 11: {
                return "string";
            }
            case 1: 
            case 13: {
                return "long";
            }
            case 2: 
            case 12: {
                return "integer";
            }
            case 3: {
                return "bytearray";
            }
            case 4: {
                return "timestamp";
            }
            case 5: {
                return "null";
            }
            case 6: {
                return "double";
            }
            case 7: {
                return "boolean";
            }
        }
        return "type?" + type;
    }

    public static int sqlDataTypeToJdbcType(String type) {
        switch (type) {
            case "string": {
                return 12;
            }
            case "long": {
                return -5;
            }
            case "integer": {
                return 4;
            }
            case "bytearray": {
                return 2004;
            }
            case "timestamp": {
                return 93;
            }
            case "null": {
                return 0;
            }
            case "double": {
                return 8;
            }
            case "boolean": {
                return 16;
            }
        }
        return 1111;
    }

    public static boolean isNotNullToNullConversion(int oldType, int newType) {
        return ColumnTypes.isNotNullDataType(oldType) && !ColumnTypes.isNotNullDataType(newType) && ColumnTypes.getNonNullTypeForPrimitiveType(newType) == oldType;
    }

    public static boolean isNullToNotNullConversion(int oldType, int newType) {
        return ColumnTypes.isNotNullDataType(newType) && !ColumnTypes.isNotNullDataType(oldType) && ColumnTypes.getNonNullTypeForPrimitiveType(oldType) == newType;
    }
}

