/*
 * Decompiled with CFR 0.152.
 */
package herddb.metadata;

import herddb.metadata.MetadataChangeListener;
import herddb.metadata.MetadataStorageManagerException;
import herddb.metadata.NodeIdGenerator;
import herddb.model.DDLException;
import herddb.model.InvalidTableException;
import herddb.model.NodeMetadata;
import herddb.model.TableSpace;
import herddb.model.TableSpaceReplicaState;
import herddb.server.ServerConfiguration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class MetadataStorageManager
implements AutoCloseable {
    private MetadataChangeListener listener;

    public abstract void start() throws MetadataStorageManagerException;

    public abstract void ensureDefaultTableSpace(String var1) throws MetadataStorageManagerException;

    @Override
    public abstract void close() throws MetadataStorageManagerException;

    public abstract Collection<String> listTableSpaces() throws MetadataStorageManagerException;

    public abstract TableSpace describeTableSpace(String var1) throws MetadataStorageManagerException;

    public abstract void registerTableSpace(TableSpace var1) throws DDLException, MetadataStorageManagerException;

    public abstract void dropTableSpace(String var1, TableSpace var2) throws DDLException, MetadataStorageManagerException;

    public abstract boolean updateTableSpace(TableSpace var1, TableSpace var2) throws DDLException, MetadataStorageManagerException;

    protected void validateTableSpace(TableSpace tableSpace) throws DDLException {
        if (tableSpace.name == null || tableSpace.name.trim().isEmpty()) {
            throw new InvalidTableException("null tablespace name");
        }
    }

    public void registerNode(NodeMetadata nodeMetadata) throws MetadataStorageManagerException {
    }

    public abstract void updateTableSpaceReplicaState(TableSpaceReplicaState var1) throws MetadataStorageManagerException;

    public abstract List<TableSpaceReplicaState> getTableSpaceReplicaState(String var1) throws MetadataStorageManagerException;

    public List<NodeMetadata> listNodes() throws MetadataStorageManagerException {
        return Collections.emptyList();
    }

    public final void setMetadataChangeListener(MetadataChangeListener listener) {
        this.listener = listener;
    }

    public final MetadataChangeListener getListener() {
        return this.listener;
    }

    protected final void notifyMetadataChanged(String description) {
        if (this.listener != null) {
            this.listener.metadataChanged(description);
        }
    }

    public void clear() throws MetadataStorageManagerException {
    }

    public String generateNewNodeId(ServerConfiguration config) throws MetadataStorageManagerException {
        List<NodeMetadata> actualNodes = this.listNodes();
        NodeIdGenerator generator = new NodeIdGenerator();
        for (int i = 0; i < 10000; ++i) {
            String _nodeId = generator.nextId();
            if (actualNodes.stream().filter(node -> _nodeId.equals(node.nodeId)).findFirst().isPresent()) continue;
            return _nodeId;
        }
        throw new MetadataStorageManagerException("cannot find a new node id");
    }
}

