/*
 * Decompiled with CFR 0.152.
 */
package herddb.mem;

import herddb.core.MaterializedRecordSet;
import herddb.core.RecordSetFactory;
import herddb.model.Column;
import herddb.model.Projection;
import herddb.model.ScanLimits;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.model.TupleComparator;
import herddb.utils.DataAccessor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MemoryRecordSet
extends MaterializedRecordSet {
    private List<DataAccessor> buffer = new ArrayList<DataAccessor>();

    MemoryRecordSet(String[] fieldNames, Column[] columns, RecordSetFactory factory) {
        super(-1, fieldNames, columns, factory);
    }

    MemoryRecordSet(int size, String[] fieldNames, Column[] columns, RecordSetFactory factory) {
        super(size, fieldNames, columns, factory);
    }

    @Override
    public Iterator<DataAccessor> iterator() {
        if (!this.writeFinished) {
            throw new IllegalStateException("RecordSet is still in write mode");
        }
        return this.buffer.iterator();
    }

    @Override
    public void add(DataAccessor record) {
        if (this.writeFinished) {
            throw new IllegalStateException("RecordSet in read mode");
        }
        this.buffer.add(record);
        ++this.size;
    }

    @Override
    public void sort(TupleComparator comparator) {
        if (!this.writeFinished) {
            throw new IllegalStateException("RecordSet is still in write mode");
        }
        if (comparator != null) {
            this.buffer.sort(comparator);
        }
    }

    @Override
    public void applyProjection(Projection projection, StatementEvaluationContext context) throws StatementExecutionException {
        if (!this.writeFinished) {
            throw new IllegalStateException("RecordSet is still in write mode");
        }
        this.columns = projection.getColumns();
        this.fieldNames = projection.getFieldNames();
        ArrayList<DataAccessor> projected = new ArrayList<DataAccessor>(this.size);
        for (DataAccessor record : this.buffer) {
            projected.add(projection.map(record, context));
        }
        this.buffer = projected;
    }

    @Override
    public void applyLimits(ScanLimits limits, StatementEvaluationContext context) throws StatementExecutionException {
        int maxRows;
        if (!this.writeFinished) {
            throw new IllegalStateException("RecordSet is still in write mode");
        }
        if (limits == null) {
            return;
        }
        int offset = limits.computeOffset(context);
        if (offset > 0) {
            int maxlen = this.buffer.size();
            if (offset >= maxlen) {
                this.buffer.clear();
                return;
            }
            int samplesize = maxlen - offset;
            this.buffer = this.buffer.subList(offset, offset + samplesize);
        }
        if ((maxRows = limits.computeMaxRows(context)) > 0) {
            int maxlen = this.buffer.size();
            if (maxlen < maxRows) {
                return;
            }
            this.buffer = this.buffer.subList(0, maxRows);
        }
    }
}

