/*
 * Decompiled with CFR 0.152.
 */
package herddb.log;

import herddb.log.LogEntry;
import herddb.model.Index;
import herddb.model.Table;
import herddb.model.Transaction;
import herddb.utils.Bytes;

public class LogEntryFactory {
    public static LogEntry createTable(Table table, Transaction transaction) {
        byte[] payload = table.serialize();
        return new LogEntry(System.currentTimeMillis(), 1, transaction != null ? transaction.transactionId : 0L, table.name, null, Bytes.from_array((byte[])payload));
    }

    public static LogEntry alterTable(Table table, Transaction transaction) {
        byte[] payload = table.serialize();
        return new LogEntry(System.currentTimeMillis(), 8, transaction != null ? transaction.transactionId : 0L, table.name, null, Bytes.from_array((byte[])payload));
    }

    public static LogEntry dropTable(String table, Transaction transaction) {
        return new LogEntry(System.currentTimeMillis(), 9, transaction != null ? transaction.transactionId : 0L, table, null, null);
    }

    public static LogEntry dropIndex(String indexName, Transaction transaction) {
        return new LogEntry(System.currentTimeMillis(), 11, transaction != null ? transaction.transactionId : 0L, null, null, Bytes.from_string((String)indexName));
    }

    public static LogEntry beginTransaction(long transactionId) {
        return new LogEntry(System.currentTimeMillis(), 5, transactionId, null, null, null);
    }

    public static LogEntry commitTransaction(long transactionId) {
        return new LogEntry(System.currentTimeMillis(), 6, transactionId, null, null, null);
    }

    public static LogEntry rollbackTransaction(long transactionId) {
        return new LogEntry(System.currentTimeMillis(), 7, transactionId, null, null, null);
    }

    public static LogEntry insert(Table table, Bytes key, Bytes value, Transaction transaction) {
        return new LogEntry(System.currentTimeMillis(), 2, transaction != null ? transaction.transactionId : 0L, table.name, key, value);
    }

    public static LogEntry update(Table table, Bytes key, Bytes value, Transaction transaction) {
        return new LogEntry(System.currentTimeMillis(), 3, transaction != null ? transaction.transactionId : 0L, table.name, key, value);
    }

    public static LogEntry delete(Table table, Bytes key, Transaction transaction) {
        return new LogEntry(System.currentTimeMillis(), 4, transaction != null ? transaction.transactionId : 0L, table.name, key, null);
    }

    public static LogEntry createIndex(Index index, Transaction transaction) {
        byte[] payload = index.serialize();
        return new LogEntry(System.currentTimeMillis(), 10, transaction != null ? transaction.transactionId : 0L, index.table, null, Bytes.from_array((byte[])payload));
    }

    public static LogEntry truncate(Table table, Transaction transaction) {
        return new LogEntry(System.currentTimeMillis(), 12, transaction != null ? transaction.transactionId : 0L, table.name, null, null);
    }

    public static LogEntry noop() {
        return new LogEntry(System.currentTimeMillis(), 13, -1L, null, null, null);
    }
}

