/*
 * Decompiled with CFR 0.152.
 */
package herddb.jmx;

import herddb.core.HerdDBInternalException;
import herddb.jmx.DBManagerStatsMXBean;
import herddb.jmx.TableManagerStatsMXBean;
import herddb.jmx.TableSpaceManagerStatsMXBean;
import java.lang.management.ManagementFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public class JMXUtils {
    private static final Logger LOG = Logger.getLogger(JMXUtils.class.getName());
    private static MBeanServer platformMBeanServer;
    private static Throwable mBeanServerLookupError;

    private static String safeName(String s) {
        return s.replaceAll("[?,:=\\W]", ".");
    }

    public static MBeanServer getMBeanServer() {
        return platformMBeanServer;
    }

    public static void registerTableManagerStatsMXBean(String tableSpaceName, String tableName, TableManagerStatsMXBean bean) {
        if (platformMBeanServer == null) {
            throw new HerdDBInternalException("PlatformMBeanServer not available", mBeanServerLookupError);
        }
        String safeTableSpaceName = JMXUtils.safeName(tableSpaceName);
        String safeTableName = JMXUtils.safeName(tableName);
        try {
            ObjectName name = new ObjectName("herddb.server:type=Table,Name=" + safeTableSpaceName + "." + safeTableName);
            LOG.log(Level.FINE, "Publishing stats for table {0}.{1} at {2}", new Object[]{tableSpaceName, tableName, name});
            if (platformMBeanServer.isRegistered(name)) {
                try {
                    platformMBeanServer.unregisterMBean(name);
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    // empty catch block
                }
            }
            platformMBeanServer.registerMBean(bean, name);
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
            throw new HerdDBInternalException("Could not register MXBean " + e);
        }
    }

    public static void unregisterTableManagerStatsMXBean(String tableSpaceName, String tableName) {
        if (platformMBeanServer == null) {
            return;
        }
        String safeTableSpaceName = JMXUtils.safeName(tableSpaceName);
        String safeTableName = JMXUtils.safeName(tableName);
        try {
            ObjectName name = new ObjectName("herddb.server:type=Table,Name=" + safeTableSpaceName + "." + safeTableName);
            if (platformMBeanServer.isRegistered(name)) {
                try {
                    platformMBeanServer.unregisterMBean(name);
                }
                catch (InstanceNotFoundException instanceNotFoundException) {}
            }
        }
        catch (MBeanRegistrationException | MalformedObjectNameException e) {
            throw new HerdDBInternalException("Could not unregister MXBean " + e);
        }
    }

    public static void registerTableSpaceManagerStatsMXBean(String tableSpaceName, TableSpaceManagerStatsMXBean bean) {
        if (platformMBeanServer == null) {
            throw new HerdDBInternalException("PlatformMBeanServer not available", mBeanServerLookupError);
        }
        String safeTableSpaceName = JMXUtils.safeName(tableSpaceName);
        try {
            ObjectName name = new ObjectName("herddb.server:type=TableSpace,Name=" + safeTableSpaceName);
            LOG.log(Level.FINE, "Publishing stats for table {0} at {1}", new Object[]{tableSpaceName, name});
            if (platformMBeanServer.isRegistered(name)) {
                try {
                    platformMBeanServer.unregisterMBean(name);
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    // empty catch block
                }
            }
            platformMBeanServer.registerMBean(bean, name);
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
            throw new HerdDBInternalException("Could not register MXBean " + e);
        }
    }

    public static void unregisterTableSpaceManagerStatsMXBean(String tableSpaceName) {
        if (platformMBeanServer == null) {
            return;
        }
        String safeTableSpaceName = JMXUtils.safeName(tableSpaceName);
        try {
            ObjectName name = new ObjectName("herddb.server:type=TableSpace,Name=" + safeTableSpaceName);
            if (platformMBeanServer.isRegistered(name)) {
                try {
                    platformMBeanServer.unregisterMBean(name);
                }
                catch (InstanceNotFoundException instanceNotFoundException) {}
            }
        }
        catch (MBeanRegistrationException | MalformedObjectNameException e) {
            throw new HerdDBInternalException("Could not unregister MXBean " + e);
        }
    }

    public static void registerDBManagerStatsMXBean(DBManagerStatsMXBean bean) {
        if (platformMBeanServer == null) {
            throw new HerdDBInternalException("PlatformMBeanServer not available", mBeanServerLookupError);
        }
        try {
            ObjectName name = new ObjectName("herddb.server:type=Server");
            LOG.log(Level.FINE, "Publishing stats for server at {2}", new Object[]{name});
            if (platformMBeanServer.isRegistered(name)) {
                try {
                    platformMBeanServer.unregisterMBean(name);
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    // empty catch block
                }
            }
            platformMBeanServer.registerMBean(bean, name);
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
            throw new HerdDBInternalException("Could not register MXBean " + e);
        }
    }

    public static void unregisterDBManagerStatsMXBean() {
        if (platformMBeanServer == null) {
            return;
        }
        try {
            ObjectName name = new ObjectName("herddb.server:type=Server");
            if (platformMBeanServer.isRegistered(name)) {
                try {
                    platformMBeanServer.unregisterMBean(name);
                }
                catch (InstanceNotFoundException instanceNotFoundException) {}
            }
        }
        catch (MBeanRegistrationException | MalformedObjectNameException e) {
            throw new HerdDBInternalException("Could not unregister MXBean " + e);
        }
    }

    static {
        try {
            platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        catch (Exception err) {
            mBeanServerLookupError = err;
            err.printStackTrace();
            platformMBeanServer = null;
        }
    }
}

