/*
 * Decompiled with CFR 0.152.
 */
package herddb.file;

import herddb.core.MaterializedRecordSet;
import herddb.file.FileRecordSetFactory;
import herddb.model.Column;
import herddb.model.Projection;
import herddb.model.ScanLimits;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.model.Tuple;
import herddb.model.TupleComparator;
import herddb.utils.DataAccessor;
import herddb.utils.DiskArrayList;
import herddb.utils.ExtendedDataInputStream;
import herddb.utils.ExtendedDataOutputStream;
import herddb.utils.VisibleByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;

class FileRecordSet
extends MaterializedRecordSet {
    private DiskArrayList<DataAccessor> buffer;
    private final Path tmpDirectory;

    public FileRecordSet(int expectedSize, int swapThreshold, Column[] columns, String[] fieldNames, FileRecordSetFactory factory) {
        super(expectedSize, fieldNames, columns, factory);
        this.tmpDirectory = factory.tmpDirectory;
        this.buffer = new DiskArrayList(swapThreshold, factory.tmpDirectory, (DiskArrayList.Serializer)new TupleSerializer(columns, fieldNames));
        this.buffer.enableCompression();
    }

    @Override
    public Iterator<DataAccessor> iterator() {
        if (!this.writeFinished) {
            throw new IllegalStateException("RecordSet is still in write mode");
        }
        return this.buffer.iterator();
    }

    @Override
    public void add(DataAccessor record) {
        if (this.writeFinished) {
            throw new IllegalStateException("RecordSet is in read mode");
        }
        this.buffer.add((Object)record);
    }

    @Override
    public void writeFinished() {
        super.writeFinished();
        this.buffer.finish();
    }

    @Override
    public void sort(TupleComparator comparator) {
        if (!this.writeFinished) {
            throw new IllegalStateException("RecordSet is still in write mode");
        }
        if (comparator != null) {
            if (!this.buffer.isSwapped()) {
                this.buffer.sortBuffer((Comparator)comparator);
            } else {
                ArrayList<DataAccessor> copyInMemory = new ArrayList<DataAccessor>();
                for (DataAccessor tuple : this.buffer) {
                    copyInMemory.add(tuple);
                }
                copyInMemory.sort(comparator);
                this.buffer.close();
                DiskArrayList newBuffer = new DiskArrayList(this.buffer.isSwapped() ? -1 : Integer.MAX_VALUE, this.tmpDirectory, (DiskArrayList.Serializer)new TupleSerializer(this.columns, this.fieldNames));
                newBuffer.enableCompression();
                for (DataAccessor t : copyInMemory) {
                    newBuffer.add((Object)t);
                }
                newBuffer.finish();
                this.buffer = newBuffer;
            }
        }
    }

    @Override
    public void applyProjection(Projection projection, StatementEvaluationContext context) throws StatementExecutionException {
        this.columns = projection.getColumns();
        this.fieldNames = projection.getFieldNames();
        DiskArrayList projected = new DiskArrayList(this.buffer.isSwapped() ? -1 : Integer.MAX_VALUE, this.tmpDirectory, (DiskArrayList.Serializer)new TupleSerializer(this.columns, this.fieldNames));
        projected.enableCompression();
        for (DataAccessor record : this.buffer) {
            projected.add((Object)projection.map(record, context));
        }
        projected.finish();
        this.buffer.close();
        this.buffer = projected;
    }

    @Override
    public void applyLimits(ScanLimits limits, StatementEvaluationContext context) throws StatementExecutionException {
        int maxRows;
        if (!this.writeFinished) {
            throw new IllegalStateException("RecordSet is still in write mode");
        }
        if (limits == null) {
            return;
        }
        int offset = limits.computeOffset(context);
        if (offset > 0) {
            int maxlen = this.buffer.size();
            if (offset >= maxlen) {
                this.buffer.close();
                this.buffer = new DiskArrayList(Integer.MAX_VALUE, this.tmpDirectory, (DiskArrayList.Serializer)new TupleSerializer(this.columns, this.fieldNames));
                this.buffer.enableCompression();
                this.buffer.finish();
                return;
            }
            int samplesize = maxlen - offset;
            DiskArrayList copy = new DiskArrayList(this.buffer.isSwapped() ? -1 : Integer.MAX_VALUE, this.tmpDirectory, (DiskArrayList.Serializer)new TupleSerializer(this.columns, this.fieldNames));
            copy.enableCompression();
            int firstIndex = offset;
            int lastIndex = offset + samplesize;
            int i = 0;
            for (DataAccessor t : this.buffer) {
                if (i >= firstIndex && i < lastIndex) {
                    copy.add((Object)t);
                }
                if (++i < lastIndex) continue;
                break;
            }
            this.buffer.close();
            copy.finish();
            this.buffer = copy;
        }
        if ((maxRows = limits.computeMaxRows(context)) > 0) {
            int maxlen = this.buffer.size();
            if (maxlen < maxRows) {
                return;
            }
            this.buffer.truncate(maxRows);
        }
    }

    @Override
    public void close() {
        this.buffer.close();
    }

    private static class TupleSerializer
    implements DiskArrayList.Serializer<DataAccessor> {
        private final Column[] columns;
        private final String[] fieldNames;
        private final int nColumns;

        public TupleSerializer(Column[] columns, String[] fieldNames) {
            this.columns = columns;
            this.fieldNames = fieldNames;
            this.nColumns = columns.length;
        }

        public DataAccessor read(ExtendedDataInputStream oo) throws IOException {
            byte[] serialized = oo.readArray();
            return Tuple.deserialize(serialized, this.fieldNames, this.nColumns);
        }

        public void write(DataAccessor object, ExtendedDataOutputStream oo) throws IOException {
            VisibleByteArrayOutputStream buffer = Tuple.serialize(object, this.columns);
            oo.writeArray(buffer.getBuffer(), 0, buffer.size());
        }
    }
}

