/*
 * Decompiled with CFR 0.152.
 */
package herddb.core.system;

import herddb.codec.RecordSerializer;
import herddb.core.TableSpaceManager;
import herddb.core.system.AbstractSystemTableManager;
import herddb.metadata.MetadataStorageManagerException;
import herddb.model.Record;
import herddb.model.StatementExecutionException;
import herddb.model.Table;
import herddb.model.TableSpace;
import herddb.model.TableSpaceReplicaState;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SystablespacereplicastateTableManager
extends AbstractSystemTableManager {
    private static final Table TABLE = Table.builder().name("systablespacereplicastate").column("tablespace_name", 0).column("uuid", 11).column("nodeid", 11).column("mode", 0).column("timestamp", 4).column("maxleaderinactivitytime", 1).column("inactivitytime", 1).primaryKey("uuid", false).primaryKey("nodeid", false).build();

    public SystablespacereplicastateTableManager(TableSpaceManager parent) {
        super(parent, TABLE);
    }

    @Override
    protected Iterable<Record> buildVirtualRecordList() throws StatementExecutionException {
        try {
            Collection<String> names = this.tableSpaceManager.getMetadataStorageManager().listTableSpaces();
            long now = System.currentTimeMillis();
            ArrayList<Record> result = new ArrayList<Record>();
            for (String name : names) {
                TableSpace t = this.tableSpaceManager.getMetadataStorageManager().describeTableSpace(name);
                if (t == null) continue;
                List<TableSpaceReplicaState> tableSpaceReplicaStates = this.tableSpaceManager.getMetadataStorageManager().getTableSpaceReplicaState(t.uuid);
                for (TableSpaceReplicaState state : tableSpaceReplicaStates) {
                    result.add(RecordSerializer.makeRecord(this.table, "tablespace_name", t.name, "uuid", t.uuid, "nodeid", state.nodeId, "timestamp", new Timestamp(state.timestamp), "maxleaderinactivitytime", t.maxLeaderInactivityTime, "inactivitytime", now - state.timestamp, "mode", TableSpaceReplicaState.modeToSQLString(state.mode)));
                }
            }
            return result;
        }
        catch (MetadataStorageManagerException error) {
            throw new StatementExecutionException(error);
        }
    }
}

