/*
 * Decompiled with CFR 0.152.
 */
package herddb.core.system;

import herddb.codec.RecordSerializer;
import herddb.core.RunningStatementInfo;
import herddb.core.TableSpaceManager;
import herddb.core.system.AbstractSystemTableManager;
import herddb.model.Record;
import herddb.model.Table;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;

public class SysstatementsTableManager
extends AbstractSystemTableManager {
    private static final Table TABLE = Table.builder().name("sysstatements").column("id", 1).column("tablespace", 0).column("query", 0).column("startts", 4).column("runningtime", 1).column("batches", 2).column("info", 0).primaryKey("id", false).build();

    public SysstatementsTableManager(TableSpaceManager parent) {
        super(parent, TABLE);
    }

    @Override
    protected Iterable<Record> buildVirtualRecordList() {
        ConcurrentHashMap<Long, RunningStatementInfo> runningStatements = this.tableSpaceManager.getDbmanager().getRunningStatements().getRunningStatements();
        ArrayList<Record> result = new ArrayList<Record>();
        long now = System.currentTimeMillis();
        for (RunningStatementInfo info : runningStatements.values()) {
            result.add(RecordSerializer.makeRecord(this.table, "id", info.getId(), "tablespace", info.getTablespace(), "query", info.getQuery(), "startts", new Timestamp(info.getStartTimestamp()), "runningtime", now - info.getStartTimestamp(), "batches", info.getNumBatches(), "info", info.getInfo()));
        }
        return result;
    }
}

