/*
 * Decompiled with CFR 0.152.
 */
package herddb.core.join;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import herddb.model.Column;
import herddb.model.DataScanner;
import herddb.model.DataScannerException;
import herddb.model.StatementExecutionException;
import herddb.model.Tuple;
import herddb.utils.DataAccessor;
import java.util.List;

@SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
public class DataScannerJoinExecutor {
    private final DataScanner[] scanners;
    private final int numScanners;
    private final TupleAcceptor consumer;
    private final String[] fieldNames;
    private final Object[] tmpTuple;

    public DataScannerJoinExecutor(String[] fieldNames, Column[] schema, List<DataScanner> scanners, TupleAcceptor consumer) {
        this.scanners = new DataScanner[scanners.size()];
        scanners.toArray(this.scanners);
        this.consumer = consumer;
        this.numScanners = this.scanners.length;
        this.fieldNames = fieldNames;
        this.tmpTuple = new Object[fieldNames.length];
    }

    public void executeJoin() throws DataScannerException, StatementExecutionException {
        if (this.numScanners <= 0) {
            throw new DataScannerException("no tables in JOIN ?");
        }
        this.nestedLoop(0, 0);
        for (DataScanner scan : this.scanners) {
            scan.close();
        }
    }

    private void nestedLoop(int index, int pos) throws DataScannerException, StatementExecutionException {
        if (index == this.numScanners) {
            Object[] clone = new Object[this.fieldNames.length];
            System.arraycopy(this.tmpTuple, 0, clone, 0, this.fieldNames.length);
            this.consumer.accept(new Tuple(this.fieldNames, clone));
            return;
        }
        DataScanner scanner = this.scanners[index];
        scanner.rewind();
        while (scanner.hasNext()) {
            int startPos = pos;
            DataAccessor rightTuple = scanner.next();
            for (Object o : rightTuple.getValues()) {
                this.tmpTuple[startPos++] = o;
            }
            this.nestedLoop(index + 1, startPos);
        }
    }

    @FunctionalInterface
    public static interface TupleAcceptor {
        public void accept(Tuple var1) throws StatementExecutionException;
    }
}

