/*
 * Decompiled with CFR 0.152.
 */
package herddb.core;

import herddb.codec.RecordSerializer;
import herddb.core.AbstractIndexManager;
import herddb.core.AbstractTableManager;
import herddb.core.DataPage;
import herddb.core.HerdDBInternalException;
import herddb.core.InStreamTupleSorter;
import herddb.core.LocalScanPageCache;
import herddb.core.MaterializedRecordSet;
import herddb.core.MemoryManager;
import herddb.core.Page;
import herddb.core.PageReplacementPolicy;
import herddb.core.PageSet;
import herddb.core.PostCheckpointAction;
import herddb.core.SimpleDataScanner;
import herddb.core.StreamDataScanner;
import herddb.core.TableSpaceManager;
import herddb.core.stats.TableManagerStats;
import herddb.index.IndexOperation;
import herddb.index.KeyToPageIndex;
import herddb.index.PrimaryIndexSeek;
import herddb.log.CommitLog;
import herddb.log.CommitLogResult;
import herddb.log.LogEntry;
import herddb.log.LogEntryFactory;
import herddb.log.LogNotAvailableException;
import herddb.log.LogSequenceNumber;
import herddb.model.Column;
import herddb.model.ColumnTypes;
import herddb.model.ColumnsList;
import herddb.model.DDLException;
import herddb.model.DMLStatementExecutionResult;
import herddb.model.DataScanner;
import herddb.model.DataScannerException;
import herddb.model.DuplicatePrimaryKeyException;
import herddb.model.GetResult;
import herddb.model.Index;
import herddb.model.Predicate;
import herddb.model.Projection;
import herddb.model.Record;
import herddb.model.RecordFunction;
import herddb.model.RecordTooBigException;
import herddb.model.ScanLimits;
import herddb.model.ScanLimitsImpl;
import herddb.model.Statement;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.model.StatementExecutionResult;
import herddb.model.Table;
import herddb.model.TableContext;
import herddb.model.Transaction;
import herddb.model.TupleComparator;
import herddb.model.commands.DeleteStatement;
import herddb.model.commands.GetStatement;
import herddb.model.commands.InsertStatement;
import herddb.model.commands.ScanStatement;
import herddb.model.commands.TruncateTableStatement;
import herddb.model.commands.UpdateStatement;
import herddb.storage.DataPageDoesNotExistException;
import herddb.storage.DataStorageManager;
import herddb.storage.DataStorageManagerException;
import herddb.storage.FullTableScanConsumer;
import herddb.storage.TableStatus;
import herddb.utils.BatchOrderedExecutor;
import herddb.utils.BooleanHolder;
import herddb.utils.Bytes;
import herddb.utils.DataAccessor;
import herddb.utils.EnsureLongIncrementAccumulator;
import herddb.utils.Holder;
import herddb.utils.ILocalLockManager;
import herddb.utils.LegacyLocalLockManager;
import herddb.utils.LocalLockManager;
import herddb.utils.LockHandle;
import herddb.utils.SystemProperties;
import java.sql.Timestamp;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongBinaryOperator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.StatsLogger;

public final class TableManager
implements AbstractTableManager,
Page.Owner {
    private static final Logger LOGGER = Logger.getLogger(TableManager.class.getName());
    private static final long CHECKPOINT_LOCK_WRITE_TIMEOUT = SystemProperties.getIntSystemProperty((String)"herddb.tablemanager.checkpoint.lock.write.timeout", (int)60);
    private static final long CHECKPOINT_LOCK_READ_TIMEOUT = SystemProperties.getIntSystemProperty((String)"herddb.tablemanager.checkpoint.lock.read.timeout", (int)10);
    private static final int SORTED_PAGE_ACCESS_WINDOW_SIZE = SystemProperties.getIntSystemProperty((String)"herddb.tablemanager.sortedPageAccessWindowSize", (int)2000);
    private static final boolean ENABLE_LOCAL_SCAN_PAGE_CACHE = SystemProperties.getBooleanSystemProperty((String)"herddb.tablemanager.enableLocalScanPageCache", (boolean)true);
    private static final int HUGE_TABLE_SIZE_FORCE_MATERIALIZED_RESULTSET = SystemProperties.getIntSystemProperty((String)"herddb.tablemanager.hugeTableSizeForceMaterializedResultSet", (int)100000);
    private static final boolean ENABLE_STREAMING_DATA_SCANNER = SystemProperties.getBooleanSystemProperty((String)"herddb.tablemanager.enableStreamingDataScanner", (boolean)true);
    private static final boolean USE_LEGACY_LOCK_MANAGER = SystemProperties.getBooleanSystemProperty((String)"herddb.tablemanager.legacylocks", (boolean)false);
    static boolean ignoreMissingTransactionsOnRecovery = SystemProperties.getBooleanSystemProperty((String)"herddb.tablemanager.ignoreMissingTransactionsOnRecovery", (boolean)false);
    private final ConcurrentMap<Long, DataPage> newPages;
    private final ConcurrentMap<Long, DataPage> pages;
    private final KeyToPageIndex keyToPage;
    private final PageSet pageSet = new PageSet();
    private long nextPageId = 1L;
    private final Lock nextPageLock = new ReentrantLock();
    private final AtomicLong currentDirtyRecordsPage = new AtomicLong();
    private final LongAdder loadedPagesCount = new LongAdder();
    private final LongAdder unloadedPagesCount = new LongAdder();
    private final ILocalLockManager locksManager = USE_LEGACY_LOCK_MANAGER ? new LegacyLocalLockManager() : new LocalLockManager();
    private volatile boolean started = false;
    private volatile boolean checkPointRunning = false;
    private final StampedLock checkpointLock = new StampedLock();
    private final AtomicLong nextPrimaryKeyValue = new AtomicLong(1L);
    private final TableContext tableContext;
    private final String tableSpaceUUID;
    private Table table;
    private final CommitLog log;
    private final DataStorageManager dataStorageManager;
    private final TableSpaceManager tableSpaceManager;
    private final PageReplacementPolicy pageReplacementPolicy;
    private final long maxLogicalPageSize;
    private final Semaphore maxCurrentPagesLoads = new Semaphore(4, true);
    private long createdInTransaction;
    private final double dirtyThreshold;
    private final double fillThreshold;
    private final long checkpointTargetTime;
    private final long cleanupTargetTime;
    private final long compactionTargetTime;
    private final TableManagerStats stats = new TableManagerStatsImpl();
    private final Counter checkpointProcessedDirtyRecords;
    private final boolean keyToPageSortedAscending;
    private LogSequenceNumber bootSequenceNumber;
    private LogSequenceNumber dumpLogSequenceNumber;
    private static final Comparator<Map.Entry<Bytes, Long>> SORTED_PAGE_ACCESS_COMPARATOR = (a, b) -> ((Long)a.getValue()).compareTo((Long)b.getValue());

    void prepareForRestore(LogSequenceNumber dumpLogSequenceNumber) {
        LOGGER.log(Level.INFO, "Table " + this.table.name + ", receiving dump,done at external logPosition " + dumpLogSequenceNumber);
        this.dumpLogSequenceNumber = dumpLogSequenceNumber;
    }

    void restoreFinished() {
        this.dumpLogSequenceNumber = null;
        LOGGER.log(Level.INFO, "Table " + this.table.name + ", received dump");
    }

    TableManager(Table table, CommitLog log, MemoryManager memoryManager, DataStorageManager dataStorageManager, TableSpaceManager tableSpaceManager, String tableSpaceUUID, long createdInTransaction) throws DataStorageManagerException {
        this.log = log;
        this.table = table;
        this.tableSpaceManager = tableSpaceManager;
        this.dataStorageManager = dataStorageManager;
        this.createdInTransaction = createdInTransaction;
        this.tableSpaceUUID = tableSpaceUUID;
        this.tableContext = this.buildTableContext();
        this.maxLogicalPageSize = memoryManager.getMaxLogicalPageSize();
        this.keyToPage = dataStorageManager.createKeyToPageMap(tableSpaceUUID, table.uuid, memoryManager);
        this.pageReplacementPolicy = memoryManager.getDataPageReplacementPolicy();
        this.pages = new ConcurrentHashMap<Long, DataPage>();
        this.newPages = new ConcurrentHashMap<Long, DataPage>();
        this.dirtyThreshold = tableSpaceManager.getDbmanager().getServerConfiguration().getDouble("server.checkpoint.page.dirty.max.threshold", 0.25);
        this.fillThreshold = tableSpaceManager.getDbmanager().getServerConfiguration().getDouble("server.checkpoint.page.fill.min.threshold", 0.75);
        long checkpointTargetTime = tableSpaceManager.getDbmanager().getServerConfiguration().getLong("server.checkpoint.duration", -1L);
        this.checkpointTargetTime = checkpointTargetTime < 0L ? Long.MAX_VALUE : checkpointTargetTime;
        long cleanupTargetTime = tableSpaceManager.getDbmanager().getServerConfiguration().getLong("server.checkpoint.cleanup", 1000L);
        this.cleanupTargetTime = cleanupTargetTime < 0L ? Long.MAX_VALUE : cleanupTargetTime;
        long compactionTargetTime = tableSpaceManager.getDbmanager().getServerConfiguration().getLong("server.checkpoint.compaction", 1000L);
        this.compactionTargetTime = compactionTargetTime < 0L ? Long.MAX_VALUE : compactionTargetTime;
        StatsLogger tableMetrics = tableSpaceManager.tablespaceStasLogger.scope("table_" + table.name);
        this.checkpointProcessedDirtyRecords = tableMetrics.getCounter("checkpoint_processed_dirty_records");
        int[] pkTypes = new int[table.primaryKey.length];
        for (int i = 0; i < table.primaryKey.length; ++i) {
            Column col = table.getColumn(table.primaryKey[i]);
            pkTypes[i] = col.type;
        }
        this.keyToPageSortedAscending = this.keyToPage.isSortedAscending(pkTypes);
    }

    private TableContext buildTableContext() {
        TableContext tableContext = !this.table.auto_increment ? new TableContext(){

            @Override
            public byte[] computeNewPrimaryKeyValue() {
                throw new UnsupportedOperationException("no auto_increment function on this table");
            }

            @Override
            public Table getTable() {
                return TableManager.this.table;
            }
        } : (this.table.getColumn((String)this.table.primaryKey[0]).type == 2 || this.table.getColumn((String)this.table.primaryKey[0]).type == 12 ? new TableContext(){

            @Override
            public byte[] computeNewPrimaryKeyValue() {
                return Bytes.intToByteArray((int)((int)TableManager.this.nextPrimaryKeyValue.getAndIncrement()));
            }

            @Override
            public Table getTable() {
                return TableManager.this.table;
            }
        } : (this.table.getColumn((String)this.table.primaryKey[0]).type == 1 || this.table.getColumn((String)this.table.primaryKey[0]).type == 13 ? new TableContext(){

            @Override
            public byte[] computeNewPrimaryKeyValue() {
                return Bytes.longToByteArray((long)TableManager.this.nextPrimaryKeyValue.getAndIncrement());
            }

            @Override
            public Table getTable() {
                return TableManager.this.table;
            }
        } : new TableContext(){

            @Override
            public byte[] computeNewPrimaryKeyValue() {
                throw new UnsupportedOperationException("no auto_increment function on this table");
            }

            @Override
            public Table getTable() {
                return TableManager.this.table;
            }
        }));
        return tableContext;
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    public LogSequenceNumber getBootSequenceNumber() {
        return this.bootSequenceNumber;
    }

    @Override
    public void start() throws DataStorageManagerException {
        final HashMap<Long, PageSet.DataPageMetaData> activePagesAtBoot = new HashMap<Long, PageSet.DataPageMetaData>();
        this.dataStorageManager.initTable(this.tableSpaceUUID, this.table.uuid);
        this.keyToPage.init();
        this.bootSequenceNumber = LogSequenceNumber.START_OF_TIME;
        boolean requireLoadAtStartup = this.keyToPage.requireLoadAtStartup();
        if (requireLoadAtStartup) {
            LOGGER.log(Level.INFO, "loading in memory all the keys for table {0}", new Object[]{this.table.name});
            this.dataStorageManager.fullTableScan(this.tableSpaceUUID, this.table.uuid, new FullTableScanConsumer(){

                @Override
                public void acceptTableStatus(TableStatus tableStatus) {
                    LOGGER.log(Level.INFO, "recovery table at {0}", tableStatus.sequenceNumber);
                    TableManager.this.nextPrimaryKeyValue.set(Bytes.toLong((byte[])tableStatus.nextPrimaryKeyValue, (int)0));
                    TableManager.this.nextPageId = tableStatus.nextPageId;
                    TableManager.this.bootSequenceNumber = tableStatus.sequenceNumber;
                    activePagesAtBoot.putAll(tableStatus.activePages);
                }

                @Override
                public void acceptPage(long pageId, List<Record> records) {
                    for (Record record : records) {
                        TableManager.this.keyToPage.put(record.key.nonShared(), pageId, null);
                    }
                }

                @Override
                public void endTable() {
                }
            });
        } else {
            LOGGER.log(Level.INFO, "loading table {0}, uuid {1}", new Object[]{this.table.name, this.table.uuid});
            TableStatus tableStatus = this.dataStorageManager.getLatestTableStatus(this.tableSpaceUUID, this.table.uuid);
            if (!tableStatus.sequenceNumber.isStartOfTime()) {
                LOGGER.log(Level.INFO, "recovery table at {0}", tableStatus.sequenceNumber);
            }
            this.nextPrimaryKeyValue.set(Bytes.toLong((byte[])tableStatus.nextPrimaryKeyValue, (int)0));
            this.nextPageId = tableStatus.nextPageId;
            this.bootSequenceNumber = tableStatus.sequenceNumber;
            activePagesAtBoot.putAll(tableStatus.activePages);
        }
        this.keyToPage.start(this.bootSequenceNumber);
        this.dataStorageManager.cleanupAfterBoot(this.tableSpaceUUID, this.table.uuid, activePagesAtBoot.keySet());
        this.pageSet.setActivePagesAtBoot(activePagesAtBoot);
        this.initNewPages();
        LOGGER.log(Level.INFO, "loaded {0} keys for table {1}, newPageId {2}, nextPrimaryKeyValue {3}, activePages {4}", new Object[]{this.keyToPage.size(), this.table.name, this.nextPageId, this.nextPrimaryKeyValue.get(), this.pageSet.getActivePages() + ""});
        this.started = true;
    }

    @Override
    public CompletableFuture<StatementExecutionResult> executeStatementAsync(Statement statement, Transaction transaction, StatementEvaluationContext context) {
        CompletionStage<StatementExecutionResult> res;
        long lockStamp = this.checkpointLock.readLock();
        if (statement instanceof UpdateStatement) {
            UpdateStatement update = (UpdateStatement)statement;
            res = this.executeUpdateAsync(update, transaction, context);
        } else if (statement instanceof InsertStatement) {
            InsertStatement insert = (InsertStatement)statement;
            res = this.executeInsertAsync(insert, transaction, context);
        } else if (statement instanceof GetStatement) {
            GetStatement get = (GetStatement)statement;
            res = this.executeGetAsync(get, transaction, context);
        } else if (statement instanceof DeleteStatement) {
            DeleteStatement delete = (DeleteStatement)statement;
            res = this.executeDeleteAsync(delete, transaction, context);
        } else if (statement instanceof TruncateTableStatement) {
            try {
                TruncateTableStatement truncate = (TruncateTableStatement)statement;
                res = CompletableFuture.completedFuture(this.executeTruncate(truncate, transaction, context));
            }
            catch (StatementExecutionException err) {
                LOGGER.log(Level.SEVERE, "Truncate table failed", (Throwable)((Object)err));
                res = FutureUtils.exception((Throwable)((Object)err));
            }
        } else {
            res = FutureUtils.exception((Throwable)((Object)new StatementExecutionException("not implemented " + statement.getClass())));
        }
        res = ((CompletableFuture)res).whenComplete((r, error) -> this.checkpointLock.unlockRead(lockStamp));
        if (statement instanceof TruncateTableStatement) {
            res = ((CompletableFuture)res).whenComplete((r, error) -> {
                if (error == null) {
                    try {
                        this.flush();
                    }
                    catch (DataStorageManagerException err) {
                        throw new HerdDBInternalException((Throwable)((Object)new StatementExecutionException("internal data error: " + (Object)((Object)err), (Throwable)((Object)err))));
                    }
                }
            });
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long allocateLivePage(Long lastKnownPageId) {
        Long newId;
        this.nextPageLock.lock();
        Page.Metadata unload = null;
        try {
            if (lastKnownPageId.longValue() == this.currentDirtyRecordsPage.get()) {
                if (this.pages.containsKey(newId = Long.valueOf(this.nextPageId++))) {
                    throw new IllegalStateException("invalid newpage id " + newId + ", " + this.newPages.keySet() + "/" + this.pages.keySet());
                }
                DataPage lastKnownPage = (DataPage)((Object)this.pages.get(lastKnownPageId));
                if (lastKnownPage == null) {
                    throw new IllegalStateException("invalid last known new page id " + lastKnownPageId + ", " + this.newPages.keySet() + "/" + this.pages.keySet());
                }
                this.createNewPage(newId);
                unload = this.pageReplacementPolicy.add((Page)lastKnownPage);
            } else {
                newId = this.currentDirtyRecordsPage.get();
            }
        }
        finally {
            this.nextPageLock.unlock();
        }
        if (unload != null) {
            unload.owner.unload(unload.pageId);
        }
        return newId;
    }

    private void initNewPages() {
        if (!this.newPages.isEmpty()) {
            throw new IllegalStateException("invalid new page initialization, other new pages already exist: " + this.newPages.keySet());
        }
        this.createNewPage(this.nextPageId++);
    }

    private void createNewPage(long newId) {
        DataPage newPage = new DataPage(this, newId, this.maxLogicalPageSize, 0L, new ConcurrentHashMap<Bytes, Record>(), false);
        this.newPages.put(newId, newPage);
        this.pages.put(newId, newPage);
        this.currentDirtyRecordsPage.set(newId);
    }

    private DataPage createMutablePage(long newId, int expectedSize, long initiaPageSize) {
        LOGGER.log(Level.FINER, "creating mutable page table {0}, pageId={1} with {2} records, {3} logical page size", new Object[]{this.table.name, newId, expectedSize, initiaPageSize});
        DataPage newPage = new DataPage(this, newId, this.maxLogicalPageSize, initiaPageSize, new HashMap<Bytes, Record>(expectedSize), false);
        this.pages.put(newId, newPage);
        return newPage;
    }

    public Collection<DataPage> getLoadedPages() {
        return this.pages.values();
    }

    public void unload(long pageId) {
        this.pages.computeIfPresent(pageId, (k, remove) -> {
            this.unloadedPagesCount.increment();
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "table {0} removed page {1}, {2}", new Object[]{this.table.name, pageId, remove.getUsedMemory() / 0x100000L + " MB"});
            }
            boolean dataFlushed = false;
            if (!remove.immutable) {
                dataFlushed = this.flushNewPageForUnload((DataPage)((Object)remove));
            }
            if (LOGGER.isLoggable(Level.FINER)) {
                if (dataFlushed) {
                    LOGGER.log(Level.FINER, "table {0} remove and save 'new' page {1}, {2}", new Object[]{this.table.name, remove.pageId, remove.getUsedMemory() / 0x100000L + " MB"});
                } else {
                    LOGGER.log(Level.FINER, "table {0} unload page {1}, {2}", new Object[]{this.table.name, pageId, remove.getUsedMemory() / 0x100000L + " MB"});
                }
            }
            return null;
        });
    }

    private void flushNewPageForCheckpoint(DataPage page, DataPage spareDataPage) {
        FlushNewPageResult flush = this.flushNewPage(page, spareDataPage);
        switch (flush) {
            case FLUSHED: {
                this.pages.computeIfPresent(page.pageId, (i, p) -> p.toImmutable());
                return;
            }
            case ALREADY_FLUSHED: {
                LOGGER.log(Level.INFO, "New page {0} already flushed in a concurrent thread", page.pageId);
                return;
            }
            case EMPTY_FLUSH: {
                this.pageReplacementPolicy.remove((Page)page);
                this.pages.remove(page.pageId);
                return;
            }
        }
        throw new IllegalArgumentException("Unknown new page flush result: " + (Object)((Object)flush));
    }

    private boolean flushNewPageForUnload(DataPage page) {
        return FlushNewPageResult.FLUSHED == this.flushNewPage(page, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FlushNewPageResult flushNewPage(DataPage page, DataPage spareDataPage) {
        if (page.immutable) {
            LOGGER.log(Level.SEVERE, "Attempt to flush an immutable page {0} as it was mutable", page.pageId);
            throw new IllegalStateException("page " + page.pageId + " is not a new page!");
        }
        page.pageLock.readLock().lock();
        try {
            if (!page.writable) {
                LOGGER.log(Level.INFO, "Mutable page {0} already flushed in a concurrent thread", page.pageId);
                FlushNewPageResult flushNewPageResult = FlushNewPageResult.ALREADY_FLUSHED;
                return flushNewPageResult;
            }
        }
        finally {
            page.pageLock.readLock().unlock();
        }
        Lock lock = page.pageLock.writeLock();
        lock.lock();
        try {
            DataPage remove;
            if (!page.writable) {
                LOGGER.log(Level.INFO, "Mutable page {0} already flushed in a concurrent thread", page.pageId);
                FlushNewPageResult flushNewPageResult = FlushNewPageResult.ALREADY_FLUSHED;
                return flushNewPageResult;
            }
            boolean drop = page.isEmpty();
            if (!drop) {
                this.pageSet.pageCreated(page.pageId, page);
            }
            if ((remove = (DataPage)((Object)this.newPages.remove(page.pageId))) == null) {
                LOGGER.log(Level.SEVERE, "Detected concurrent flush of page {0}, writable: {1}", new Object[]{page.pageId, page.writable});
                throw new IllegalStateException("page " + page.pageId + " is not a new page!");
            }
            page.writable = false;
            if (drop) {
                LOGGER.log(Level.INFO, "Deleted empty mutable page {0} instead of flushing it", page.pageId);
                FlushNewPageResult flushNewPageResult = FlushNewPageResult.EMPTY_FLUSH;
                return flushNewPageResult;
            }
        }
        finally {
            lock.unlock();
        }
        if (spareDataPage != null) {
            long usedMemory = page.getUsedMemory();
            long buildingPageMemory = spareDataPage.getUsedMemory();
            boolean add = true;
            Iterator<Record> records = spareDataPage.getRecordsForFlush().iterator();
            while (add && records.hasNext()) {
                Record record = records.next().nonShared();
                add = page.put(record);
                if (!add) continue;
                boolean moved = this.keyToPage.put(record.key, page.pageId, spareDataPage.pageId);
                if (!moved) {
                    LOGGER.log(Level.SEVERE, "Detected a dirty page as spare data page while flushing new page. Flushing new page {0}. Spare data page {1}", new Object[]{page, spareDataPage});
                    throw new IllegalStateException("Expected a clean page for stealing records, got a dirty record " + record.key + ". Flushing new page " + page.pageId + ". Spare data page " + spareDataPage.pageId);
                }
                records.remove();
            }
            long spareUsedMemory = page.getUsedMemory() - usedMemory;
            spareDataPage.setUsedMemory(buildingPageMemory - spareUsedMemory);
        }
        LOGGER.log(Level.FINER, "flushNewPage table {0}, pageId={1} with {2} records, {3} logical page size", new Object[]{this.table.name, page.pageId, page.size(), page.getUsedMemory()});
        this.dataStorageManager.writePage(this.tableSpaceUUID, this.table.uuid, page.pageId, page.getRecordsForFlush());
        return FlushNewPageResult.FLUSHED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushMutablePage(DataPage page, boolean keepPageInMemory) {
        LOGGER.log(Level.FINER, "flushing mutable page table {0}, pageId={1} with {2} records, {3} logical page size", new Object[]{this.table.name, page.pageId, page.size(), page.getUsedMemory()});
        if (page.immutable) {
            LOGGER.log(Level.SEVERE, "Attempt to flush an immutable page " + page.pageId + " as it was mutable");
            throw new IllegalStateException("page " + page.pageId + " is not an immutable page!");
        }
        page.pageLock.readLock().lock();
        try {
            if (!page.writable) {
                LOGGER.log(Level.SEVERE, "Attempt to flush a not writable mutable page " + page.pageId + " as it was writable");
                throw new IllegalStateException("page " + page.pageId + " is not a writable page!");
            }
        }
        finally {
            page.pageLock.readLock().unlock();
        }
        Lock lock = page.pageLock.writeLock();
        lock.lock();
        try {
            try {
                page.writable = false;
            }
            finally {
                if (keepPageInMemory) {
                    lock.unlock();
                }
            }
            this.dataStorageManager.writePage(this.tableSpaceUUID, this.table.uuid, page.pageId, page.getRecordsForFlush());
            this.pageSet.pageCreated(page.pageId, page);
            if (keepPageInMemory) {
                this.pages.put(page.pageId, page.toImmutable());
                Page.Metadata unload = this.pageReplacementPolicy.add((Page)page);
                if (unload != null) {
                    unload.owner.unload(unload.pageId);
                }
            }
        }
        finally {
            if (!keepPageInMemory) {
                this.pages.remove(page.pageId);
                lock.unlock();
            }
        }
    }

    private LockHandle lockForWrite(Bytes key, Transaction transaction) {
        if (transaction != null) {
            LockHandle lock = transaction.lookupLock(this.table.name, key);
            if (lock != null) {
                if (lock.write) {
                    return lock;
                }
                this.locksManager.releaseLock(lock);
                transaction.unregisterUpgradedLocksOnTable(this.table.name, lock);
                lock = this.locksManager.acquireWriteLockForKey(key);
                transaction.registerLockOnTable(this.table.name, lock);
                return lock;
            }
            lock = this.locksManager.acquireWriteLockForKey(key);
            transaction.registerLockOnTable(this.table.name, lock);
            return lock;
        }
        return this.locksManager.acquireWriteLockForKey(key);
    }

    private LockHandle lockForRead(Bytes key, Transaction transaction) {
        if (transaction != null) {
            LockHandle lock = transaction.lookupLock(this.table.name, key);
            if (lock != null) {
                return lock;
            }
            lock = this.locksManager.acquireReadLockForKey(key);
            transaction.registerLockOnTable(this.table.name, lock);
            return lock;
        }
        return this.locksManager.acquireReadLockForKey(key);
    }

    private CompletableFuture<StatementExecutionResult> executeInsertAsync(InsertStatement insert, Transaction transaction, StatementEvaluationContext context) {
        long size;
        byte[] value;
        Bytes key;
        try {
            key = Bytes.from_array((byte[])insert.getKeyFunction().computeNewValue(null, context, this.tableContext));
            value = insert.getValuesFunction().computeNewValue(new Record(key, null), context, this.tableContext);
        }
        catch (StatementExecutionException validationError) {
            return FutureUtils.exception((Throwable)((Object)validationError));
        }
        Map<String, AbstractIndexManager> indexes = this.tableSpaceManager.getIndexesOnTable(this.table.name);
        if (indexes != null) {
            try {
                DataAccessor values = new Record(key, Bytes.from_array((byte[])value)).getDataAccessor(this.table);
                for (AbstractIndexManager index : indexes.values()) {
                    RecordSerializer.validatePrimaryKey(values, index.getIndex(), index.getColumnNames());
                }
            }
            catch (IllegalArgumentException err) {
                return FutureUtils.exception((Throwable)((Object)new StatementExecutionException(err.getMessage(), err)));
            }
        }
        if ((size = DataPage.estimateEntrySize(key, value)) > this.maxLogicalPageSize) {
            return FutureUtils.exception((Throwable)((Object)new RecordTooBigException("New record " + key + " is to big to be inserted: size " + size + ", max size " + this.maxLogicalPageSize)));
        }
        LockHandle lock = this.lockForWrite(key, transaction);
        CompletionStage res = null;
        boolean fallbackToUpsert = false;
        if (transaction != null) {
            if (!transaction.recordDeleted(this.table.name, key)) {
                if (transaction.recordInserted(this.table.name, key) != null) {
                    res = FutureUtils.exception((Throwable)((Object)new DuplicatePrimaryKeyException(key, "key " + key + ", decoded as " + RecordSerializer.deserializePrimaryKey(key, this.table) + ", already exists in table " + this.table.name + " inside transaction " + transaction.transactionId)));
                } else if (this.keyToPage.containsKey(key)) {
                    if (insert.isUpsert()) {
                        fallbackToUpsert = true;
                    } else {
                        res = FutureUtils.exception((Throwable)((Object)new DuplicatePrimaryKeyException(key, "key " + key + ", decoded as " + RecordSerializer.deserializePrimaryKey(key, this.table) + ", already exists in table " + this.table.name + " during transaction " + transaction.transactionId)));
                    }
                }
            }
        } else if (this.keyToPage.containsKey(key)) {
            if (insert.isUpsert()) {
                fallbackToUpsert = true;
            } else {
                res = FutureUtils.exception((Throwable)((Object)new DuplicatePrimaryKeyException(key, "key " + key + ", decoded as " + RecordSerializer.deserializePrimaryKey(key, this.table) + ", already exists in table " + this.table.name)));
            }
        }
        if (res == null) {
            LogEntry entry = fallbackToUpsert ? LogEntryFactory.update(this.table, key, Bytes.from_array((byte[])value), transaction) : LogEntryFactory.insert(this.table, key, Bytes.from_array((byte[])value), transaction);
            CommitLogResult pos = this.log.log(entry, entry.transactionId <= 0L);
            res = pos.logSequenceNumber.thenApplyAsync(lsn -> {
                this.apply(pos, entry, false);
                return new DMLStatementExecutionResult(entry.transactionId, 1, key, insert.isReturnValues() ? Bytes.from_array((byte[])value) : null);
            }, (Executor)this.tableSpaceManager.getCallbacksExecutor());
        }
        if (transaction == null) {
            res = this.releaseWriteLock((CompletableFuture<StatementExecutionResult>)res, lock);
        }
        return res;
    }

    private CompletableFuture<StatementExecutionResult> releaseWriteLock(CompletableFuture<StatementExecutionResult> promise, LockHandle lock) {
        return promise.whenComplete((tr, error) -> this.locksManager.releaseWriteLock(lock));
    }

    private CompletableFuture<StatementExecutionResult> executeUpdateAsync(UpdateStatement update, final Transaction transaction, final StatementEvaluationContext context) throws StatementExecutionException, DataStorageManagerException {
        final AtomicInteger updateCount = new AtomicInteger();
        final Holder lastKey = new Holder();
        final Holder lastValue = new Holder();
        final RecordFunction function = update.getFunction();
        long transactionId = transaction != null ? transaction.transactionId : 0L;
        Predicate predicate = update.getPredicate();
        final Map<String, AbstractIndexManager> indexes = this.tableSpaceManager.getIndexesOnTable(this.table.name);
        ScanStatement scan = new ScanStatement(this.table.tablespace, this.table, predicate);
        final ArrayList writes = new ArrayList();
        this.accessTableData(scan, context, new ScanResultOperation(){

            @Override
            public void accept(Record actual, LockHandle lockHandle) throws StatementExecutionException, LogNotAvailableException, DataStorageManagerException {
                byte[] newValue = null;
                try {
                    newValue = function.computeNewValue(actual, context, TableManager.this.tableContext);
                    if (indexes != null) {
                        DataAccessor values = new Record(actual.key, Bytes.from_array((byte[])newValue)).getDataAccessor(TableManager.this.table);
                        for (AbstractIndexManager index : indexes.values()) {
                            RecordSerializer.validatePrimaryKey(values, index.getIndex(), index.getColumnNames());
                        }
                    }
                }
                catch (StatementExecutionException | IllegalArgumentException err) {
                    TableManager.this.locksManager.releaseLock(lockHandle);
                    writes.add(FutureUtils.exception((Throwable)((Object)new StatementExecutionException(((Throwable)err).getMessage(), (Throwable)err))));
                    return;
                }
                long size = DataPage.estimateEntrySize(actual.key, newValue);
                if (size > TableManager.this.maxLogicalPageSize) {
                    TableManager.this.locksManager.releaseLock(lockHandle);
                    writes.add(FutureUtils.exception((Throwable)((Object)new RecordTooBigException("New version of record " + actual.key + " is to big to be update: new size " + size + ", actual size " + DataPage.estimateEntrySize(actual) + ", max size " + TableManager.this.maxLogicalPageSize))));
                    return;
                }
                LogEntry entry = LogEntryFactory.update(TableManager.this.table, actual.key, Bytes.from_array((byte[])newValue), transaction);
                CommitLogResult pos = TableManager.this.log.log(entry, entry.transactionId <= 0L);
                writes.add(pos.logSequenceNumber.thenApply(lsn -> new PendingLogEntryWork(entry, pos, lockHandle)));
                lastKey.value = actual.key;
                lastValue.value = newValue;
                updateCount.incrementAndGet();
            }
        }, transaction, true, true);
        if (writes.isEmpty()) {
            return CompletableFuture.completedFuture(new DMLStatementExecutionResult(transactionId, 0, null, null));
        }
        if (writes.size() == 1) {
            return ((CompletableFuture)((CompletableFuture)writes.get(0)).whenCompleteAsync((pending, error) -> {
                try {
                    if (error == null) {
                        this.apply(pending.pos, pending.entry, false);
                    }
                }
                finally {
                    if (pending != null && pending.lockHandle != null) {
                        this.locksManager.releaseLock(pending.lockHandle);
                    }
                }
            }, (Executor)this.tableSpaceManager.getCallbacksExecutor())).thenApply(pending -> new DMLStatementExecutionResult(transactionId, updateCount.get(), (Bytes)lastKey.value, update.isReturnValues() ? (lastValue.value != null ? Bytes.from_array((byte[])((byte[])lastValue.value)) : null) : null));
        }
        return ((CompletableFuture)FutureUtils.collect(writes).whenCompleteAsync((pendings, error) -> {
            block7: {
                try {
                    if (error == null) {
                        for (PendingLogEntryWork pending : pendings) {
                            this.apply(pending.pos, pending.entry, false);
                        }
                    }
                    if (pendings == null) break block7;
                }
                catch (Throwable throwable) {
                    if (pendings != null) {
                        for (PendingLogEntryWork pending : pendings) {
                            if (pending.lockHandle == null) continue;
                            this.locksManager.releaseLock(pending.lockHandle);
                        }
                    }
                    throw throwable;
                }
                for (PendingLogEntryWork pending : pendings) {
                    if (pending.lockHandle == null) continue;
                    this.locksManager.releaseLock(pending.lockHandle);
                }
            }
        }, (Executor)this.tableSpaceManager.getCallbacksExecutor())).thenApply(pendings -> new DMLStatementExecutionResult(transactionId, updateCount.get(), (Bytes)lastKey.value, update.isReturnValues() ? (lastValue.value != null ? Bytes.from_array((byte[])((byte[])lastValue.value)) : null) : null));
    }

    private CompletableFuture<StatementExecutionResult> executeDeleteAsync(DeleteStatement delete, final Transaction transaction, StatementEvaluationContext context) {
        final AtomicInteger updateCount = new AtomicInteger();
        final Holder lastKey = new Holder();
        final Holder lastValue = new Holder();
        long transactionId = transaction != null ? transaction.transactionId : 0L;
        Predicate predicate = delete.getPredicate();
        final ArrayList writes = new ArrayList();
        ScanStatement scan = new ScanStatement(this.table.tablespace, this.table, predicate);
        this.accessTableData(scan, context, new ScanResultOperation(){

            @Override
            public void accept(Record actual, LockHandle lockHandle) throws StatementExecutionException, LogNotAvailableException, DataStorageManagerException {
                LogEntry entry = LogEntryFactory.delete(TableManager.this.table, actual.key, transaction);
                CommitLogResult pos = TableManager.this.log.log(entry, entry.transactionId <= 0L);
                writes.add(pos.logSequenceNumber.thenApply(lsn -> new PendingLogEntryWork(entry, pos, lockHandle)));
                lastKey.value = actual.key;
                lastValue.value = actual.value;
                updateCount.incrementAndGet();
            }
        }, transaction, true, true);
        if (writes.isEmpty()) {
            return CompletableFuture.completedFuture(new DMLStatementExecutionResult(transactionId, 0, null, null));
        }
        if (writes.size() == 1) {
            return ((CompletableFuture)((CompletableFuture)writes.get(0)).whenCompleteAsync((pending, error) -> {
                try {
                    if (error == null) {
                        this.apply(pending.pos, pending.entry, false);
                    }
                }
                finally {
                    if (pending != null && pending.lockHandle != null) {
                        this.locksManager.releaseLock(pending.lockHandle);
                    }
                }
            }, (Executor)this.tableSpaceManager.getCallbacksExecutor())).thenApply(pending -> new DMLStatementExecutionResult(transactionId, updateCount.get(), (Bytes)lastKey.value, delete.isReturnValues() ? (Bytes)lastValue.value : null));
        }
        return ((CompletableFuture)FutureUtils.collect(writes).whenCompleteAsync((pendings, error) -> {
            block7: {
                try {
                    if (error == null) {
                        for (PendingLogEntryWork pending : pendings) {
                            this.apply(pending.pos, pending.entry, false);
                        }
                    }
                    if (pendings == null) break block7;
                }
                catch (Throwable throwable) {
                    if (pendings != null) {
                        for (PendingLogEntryWork pending : pendings) {
                            if (pending.lockHandle == null) continue;
                            this.locksManager.releaseLock(pending.lockHandle);
                        }
                    }
                    throw throwable;
                }
                for (PendingLogEntryWork pending : pendings) {
                    if (pending.lockHandle == null) continue;
                    this.locksManager.releaseLock(pending.lockHandle);
                }
            }
        }, (Executor)this.tableSpaceManager.getCallbacksExecutor())).thenApply(pendings -> new DMLStatementExecutionResult(transactionId, updateCount.get(), (Bytes)lastKey.value, delete.isReturnValues() ? (Bytes)lastValue.value : null));
    }

    private StatementExecutionResult executeTruncate(TruncateTableStatement truncate, Transaction transaction, StatementEvaluationContext context) throws StatementExecutionException, DataStorageManagerException {
        if (transaction != null) {
            throw new StatementExecutionException("TRUNCATE TABLE cannot be executed within the context of a Transaction");
        }
        try {
            long estimatedSize = this.keyToPage.size();
            LOGGER.log(Level.INFO, "TRUNCATING TABLE {0} with approx {1} records", new Object[]{this.table.name, estimatedSize});
            LogEntry entry = LogEntryFactory.truncate(this.table, null);
            CommitLogResult pos = this.log.log(entry, entry.transactionId <= 0L);
            this.apply(pos, entry, false);
            return new DMLStatementExecutionResult(0L, estimatedSize > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)estimatedSize, null, null);
        }
        catch (LogNotAvailableException | DataStorageManagerException error) {
            LOGGER.log(Level.SEVERE, "Error during TRUNCATE table " + this.table.tablespace + "." + this.table.name, error);
            throw new StatementExecutionException(error);
        }
    }

    private void applyTruncate() throws DataStorageManagerException {
        if (this.createdInTransaction > 0L) {
            throw new DataStorageManagerException("TRUNCATE TABLE cannot be executed on an uncommitted table");
        }
        if (this.checkPointRunning) {
            throw new DataStorageManagerException("TRUNCATE TABLE cannot be executed during a checkpoint");
        }
        if (this.tableSpaceManager.isTransactionRunningOnTable(this.table.name)) {
            throw new DataStorageManagerException("TRUNCATE TABLE cannot be executed table " + this.table.tablespace + "." + this.table.name + ": at least one transaction is pending on it");
        }
        Map<String, AbstractIndexManager> indexes = this.tableSpaceManager.getIndexesOnTable(this.table.name);
        if (indexes != null) {
            for (AbstractIndexManager index : indexes.values()) {
                if (index.isAvailable()) continue;
                throw new DataStorageManagerException("index " + index.getIndexName() + " in not full available. Cannot TRUNCATE table " + this.table.tablespace + "." + this.table.name);
            }
        }
        this.unloadAllPagesForTruncate();
        this.pageSet.truncate();
        this.pages.clear();
        this.newPages.clear();
        this.initNewPages();
        this.locksManager.clear();
        this.keyToPage.truncate();
        if (indexes != null) {
            for (AbstractIndexManager index : indexes.values()) {
                index.truncate();
            }
        }
    }

    private void unloadAllPagesForTruncate() {
        long currentDirtyPageId = this.currentDirtyRecordsPage.get();
        List unload = this.pages.values().stream().filter(page -> page.pageId != currentDirtyPageId).collect(Collectors.toList());
        this.pageReplacementPolicy.remove(unload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTransactionCommit(Transaction transaction, boolean recovery) throws DataStorageManagerException {
        boolean lockAcquired;
        if (transaction == null) {
            throw new DataStorageManagerException("transaction cannot be null");
        }
        boolean forceFlushTableData = false;
        if (this.createdInTransaction > 0L) {
            if (transaction.transactionId != this.createdInTransaction) {
                throw new DataStorageManagerException("table " + this.table.tablespace + "." + this.table.name + " is available only on transaction " + this.createdInTransaction);
            }
            this.createdInTransaction = 0L;
            forceFlushTableData = true;
        }
        if (!transaction.lastSequenceNumber.after(this.bootSequenceNumber)) {
            if (recovery) {
                LOGGER.log(Level.FINER, "ignoring transaction {0} commit on recovery, {1}.{2} data is newer: transaction {3}, table {4}", new Object[]{transaction.transactionId, this.table.tablespace, this.table.name, transaction.lastSequenceNumber, this.bootSequenceNumber});
                return;
            }
            throw new DataStorageManagerException("corrupted commit log " + this.table.tablespace + "." + this.table.name + " data is newer than transaction " + transaction.transactionId + " transaction " + transaction.lastSequenceNumber + " table " + this.bootSequenceNumber);
        }
        try {
            lockAcquired = this.checkpointLock.asReadLock().tryLock(CHECKPOINT_LOCK_READ_TIMEOUT, TimeUnit.SECONDS);
        }
        catch (InterruptedException err) {
            throw new DataStorageManagerException("interrupted while acquiring checkpoint lock during a commit", err);
        }
        if (!lockAcquired) {
            throw new DataStorageManagerException("timed out while acquiring checkpoint lock during a commit");
        }
        try {
            Set<Bytes> deletedRecords;
            Map<Bytes, Record> changedRecords = transaction.changedRecords.get(this.table.name);
            Map<Bytes, Record> newRecords = transaction.newRecords.get(this.table.name);
            if (newRecords != null) {
                for (Record record : newRecords.values()) {
                    this.applyInsert(record.key, record.value, true);
                }
            }
            if (changedRecords != null) {
                for (Record r : changedRecords.values()) {
                    this.applyUpdate(r.key, r.value);
                }
            }
            if ((deletedRecords = transaction.deletedRecords.get(this.table.name)) != null) {
                for (Bytes key : deletedRecords) {
                    this.applyDelete(key);
                }
            }
        }
        finally {
            this.checkpointLock.asReadLock().unlock();
        }
        transaction.releaseLocksOnTable(this.table.name, this.locksManager);
        if (forceFlushTableData) {
            LOGGER.log(Level.INFO, "forcing local checkpoint, table " + this.table.name + " will be visible to all transactions now");
            this.checkpoint(false);
        }
    }

    @Override
    public void onTransactionRollback(Transaction transaction) {
        transaction.releaseLocksOnTable(this.table.name, this.locksManager);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void apply(CommitLogResult writeResult, LogEntry entry, boolean recovery) throws DataStorageManagerException, LogNotAvailableException {
        Transaction transaction;
        if (recovery) {
            if (writeResult.deferred) {
                throw new DataStorageManagerException("impossibile to have a deferred CommitLogResult during recovery");
            }
            LogSequenceNumber position = writeResult.getLogSequenceNumber();
            if (this.dumpLogSequenceNumber != null && !position.after(this.dumpLogSequenceNumber)) {
                transaction = null;
                if (entry.transactionId > 0L) {
                    transaction = this.tableSpaceManager.getTransaction(entry.transactionId);
                }
                if (transaction == null) {
                    LOGGER.log(Level.FINER, "{0}.{1} skip {2} at {3}, table restored from position {4}", new Object[]{this.table.tablespace, this.table.name, entry, position, this.dumpLogSequenceNumber});
                    return;
                }
                transaction.touch();
                LOGGER.log(Level.FINER, "{0}.{1} keep {2} at {3}, table restored from position {4}, it belongs to transaction {5} which was in progress during the dump of the table", new Object[]{this.table.tablespace, this.table.name, entry, position, this.dumpLogSequenceNumber, entry.transactionId});
            } else if (!position.after(this.bootSequenceNumber)) {
                transaction = null;
                if (entry.transactionId > 0L) {
                    transaction = this.tableSpaceManager.getTransaction(entry.transactionId);
                }
                if (transaction == null) {
                    LOGGER.log(Level.FINER, "{0}.{1} skip {2} at {3}, table booted at {4}", new Object[]{this.table.tablespace, this.table.name, entry, position, this.bootSequenceNumber});
                    return;
                }
                transaction.touch();
                LOGGER.log(Level.FINER, "{0}.{1} keep {2} at {3}, table booted at {4}, it belongs to transaction {5} which was in progress during the flush of the table", new Object[]{this.table.tablespace, this.table.name, entry, position, this.bootSequenceNumber, entry.transactionId});
            }
        }
        if (writeResult.sync) {
            writeResult.getLogSequenceNumber();
        }
        switch (entry.type) {
            case 4: {
                Bytes key = entry.key;
                if (entry.transactionId <= 0L) {
                    this.applyDelete(key);
                    return;
                }
                transaction = this.tableSpaceManager.getTransaction(entry.transactionId);
                if (transaction == null) {
                    if (!recovery) throw new DataStorageManagerException("no such transaction " + entry.transactionId);
                    if (!ignoreMissingTransactionsOnRecovery) throw new DataStorageManagerException("no such transaction " + entry.transactionId);
                    LOGGER.log(Level.WARNING, "Ignoring delete of {0} due to missing transaction {1}", new Object[]{entry.key, entry.transactionId});
                    return;
                }
                transaction.registerDeleteOnTable(this.table.name, key, writeResult);
                return;
            }
            case 3: {
                Bytes key = entry.key;
                Bytes value = entry.value;
                if (entry.transactionId <= 0L) {
                    this.applyUpdate(key, value);
                    return;
                }
                Transaction transaction2 = this.tableSpaceManager.getTransaction(entry.transactionId);
                if (transaction2 == null) {
                    if (!recovery) throw new DataStorageManagerException("no such transaction " + entry.transactionId);
                    if (!ignoreMissingTransactionsOnRecovery) throw new DataStorageManagerException("no such transaction " + entry.transactionId);
                    LOGGER.log(Level.WARNING, "Ignoring update of {0} due to missing transaction {1}", new Object[]{entry.key, entry.transactionId});
                    return;
                }
                transaction2.registerRecordUpdate(this.table.name, key, value, writeResult);
                return;
            }
            case 2: {
                Bytes key = entry.key;
                Bytes value = entry.value;
                if (entry.transactionId <= 0L) {
                    this.applyInsert(key, value, false);
                    return;
                }
                Transaction transaction3 = this.tableSpaceManager.getTransaction(entry.transactionId);
                if (transaction3 == null) {
                    if (!recovery) throw new DataStorageManagerException("no such transaction " + entry.transactionId);
                    if (!ignoreMissingTransactionsOnRecovery) throw new DataStorageManagerException("no such transaction " + entry.transactionId);
                    LOGGER.log(Level.WARNING, "Ignoring insert of {0} due to missing transaction {1}", new Object[]{entry.key, entry.transactionId});
                    return;
                }
                transaction3.registerInsertOnTable(this.table.name, key, value, writeResult);
                return;
            }
            case 12: {
                this.applyTruncate();
                return;
            }
        }
        throw new IllegalArgumentException("unhandled entry type " + entry.type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyDelete(Bytes key) throws DataStorageManagerException {
        Record previous;
        DataPage page;
        Map<String, AbstractIndexManager> indexes;
        Long pageId = this.keyToPage.remove(key);
        if (pageId == null) {
            throw new IllegalStateException("corrupted transaction log: key " + key + " is not present in table " + this.table.tablespace + "." + this.table.name);
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Deleted key " + key + " from page " + pageId + " from table " + this.table.tablespace + "." + this.table.name);
        }
        if ((indexes = this.tableSpaceManager.getIndexesOnTable(this.table.name)) == null) {
            page = (DataPage)((Object)this.newPages.get(pageId));
            if (page != null) {
                this.pageReplacementPolicy.pageHit((Page)page);
                previous = page.get(key);
                if (previous == null) {
                    throw new IllegalStateException("corrupted PK: old page " + pageId + " for deleted record at " + key + " was not found in table " + this.table.tablespace + "." + this.table.name);
                }
            } else {
                previous = null;
            }
        } else {
            page = this.loadPageToMemory(pageId, false);
            previous = page.get(key);
            if (previous == null) {
                throw new IllegalStateException("corrupted PK: old page " + pageId + " for deleted record at " + key + " was not found in table " + this.table.tablespace + "." + this.table.name);
            }
        }
        if (page == null || page.immutable) {
            this.pageSet.setPageDirty(pageId, previous);
        } else {
            Lock lock = page.pageLock.readLock();
            lock.lock();
            try {
                if (page.writable) {
                    page.remove(key);
                } else {
                    this.pageSet.setPageDirty(pageId, previous);
                }
            }
            finally {
                lock.unlock();
            }
        }
        if (indexes != null) {
            DataAccessor values = previous.getDataAccessor(this.table);
            for (AbstractIndexManager index : indexes.values()) {
                Bytes indexKey = RecordSerializer.serializePrimaryKey(values, (ColumnsList)index.getIndex(), index.getColumnNames());
                index.recordDeleted(key, indexKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyUpdate(Bytes key, Bytes value) throws DataStorageManagerException {
        Long insertionPageId;
        Record previous;
        DataPage prevPage;
        key = key.nonShared();
        Record record = new Record(key, value);
        Long prevPageId = this.keyToPage.get(key);
        if (prevPageId == null) {
            throw new IllegalStateException("corrupted transaction log: key " + key + " is not present in table " + this.table.tablespace + "." + this.table.name);
        }
        Map<String, AbstractIndexManager> indexes = this.tableSpaceManager.getIndexesOnTable(this.table.name);
        boolean insertedInSamePage = false;
        if (indexes == null) {
            prevPage = (DataPage)((Object)this.newPages.get(prevPageId));
            if (prevPage != null) {
                this.pageReplacementPolicy.pageHit((Page)prevPage);
                previous = prevPage.get(key);
                if (previous == null) {
                    throw new IllegalStateException("corrupted PK: old page " + prevPageId + " for updated record at " + key + " was not found in table " + this.table.tablespace + "." + this.table.name);
                }
            } else {
                previous = null;
            }
        } else {
            prevPage = this.loadPageToMemory(prevPageId, false);
            previous = prevPage.get(key);
            if (previous == null) {
                throw new IllegalStateException("corrupted PK: old page " + prevPageId + " for updated record at " + key + " was not found in table" + this.table.tablespace + "." + this.table.name);
            }
        }
        if (prevPage == null || prevPage.immutable) {
            this.pageSet.setPageDirty(prevPageId, previous);
        } else {
            Lock lock = prevPage.pageLock.readLock();
            lock.lock();
            try {
                if (prevPage.writable) {
                    insertedInSamePage = prevPage.put(record);
                } else {
                    this.pageSet.setPageDirty(prevPageId, previous);
                }
            }
            finally {
                lock.unlock();
            }
        }
        if (insertedInSamePage) {
            insertionPageId = prevPageId;
        } else {
            insertionPageId = this.currentDirtyRecordsPage.get();
            while (true) {
                DataPage newPage;
                if ((newPage = (DataPage)((Object)this.newPages.get(insertionPageId))) != null) {
                    this.pageReplacementPolicy.pageHit((Page)newPage);
                    if (!newPage.immutable) {
                        Lock lock = newPage.pageLock.readLock();
                        lock.lock();
                        try {
                            if (newPage.writable && newPage.put(record)) {
                                break;
                            }
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                }
                insertionPageId = this.allocateLivePage(insertionPageId);
            }
            this.keyToPage.put(key, insertionPageId);
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Updated key " + key + " from page " + prevPageId + " to page " + insertionPageId + " on table " + this.table.tablespace + "." + this.table.name);
        }
        if (indexes != null) {
            DataAccessor prevValues = previous.getDataAccessor(this.table);
            DataAccessor newValues = record.getDataAccessor(this.table);
            for (AbstractIndexManager index : indexes.values()) {
                Index indexDef = index.getIndex();
                String[] indexColumnNames = index.getColumnNames();
                Bytes indexKeyRemoved = RecordSerializer.serializePrimaryKey(prevValues, (ColumnsList)indexDef, indexColumnNames);
                Bytes indexKeyAdded = RecordSerializer.serializePrimaryKey(newValues, (ColumnsList)indexDef, indexColumnNames);
                index.recordUpdated(key, indexKeyRemoved, indexKeyAdded);
            }
        }
    }

    @Override
    public void dropTableData() throws DataStorageManagerException {
        this.dataStorageManager.dropTable(this.tableSpaceUUID, this.table.uuid);
        this.keyToPage.dropData();
        Map<String, AbstractIndexManager> indexes = this.tableSpaceManager.getIndexesOnTable(this.table.name);
        if (indexes != null) {
            for (AbstractIndexManager indexManager : indexes.values()) {
                indexManager.dropIndexData();
            }
        }
        this.unloadAllPagesForTruncate();
    }

    @Override
    public void scanForIndexRebuild(Consumer<Record> records) throws DataStorageManagerException {
        LocalScanPageCache localPageCache = new LocalScanPageCache();
        Consumer<Map.Entry> scanExecutor = entry -> {
            Bytes key = (Bytes)entry.getKey();
            LockHandle lock = this.lockForRead(key, null);
            try {
                Record record;
                Long pageId = (Long)entry.getValue();
                if (pageId != null && (record = this.fetchRecord(key, pageId, localPageCache)) != null) {
                    records.accept(record);
                }
            }
            catch (StatementExecutionException | DataStorageManagerException error) {
                throw new RuntimeException(error);
            }
            finally {
                this.locksManager.releaseReadLock(lock);
            }
        };
        try {
            Stream<Map.Entry<Bytes, Long>> scanner = this.keyToPage.scanner(null, StatementEvaluationContext.DEFAULT_EVALUATION_CONTEXT(), this.tableContext, null);
            scanner.forEach(scanExecutor);
        }
        catch (StatementExecutionException impossible) {
            throw new DataStorageManagerException((Throwable)((Object)impossible));
        }
    }

    @Override
    public void dump(LogSequenceNumber sequenceNumber, FullTableScanConsumer receiver) throws DataStorageManagerException {
        this.dataStorageManager.fullTableScan(this.tableSpaceUUID, this.table.uuid, sequenceNumber, receiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFromDump(List<Record> record) throws DataStorageManagerException {
        LOGGER.log(Level.INFO, "{0} received {1} records", new Object[]{this.table.name, record.size()});
        this.checkpointLock.asReadLock().lock();
        try {
            for (Record r : record) {
                this.applyInsert(r.key, r.value, false);
            }
        }
        finally {
            this.checkpointLock.asReadLock().unlock();
        }
    }

    private void rebuildNextPrimaryKeyValue() throws DataStorageManagerException {
        LOGGER.log(Level.INFO, "rebuildNextPrimaryKeyValue");
        try {
            Stream<Map.Entry<Bytes, Long>> scanner = this.keyToPage.scanner(null, StatementEvaluationContext.DEFAULT_EVALUATION_CONTEXT(), this.tableContext, null);
            scanner.forEach(t -> {
                Bytes key = (Bytes)t.getKey();
                long pk_logical_value = this.table.getColumn((String)this.table.primaryKey[0]).type == 2 || this.table.getColumn((String)this.table.primaryKey[0]).type == 12 ? (long)key.to_int() : key.to_long();
                this.nextPrimaryKeyValue.accumulateAndGet(pk_logical_value + 1L, (LongBinaryOperator)EnsureLongIncrementAccumulator.INSTANCE);
            });
            LOGGER.log(Level.INFO, "rebuildNextPrimaryKeyValue, newPkValue : " + this.nextPrimaryKeyValue.get());
        }
        catch (StatementExecutionException impossible) {
            throw new DataStorageManagerException((Throwable)((Object)impossible));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyInsert(Bytes key, Bytes value, boolean onTransaction) throws DataStorageManagerException {
        Map<String, AbstractIndexManager> indexes;
        key = key.nonShared();
        if (this.table.auto_increment) {
            long pk_logical_value = this.table.getColumn((String)this.table.primaryKey[0]).type == 2 || this.table.getColumn((String)this.table.primaryKey[0]).type == 12 ? (long)key.to_int() : key.to_long();
            this.nextPrimaryKeyValue.accumulateAndGet(pk_logical_value + 1L, (LongBinaryOperator)EnsureLongIncrementAccumulator.INSTANCE);
        }
        Record record = new Record(key, value);
        Long insertionPageId = this.currentDirtyRecordsPage.get();
        while (true) {
            DataPage newPage;
            if ((newPage = (DataPage)((Object)this.newPages.get(insertionPageId))) != null) {
                this.pageReplacementPolicy.pageHit((Page)newPage);
                if (!newPage.immutable) {
                    Lock lock = newPage.pageLock.readLock();
                    lock.lock();
                    try {
                        if (newPage.writable && newPage.put(record)) {
                            break;
                        }
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }
            insertionPageId = this.allocateLivePage(insertionPageId);
        }
        if (!this.keyToPage.put(key, insertionPageId, null)) {
            throw new IllegalStateException("corrupted transaction log: key " + key + " is already present in table " + this.table.tablespace + "." + this.table.name);
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Inserted key " + key + " into page " + insertionPageId + " into table " + this.table.tablespace + "." + this.table.name);
        }
        if ((indexes = this.tableSpaceManager.getIndexesOnTable(this.table.name)) != null) {
            DataAccessor values = record.getDataAccessor(this.table);
            for (AbstractIndexManager index : indexes.values()) {
                Bytes indexKey = RecordSerializer.serializePrimaryKey(values, (ColumnsList)index.getIndex(), index.getColumnNames());
                index.recordInserted(key, indexKey);
            }
        }
    }

    @Override
    public void flush() throws DataStorageManagerException {
        AbstractTableManager.TableCheckpoint checkpoint = this.checkpoint(false);
        if (checkpoint != null) {
            for (PostCheckpointAction action : checkpoint.actions) {
                action.run();
            }
        }
    }

    @Override
    public void close() {
        List unload = this.pages.values().stream().collect(Collectors.toList());
        this.pageReplacementPolicy.remove(unload);
        this.dataStorageManager.releaseKeyToPageMap(this.tableSpaceUUID, this.table.uuid, this.keyToPage);
    }

    private CompletableFuture<StatementExecutionResult> executeGetAsync(GetStatement get, Transaction transaction, StatementEvaluationContext context) {
        Bytes key;
        try {
            key = Bytes.from_nullable_array((byte[])get.getKey().computeNewValue(null, context, this.tableContext));
        }
        catch (StatementExecutionException validationError) {
            return FutureUtils.exception((Throwable)((Object)validationError));
        }
        Predicate predicate = get.getPredicate();
        boolean requireLock = get.isRequireLock();
        long transactionId = transaction != null ? transaction.transactionId : 0L;
        LockHandle lock = transaction != null || requireLock ? this.lockForRead(key, transaction) : null;
        CompletableFuture<GetResult> res = null;
        if (transaction != null) {
            if (transaction.recordDeleted(this.table.name, key)) {
                res = CompletableFuture.completedFuture(GetResult.NOT_FOUND(transactionId));
            } else {
                Record loadedInTransaction = transaction.recordUpdated(this.table.name, key);
                if (loadedInTransaction != null) {
                    res = predicate != null && !predicate.evaluate(loadedInTransaction, context) ? CompletableFuture.completedFuture(GetResult.NOT_FOUND(transactionId)) : CompletableFuture.completedFuture(new GetResult(transactionId, loadedInTransaction, this.table));
                } else {
                    loadedInTransaction = transaction.recordInserted(this.table.name, key);
                    if (loadedInTransaction != null) {
                        res = predicate != null && !predicate.evaluate(loadedInTransaction, context) ? CompletableFuture.completedFuture(GetResult.NOT_FOUND(transactionId)) : CompletableFuture.completedFuture(new GetResult(transactionId, loadedInTransaction, this.table));
                    }
                }
            }
        }
        if (res == null) {
            Record loaded;
            Long pageId = this.keyToPage.get(key);
            res = pageId == null ? CompletableFuture.completedFuture(GetResult.NOT_FOUND(transactionId)) : ((loaded = this.fetchRecord(key, pageId, null)) == null || predicate != null && !predicate.evaluate(loaded, context) ? CompletableFuture.completedFuture(GetResult.NOT_FOUND(transactionId)) : CompletableFuture.completedFuture(new GetResult(transactionId, loaded, this.table)));
        }
        if (transaction == null && lock != null) {
            res.whenComplete((r, e) -> this.locksManager.releaseReadLock(lock));
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataPage temporaryLoadPageToMemory(Long pageId) throws DataStorageManagerException {
        List<Record> page;
        long start = System.currentTimeMillis();
        this.maxCurrentPagesLoads.acquireUninterruptibly();
        long ioStart = System.currentTimeMillis();
        try {
            page = this.dataStorageManager.readPage(this.tableSpaceUUID, this.table.uuid, pageId);
        }
        catch (DataPageDoesNotExistException e) {
            DataPage dataPage = null;
            return dataPage;
        }
        finally {
            this.maxCurrentPagesLoads.release();
        }
        long ioStop = System.currentTimeMillis();
        DataPage result = this.buildImmutableDataPage(pageId, page);
        if (LOGGER.isLoggable(Level.FINE)) {
            long stop = System.currentTimeMillis();
            LOGGER.log(Level.FINE, "table {0}.{1}, temporary loaded {2} records from page {4} in {5} ms, ({6} ms read)", new Object[]{this.table.tablespace, this.table.name, result.size(), pageId, stop - start, ioStop - ioStart});
        }
        return result;
    }

    private DataPage loadPageToMemory(Long pageId, boolean recovery) throws DataStorageManagerException {
        DataPage result = (DataPage)((Object)this.pages.get(pageId));
        if (result != null) {
            this.pageReplacementPolicy.pageHit((Page)result);
            return result;
        }
        long _start = System.currentTimeMillis();
        long _ioAndLock = 0L;
        BooleanHolder computed = new BooleanHolder(false);
        try {
            result = this.pages.computeIfAbsent(pageId, id -> {
                try {
                    List<Record> page;
                    computed.value = true;
                    this.maxCurrentPagesLoads.acquireUninterruptibly();
                    try {
                        page = this.dataStorageManager.readPage(this.tableSpaceUUID, this.table.uuid, pageId);
                    }
                    finally {
                        this.maxCurrentPagesLoads.release();
                    }
                    this.loadedPagesCount.increment();
                    return this.buildImmutableDataPage(pageId, page);
                }
                catch (DataStorageManagerException err) {
                    throw new RuntimeException((Throwable)((Object)err));
                }
            });
            if (computed.value) {
                _ioAndLock = System.currentTimeMillis();
                Page.Metadata unload = this.pageReplacementPolicy.add((Page)result);
                if (unload != null) {
                    unload.owner.unload(unload.pageId);
                }
            }
        }
        catch (RuntimeException error) {
            Throwable cause;
            if (error.getCause() != null && (cause = error.getCause()) instanceof DataStorageManagerException) {
                if (cause instanceof DataPageDoesNotExistException) {
                    return null;
                }
                throw (DataStorageManagerException)((Object)cause);
            }
            throw new DataStorageManagerException(error);
        }
        if (computed.value && LOGGER.isLoggable(Level.FINE)) {
            long _stop = System.currentTimeMillis();
            LOGGER.log(Level.FINE, "table {0}.{1}, loaded {2} records from page {3} in {4} ms, ({5} ms read + plock, {6} ms unlock)", new Object[]{this.table.tablespace, this.table.name, result.size(), pageId, _stop - _start, _ioAndLock - _start, _stop - _ioAndLock});
        }
        return result;
    }

    private DataPage buildImmutableDataPage(long pageId, List<Record> page) {
        HashMap<Bytes, Record> newPageMap = new HashMap<Bytes, Record>(page.size());
        long estimatedPageSize = 0L;
        for (Record r : page) {
            newPageMap.put(r.key, r);
            estimatedPageSize += DataPage.estimateEntrySize(r);
        }
        return new DataPage(this, pageId, this.maxLogicalPageSize, estimatedPageSize, newPageMap, true);
    }

    @Override
    public AbstractTableManager.TableCheckpoint fullCheckpoint(boolean pin) throws DataStorageManagerException {
        return this.checkpoint(Double.NEGATIVE_INFINITY, this.fillThreshold, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, pin);
    }

    @Override
    public AbstractTableManager.TableCheckpoint checkpoint(boolean pin) throws DataStorageManagerException {
        return this.checkpoint(this.dirtyThreshold, this.fillThreshold, this.checkpointTargetTime, this.cleanupTargetTime, this.compactionTargetTime, pin);
    }

    @Override
    public void unpinCheckpoint(LogSequenceNumber sequenceNumber) throws DataStorageManagerException {
        Map<String, AbstractIndexManager> indexes = this.tableSpaceManager.getIndexesOnTable(this.table.name);
        if (indexes != null) {
            for (AbstractIndexManager indexManager : indexes.values()) {
                indexManager.unpinCheckpoint(sequenceNumber);
            }
        }
        this.keyToPage.unpinCheckpoint(sequenceNumber);
        this.dataStorageManager.unPinTableCheckpoint(this.tableSpaceUUID, this.table.uuid, sequenceNumber);
    }

    private static long sumOverflowWise(long a, long b) {
        long total = a + b;
        return total < 0L ? Long.MAX_VALUE : total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CleanAndCompactResult cleanAndCompactPages(List<CheckpointingPage> workingPages, DataPage buildingPage, boolean keepFlushedPageInMemory, long processLimitInstant) {
        long flushedRecords = 0L;
        ArrayList<Long> flushedPages = new ArrayList<Long>();
        long buildingPageSize = buildingPage.getUsedMemory();
        Lock lock = null;
        try {
            for (CheckpointingPage page : workingPages) {
                DataPage removedDataPage;
                boolean currentPageWasInMemory;
                Collection<Record> records;
                DataPage dataPage;
                flushedPages.add(page.pageId);
                if (lock == null) {
                    if (page.dirty) {
                        lock = buildingPage.pageLock.writeLock();
                        lock.lock();
                    }
                } else if (!page.dirty) {
                    lock.unlock();
                    lock = null;
                }
                if ((dataPage = (DataPage)((Object)this.pages.get(page.pageId))) == null) {
                    records = this.dataStorageManager.readPage(this.tableSpaceUUID, this.table.uuid, page.pageId);
                    currentPageWasInMemory = false;
                    LOGGER.log(Level.FINEST, "loaded dirty page {0} for table {1}.{2} on tmp buffer: {3} records", new Object[]{page.pageId, this.table.tablespace, this.table.name, records.size()});
                } else {
                    records = dataPage.getRecordsForFlush();
                    currentPageWasInMemory = true;
                    if (this.currentDirtyRecordsPage.get() != dataPage.pageId) {
                        this.pageReplacementPolicy.remove((Page)dataPage);
                    }
                }
                for (Record record : records) {
                    boolean handled;
                    long recordSize = DataPage.estimateEntrySize(record);
                    if (buildingPageSize + recordSize > this.maxLogicalPageSize) {
                        buildingPage.setUsedMemory(buildingPageSize);
                        if (lock != null) {
                            lock.unlock();
                            lock = null;
                        }
                        this.flushMutablePage(buildingPage, keepFlushedPageInMemory);
                        keepFlushedPageInMemory = false;
                        flushedRecords += (long)buildingPage.size();
                        buildingPageSize = 0L;
                        buildingPage = this.createMutablePage(this.nextPageId++, buildingPage.size(), 0L);
                        if (page.dirty && lock == null) {
                            lock = buildingPage.pageLock.writeLock();
                            lock.lock();
                        }
                    }
                    keepFlushedPageInMemory |= currentPageWasInMemory;
                    Record unshared = record.nonShared();
                    if (page.dirty) {
                        handled = this.keyToPage.put(unshared.key, buildingPage.pageId, page.pageId);
                        if (handled) {
                            buildingPage.putNoMemoryHandle(unshared);
                            buildingPageSize += recordSize;
                            continue;
                        }
                        this.checkpointProcessedDirtyRecords.add(1L);
                        continue;
                    }
                    buildingPage.putNoMemoryHandle(unshared);
                    buildingPageSize += recordSize;
                    handled = this.keyToPage.put(unshared.key, buildingPage.pageId, page.pageId);
                    if (handled) continue;
                    IllegalStateException ex = new IllegalStateException("Data inconsistency! Found a clean page with dirty records based on PK data. It could be a key to page inconsistency (broken PK) or a page metadata inconsistency (failed to track dirty record on page metadata). Page: " + page + ", Record: " + unshared + ", Table: " + this.table.tablespace + "." + this.table.name);
                    LOGGER.log(Level.SEVERE, ex.getMessage());
                    throw ex;
                }
                if (dataPage != null && (removedDataPage = (DataPage)((Object)this.pages.remove(page.pageId))) != null) {
                    long start = System.nanoTime();
                    boolean deepEquals = removedDataPage.deepEquals(dataPage);
                    long end = System.nanoTime();
                    LOGGER.log(Level.INFO, "Checked reloaded page during checkpoint deep equality in {0} ms", TimeUnit.NANOSECONDS.toMillis(end - start));
                    if (!deepEquals) {
                        IllegalStateException ex = new IllegalStateException("Data inconsistency! Failed to remove the right page from page knowledge during checkpoint. It could be an illegal concurrent write during checkpoint or the reloaded page doesn't match in memory one. Expected page " + (Object)((Object)dataPage) + ", found page " + (Object)((Object)removedDataPage) + " on table " + this.table.tablespace + "." + this.table.name);
                        LOGGER.log(Level.SEVERE, ex.getMessage());
                        throw ex;
                    }
                }
                if (processLimitInstant > System.currentTimeMillis()) continue;
                break;
            }
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
        buildingPage.setUsedMemory(buildingPageSize);
        return new CleanAndCompactResult(buildingPage, keepFlushedPageInMemory, flushedPages, flushedRecords);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractTableManager.TableCheckpoint checkpoint(double dirtyThreshold, double fillThreshold, long checkpointTargetTime, long cleanupTargetTime, long compactionTargetTime, boolean pin) throws DataStorageManagerException {
        long end;
        AbstractTableManager.TableCheckpoint result;
        long tablecheckpoint;
        long indexcheckpoint;
        long keytopagecheckpoint;
        long newPagesFlush;
        long smallPagesFlush;
        long dirtyPagesFlush;
        long pageAnalysis;
        long getlock;
        boolean lockAcquired;
        LOGGER.log(Level.INFO, "tableCheckpoint dirtyThreshold: " + dirtyThreshold + ", {0}.{1} (pin: {2})", new Object[]{this.tableSpaceUUID, this.table.name, pin});
        if (this.createdInTransaction > 0L) {
            LOGGER.log(Level.INFO, "checkpoint for table " + this.table.name + " skipped,this table is created on transaction " + this.createdInTransaction + " which is not committed");
            return null;
        }
        long fillPageThreshold = (long)(fillThreshold * (double)this.maxLogicalPageSize);
        long dirtyPageThreshold = dirtyThreshold > 0.0 ? (long)(dirtyThreshold * (double)this.maxLogicalPageSize) : -1L;
        long start = System.currentTimeMillis();
        ArrayList<PostCheckpointAction> actions = new ArrayList<PostCheckpointAction>();
        try {
            lockAcquired = this.checkpointLock.asWriteLock().tryLock(CHECKPOINT_LOCK_WRITE_TIMEOUT, TimeUnit.SECONDS);
        }
        catch (InterruptedException err) {
            throw new DataStorageManagerException("interrupted while waiting for checkpoint lock", err);
        }
        if (!lockAcquired) {
            throw new DataStorageManagerException("timed out while waiting for checkpoint lock, write lock " + this.checkpointLock.writeLock());
        }
        try {
            LogSequenceNumber sequenceNumber = this.log.getLastSequenceNumber();
            getlock = System.currentTimeMillis();
            this.checkPointRunning = true;
            long checkpointLimitInstant = TableManager.sumOverflowWise(getlock, checkpointTargetTime);
            Map<Long, PageSet.DataPageMetaData> activePages = this.pageSet.getActivePages();
            long flushedRecords = 0L;
            ArrayList<CheckpointingPage> flushingDirtyPages = new ArrayList<CheckpointingPage>();
            List<Object> flushingSmallPages = new ArrayList<CheckpointingPage>();
            HashSet<Long> flushedPages = new HashSet<Long>();
            int flushedDirtyPages = 0;
            int flushedSmallPages = 0;
            for (Map.Entry<Long, PageSet.DataPageMetaData> ref : activePages.entrySet()) {
                Long pageId = ref.getKey();
                PageSet.DataPageMetaData metadata = ref.getValue();
                long dirt = metadata.dirt.sum();
                if (dirt > 0L && dirt >= dirtyPageThreshold) {
                    flushingDirtyPages.add(new CheckpointingPage(pageId, dirt, dirt > 0L));
                    continue;
                }
                if (metadata.size > fillPageThreshold || this.maxLogicalPageSize - metadata.avgRecordSize < fillPageThreshold) continue;
                flushingSmallPages.add(new CheckpointingPage(pageId, metadata.size, dirt > 0L));
            }
            flushingDirtyPages.sort(CheckpointingPage.DESCENDING_ORDER);
            flushingSmallPages.sort(CheckpointingPage.ASCENDING_ORDER);
            pageAnalysis = System.currentTimeMillis();
            boolean keepFlushedPageInMemory = false;
            DataPage buildingPage = this.createMutablePage(this.nextPageId++, 0, 0L);
            if (!flushingDirtyPages.isEmpty()) {
                long timeLimit = Math.min(checkpointLimitInstant, TableManager.sumOverflowWise(pageAnalysis, cleanupTargetTime));
                CleanAndCompactResult dirtyResult = this.cleanAndCompactPages(flushingDirtyPages, buildingPage, keepFlushedPageInMemory, timeLimit);
                flushedDirtyPages = dirtyResult.flushedPages.size();
                flushedPages.addAll(dirtyResult.flushedPages);
                flushedRecords += dirtyResult.flushedRecords;
                keepFlushedPageInMemory = dirtyResult.keepFlushedPageInMemory;
                buildingPage = dirtyResult.buildingPage;
            }
            dirtyPagesFlush = System.currentTimeMillis();
            if ((flushingSmallPages = flushingSmallPages.stream().filter(wp -> !flushedPages.contains(((CheckpointingPage)wp).pageId)).collect(Collectors.toList())).size() == 1 && !((CheckpointingPage)flushingSmallPages.get(0)).dirty && buildingPage.isEmpty() && !this.newPages.values().stream().filter(p -> !p.isEmpty()).findAny().isPresent()) {
                flushingSmallPages.clear();
            }
            if (!flushingSmallPages.isEmpty()) {
                long timeLimit = Math.min(checkpointLimitInstant, TableManager.sumOverflowWise(dirtyPagesFlush, compactionTargetTime));
                CleanAndCompactResult smallResult = this.cleanAndCompactPages(flushingSmallPages, buildingPage, keepFlushedPageInMemory, timeLimit);
                flushedSmallPages = smallResult.flushedPages.size();
                flushedPages.addAll(smallResult.flushedPages);
                flushedRecords += smallResult.flushedRecords;
                keepFlushedPageInMemory = smallResult.keepFlushedPageInMemory;
                buildingPage = smallResult.buildingPage;
            }
            smallPagesFlush = System.currentTimeMillis();
            long lastKnownPageId = this.currentDirtyRecordsPage.get();
            long flushedNewPages = 0L;
            for (Object dataPage : this.newPages.values()) {
                if (lastKnownPageId == ((DataPage)((Object)dataPage)).pageId && ((DataPage)((Object)dataPage)).isEmpty()) continue;
                this.flushNewPageForCheckpoint((DataPage)((Object)dataPage), buildingPage);
                ++flushedNewPages;
                flushedRecords += (long)((DataPage)((Object)dataPage)).size();
            }
            if (!buildingPage.isEmpty()) {
                this.flushMutablePage(buildingPage, keepFlushedPageInMemory);
            } else {
                this.pages.remove(buildingPage.pageId);
            }
            newPagesFlush = System.currentTimeMillis();
            LOGGER.log(Level.INFO, "checkpoint {0}, logpos {1}, flushed: {2} dirty pages, {3} small pages, {4} new pages, {5} records", new Object[]{this.table.name, sequenceNumber, flushedDirtyPages, flushedSmallPages, flushedNewPages, flushedRecords});
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "checkpoint {0}, logpos {1}, flushed pages: {2}", new Object[]{this.table.name, sequenceNumber, ((Object)flushedPages).toString()});
            }
            actions.addAll(this.keyToPage.checkpoint(sequenceNumber, pin));
            keytopagecheckpoint = System.currentTimeMillis();
            Map<String, AbstractIndexManager> indexes = this.tableSpaceManager.getIndexesOnTable(this.table.name);
            if (indexes != null) {
                for (AbstractIndexManager indexManager : indexes.values()) {
                    actions.addAll(indexManager.checkpoint(sequenceNumber, pin));
                }
            }
            indexcheckpoint = System.currentTimeMillis();
            this.pageSet.checkpointDone(flushedPages);
            TableStatus tableStatus = new TableStatus(this.table.name, sequenceNumber, Bytes.longToByteArray((long)this.nextPrimaryKeyValue.get()), this.nextPageId, this.pageSet.getActivePages());
            actions.addAll(this.dataStorageManager.tableCheckpoint(this.tableSpaceUUID, this.table.uuid, tableStatus, pin));
            tablecheckpoint = System.currentTimeMillis();
            if (this.newPages.isEmpty()) {
                this.allocateLivePage(lastKnownPageId);
            }
            this.checkPointRunning = false;
            result = new AbstractTableManager.TableCheckpoint(this.table.name, sequenceNumber, actions);
            end = System.currentTimeMillis();
            LOGGER.log(Level.INFO, "checkpoint {0} finished, logpos {1}, {2} active pages, {3} dirty pages, flushed {4} records, total time {5} ms", new Object[]{this.table.name, sequenceNumber, this.pageSet.getActivePagesCount(), this.pageSet.getDirtyPagesCount(), flushedRecords, Long.toString(end - start)});
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "checkpoint {0} finished, logpos {1}, pageSet: {2}", new Object[]{this.table.name, sequenceNumber, this.pageSet.toString()});
            }
        }
        finally {
            this.checkpointLock.asWriteLock().unlock();
        }
        long delta = end - start;
        if (delta > 1000L) {
            long delta_lock = getlock - start;
            long delta_pageAnalysis = pageAnalysis - getlock;
            long delta_dirtyPagesFlush = dirtyPagesFlush - pageAnalysis;
            long delta_smallPagesFlush = smallPagesFlush - dirtyPagesFlush;
            long delta_newPagesFlush = newPagesFlush - smallPagesFlush;
            long delta_keytopagecheckpoint = keytopagecheckpoint - newPagesFlush;
            long delta_indexcheckpoint = indexcheckpoint - keytopagecheckpoint;
            long delta_tablecheckpoint = tablecheckpoint - indexcheckpoint;
            long delta_unload = end - tablecheckpoint;
            LOGGER.log(Level.INFO, "long checkpoint for {0}, time {1}", new Object[]{this.table.name, delta + " ms (" + delta_lock + "+" + delta_pageAnalysis + "+" + delta_dirtyPagesFlush + "+" + delta_smallPagesFlush + "+" + delta_newPagesFlush + "+" + delta_keytopagecheckpoint + "+" + delta_indexcheckpoint + "+" + delta_tablecheckpoint + "+" + delta_unload + ")"});
        }
        return result;
    }

    @Override
    public DataScanner scan(ScanStatement statement, StatementEvaluationContext context, Transaction transaction, boolean lockRequired, boolean forWrite) throws StatementExecutionException {
        TupleComparator comparator = statement.getComparator();
        if (!ENABLE_STREAMING_DATA_SCANNER || comparator != null && this.stats.getTablesize() > (long)HUGE_TABLE_SIZE_FORCE_MATERIALIZED_RESULTSET) {
            boolean sortedByClusteredIndex;
            boolean bl = sortedByClusteredIndex = comparator != null && comparator.isOnlyPrimaryKeyAndAscending() && this.keyToPageSortedAscending;
            if (!sortedByClusteredIndex) {
                return this.scanNoStream(statement, context, transaction, lockRequired, forWrite);
            }
        }
        return this.scanWithStream(statement, context, transaction, lockRequired, forWrite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataScanner scanNoStream(ScanStatement statement, final StatementEvaluationContext context, Transaction transaction, boolean lockRequired, boolean forWrite) throws StatementExecutionException {
        if (transaction != null) {
            transaction.increaseRefcount();
        }
        try {
            boolean sorted = statement.getComparator() != null;
            boolean sortedByClusteredIndex = statement.getComparator() != null && statement.getComparator().isOnlyPrimaryKeyAndAscending() && this.keyToPageSortedAscending;
            final Projection projection = statement.getProjection();
            final boolean applyProjectionDuringScan = !sorted && projection != null;
            final MaterializedRecordSet recordSet = applyProjectionDuringScan ? this.tableSpaceManager.getDbmanager().getRecordSetFactory().createRecordSet(projection.getFieldNames(), projection.getColumns()) : this.tableSpaceManager.getDbmanager().getRecordSetFactory().createRecordSet(this.table.columnNames, this.table.columns);
            ScanLimits limits = statement.getLimits();
            int maxRows = limits == null ? 0 : limits.computeMaxRows(context);
            int offset = limits == null ? 0 : limits.computeOffset(context);
            boolean sortDone = false;
            if (maxRows > 0) {
                AtomicInteger remaining;
                if (sortedByClusteredIndex) {
                    remaining = new AtomicInteger(maxRows);
                    if (offset > 0) {
                        remaining.getAndAdd(offset);
                    }
                    this.accessTableData(statement, context, new ScanResultOperation(){
                        private boolean inTransactionData;

                        @Override
                        public void beginNewRecordsInTransactionBlock() {
                            this.inTransactionData = true;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void accept(Record record, LockHandle lockHandle) throws StatementExecutionException {
                            try {
                                if (applyProjectionDuringScan) {
                                    DataAccessor tuple = projection.map(record.getDataAccessor(TableManager.this.table), context);
                                    recordSet.add(tuple);
                                } else {
                                    recordSet.add(record.getDataAccessor(TableManager.this.table));
                                }
                                if (!this.inTransactionData && remaining.decrementAndGet() == 0) {
                                    throw new ExitLoop(true);
                                }
                            }
                            finally {
                                TableManager.this.locksManager.releaseLock(lockHandle);
                            }
                        }
                    }, transaction, lockRequired, forWrite);
                    sortDone = transaction == null;
                } else if (sorted) {
                    final InStreamTupleSorter sorter = new InStreamTupleSorter(offset + maxRows, statement.getComparator());
                    this.accessTableData(statement, context, new ScanResultOperation(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void accept(Record record, LockHandle lockHandle) throws StatementExecutionException {
                            try {
                                if (applyProjectionDuringScan) {
                                    DataAccessor tuple = projection.map(record.getDataAccessor(TableManager.this.table), context);
                                    sorter.collect(tuple);
                                } else {
                                    sorter.collect(record.getDataAccessor(TableManager.this.table));
                                }
                            }
                            finally {
                                TableManager.this.locksManager.releaseLock(lockHandle);
                            }
                        }
                    }, transaction, lockRequired, forWrite);
                    sorter.flushToRecordSet(recordSet);
                    sortDone = true;
                } else {
                    remaining = new AtomicInteger(maxRows);
                    if (offset > 0) {
                        remaining.getAndAdd(offset);
                    }
                    this.accessTableData(statement, context, new ScanResultOperation(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void accept(Record record, LockHandle lockHandle) throws StatementExecutionException {
                            try {
                                if (applyProjectionDuringScan) {
                                    DataAccessor tuple = projection.map(record.getDataAccessor(TableManager.this.table), context);
                                    recordSet.add(tuple);
                                } else {
                                    recordSet.add(record.getDataAccessor(TableManager.this.table));
                                }
                                if (remaining.decrementAndGet() == 0) {
                                    throw new ExitLoop(false);
                                }
                            }
                            finally {
                                TableManager.this.locksManager.releaseLock(lockHandle);
                            }
                        }
                    }, transaction, lockRequired, forWrite);
                }
            } else {
                this.accessTableData(statement, context, new ScanResultOperation(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void accept(Record record, LockHandle lockHandle) throws StatementExecutionException {
                        try {
                            if (applyProjectionDuringScan) {
                                DataAccessor tuple = projection.map(record.getDataAccessor(TableManager.this.table), context);
                                recordSet.add(tuple);
                            } else {
                                recordSet.add(record.getDataAccessor(TableManager.this.table));
                            }
                        }
                        finally {
                            TableManager.this.locksManager.releaseLock(lockHandle);
                        }
                    }
                }, transaction, lockRequired, forWrite);
            }
            recordSet.writeFinished();
            if (!sortDone) {
                recordSet.sort(statement.getComparator());
            }
            recordSet.applyLimits(statement.getLimits(), context);
            if (!applyProjectionDuringScan) {
                recordSet.applyProjection(statement.getProjection(), context);
            }
            SimpleDataScanner simpleDataScanner = new SimpleDataScanner(transaction, recordSet);
            return simpleDataScanner;
        }
        finally {
            if (transaction != null) {
                transaction.decreaseRefCount();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataScanner scanWithStream(ScanStatement statement, StatementEvaluationContext context, Transaction transaction, boolean lockRequired, boolean forWrite) throws StatementExecutionException {
        if (transaction != null) {
            transaction.increaseRefcount();
        }
        try {
            Column[] columns;
            String[] fieldNames;
            Stream<DataAccessor> result;
            Stream<DataAccessor> fromTransactionSorted;
            TupleComparator comparator = statement.getComparator();
            boolean sorted = comparator != null;
            boolean sortedByClusteredIndex = comparator != null && comparator.isOnlyPrimaryKeyAndAscending() && this.keyToPageSortedAscending;
            Projection projection = statement.getProjection();
            boolean applyProjectionDuringScan = projection != null && !sorted;
            ScanLimits limits = statement.getLimits();
            int maxRows = limits == null ? 0 : limits.computeMaxRows(context);
            int offset = limits == null ? 0 : limits.computeOffset(context);
            Function<Record, DataAccessor> mapper = record -> {
                DataAccessor tuple = applyProjectionDuringScan ? projection.map(record.getDataAccessor(this.table), context) : record.getDataAccessor(this.table);
                return tuple;
            };
            Stream<Record> recordsFromTransactionSorted = this.streamTransactionData(transaction, statement.getPredicate(), context);
            Stream<DataAccessor> stream = fromTransactionSorted = recordsFromTransactionSorted != null ? recordsFromTransactionSorted.map(mapper) : null;
            if (fromTransactionSorted != null && comparator != null) {
                fromTransactionSorted = fromTransactionSorted.sorted(comparator);
            }
            Stream<DataAccessor> tableData = this.streamTableData(statement, context, transaction, lockRequired, forWrite).map(mapper);
            if (maxRows > 0) {
                if (sortedByClusteredIndex) {
                    if (fromTransactionSorted != null) {
                        tableData = tableData.limit(maxRows + offset);
                        fromTransactionSorted = fromTransactionSorted.limit(maxRows + offset);
                        result = Stream.concat(fromTransactionSorted, tableData).sorted(comparator);
                    } else {
                        result = tableData = tableData.limit(maxRows + offset);
                    }
                } else if (sorted) {
                    tableData = tableData.sorted(comparator);
                    if (fromTransactionSorted != null) {
                        tableData = tableData.limit(maxRows + offset);
                        fromTransactionSorted = fromTransactionSorted.limit(maxRows + offset);
                        result = Stream.concat(fromTransactionSorted, tableData).sorted(comparator);
                    } else {
                        result = tableData = tableData.limit(maxRows + offset);
                    }
                } else {
                    result = fromTransactionSorted == null ? tableData : Stream.concat(fromTransactionSorted, tableData);
                }
            } else if (sortedByClusteredIndex) {
                if (fromTransactionSorted != null) {
                    tableData = tableData.sorted(comparator);
                    result = Stream.concat(fromTransactionSorted, tableData).sorted(comparator);
                } else {
                    result = tableData;
                }
            } else {
                result = sorted ? (fromTransactionSorted != null ? Stream.concat(fromTransactionSorted, tableData).sorted(comparator) : tableData.sorted(comparator)) : (fromTransactionSorted != null ? Stream.concat(fromTransactionSorted, tableData) : tableData);
            }
            if (offset > 0) {
                result = result.skip(offset);
            }
            if (maxRows > 0) {
                result = result.limit(maxRows);
            }
            if (!applyProjectionDuringScan && projection != null) {
                result = result.map(r -> projection.map((DataAccessor)r, context));
            }
            if (projection != null) {
                fieldNames = projection.getFieldNames();
                columns = projection.getColumns();
            } else {
                fieldNames = this.table.columnNames;
                columns = this.table.columns;
            }
            StreamDataScanner streamDataScanner = new StreamDataScanner(transaction, fieldNames, columns, result);
            return streamDataScanner;
        }
        finally {
            if (transaction != null) {
                transaction.decreaseRefCount();
            }
        }
    }

    private void accessTableData(ScanStatement statement, final StatementEvaluationContext context, final ScanResultOperation consumer, final Transaction transaction, boolean lockRequired, final boolean forWrite) throws StatementExecutionException {
        statement.validateContext(context);
        final Predicate predicate = statement.getPredicate();
        long _start = System.currentTimeMillis();
        final boolean acquireLock = transaction != null || forWrite || lockRequired;
        final LocalScanPageCache lastPageRead = acquireLock ? null : new LocalScanPageCache();
        final AtomicInteger count = new AtomicInteger();
        try {
            IndexOperation indexOperation = predicate != null ? predicate.getIndexOperation() : null;
            final boolean primaryIndexSeek = indexOperation instanceof PrimaryIndexSeek;
            AbstractIndexManager useIndex = this.getIndexForTbleAccess(indexOperation);
            class RecordProcessor
            implements BatchOrderedExecutor.Executor<Map.Entry<Bytes, Long>>,
            Consumer<Map.Entry<Bytes, Long>> {
                RecordProcessor() {
                }

                public void execute(List<Map.Entry<Bytes, Long>> batch) throws HerdDBInternalException {
                    batch.forEach(entry -> this.accept((Map.Entry<Bytes, Long>)entry));
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void accept(Map.Entry<Bytes, Long> entry) throws DataStorageManagerException, StatementExecutionException, LogNotAvailableException {
                    boolean record_discarded;
                    if (transaction != null && count.incrementAndGet() % 1000 == 0) {
                        transaction.touch();
                    }
                    Bytes key = entry.getKey();
                    boolean already_locked = transaction != null && transaction.lookupLock(((TableManager)TableManager.this).table.name, key) != null;
                    boolean bl = record_discarded = !already_locked;
                    LockHandle lock = acquireLock ? (forWrite ? TableManager.this.lockForWrite(key, transaction) : TableManager.this.lockForRead(key, transaction)) : null;
                    try {
                        Long pageId;
                        if (transaction != null) {
                            if (transaction.recordDeleted(((TableManager)TableManager.this).table.name, key)) {
                                return;
                            }
                            Record record = transaction.recordUpdated(((TableManager)TableManager.this).table.name, key);
                            if (record != null) {
                                if (predicate == null || predicate.evaluate(record, context)) {
                                    record_discarded = false;
                                    consumer.accept(record, null);
                                }
                                return;
                            }
                        }
                        if ((pageId = entry.getValue()) != null) {
                            Record record;
                            boolean pkFilterCompleteMatch = false;
                            if (!primaryIndexSeek && predicate != null) {
                                Predicate.PrimaryKeyMatchOutcome outcome = predicate.matchesRawPrimaryKey(key, context);
                                if (outcome == Predicate.PrimaryKeyMatchOutcome.FAILED) {
                                    return;
                                }
                                if (outcome == Predicate.PrimaryKeyMatchOutcome.FULL_CONDITION_VERIFIED) {
                                    pkFilterCompleteMatch = true;
                                }
                            }
                            if ((record = TableManager.this.fetchRecord(key, pageId, lastPageRead)) != null && (pkFilterCompleteMatch || predicate == null || predicate.evaluate(record, context))) {
                                record_discarded = false;
                                consumer.accept(record, (LockHandle)(transaction == null ? lock : null));
                            }
                        }
                    }
                    finally {
                        if (record_discarded) {
                            if (transaction == null) {
                                TableManager.this.locksManager.releaseLock(lock);
                            } else if (!already_locked) {
                                transaction.releaseLockOnKey(((TableManager)TableManager.this).table.name, key, TableManager.this.locksManager);
                            }
                        }
                    }
                }
            }
            RecordProcessor scanExecutor = new RecordProcessor();
            boolean exit = false;
            try {
                if (primaryIndexSeek) {
                    PrimaryIndexSeek seek = (PrimaryIndexSeek)indexOperation;
                    Bytes value = Bytes.from_array((byte[])seek.value.computeNewValue(null, context, this.tableContext));
                    Long page = this.keyToPage.get(value);
                    if (page != null) {
                        AbstractMap.SimpleImmutableEntry<Bytes, Long> singleEntry = new AbstractMap.SimpleImmutableEntry<Bytes, Long>(value, page);
                        scanExecutor.accept((Map.Entry<Bytes, Long>)singleEntry);
                    }
                } else {
                    Stream<Map.Entry<Bytes, Long>> scanner = this.keyToPage.scanner(indexOperation, context, this.tableContext, useIndex);
                    BatchOrderedExecutor executor = new BatchOrderedExecutor(SORTED_PAGE_ACCESS_WINDOW_SIZE, (BatchOrderedExecutor.Executor)scanExecutor, SORTED_PAGE_ACCESS_COMPARATOR);
                    scanner.forEach((Consumer<Map.Entry<Bytes, Long>>)executor);
                    executor.finish();
                }
            }
            catch (ExitLoop exitLoop) {
                boolean bl = exit = !exitLoop.continueWithTransactionData;
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "exit loop during scan {0}, started at {1}: {2}", new Object[]{statement, new Timestamp(_start), exitLoop.toString()});
                }
            }
            catch (HerdDBInternalException error) {
                LOGGER.log(Level.SEVERE, "error during scan", error);
                if (error.getCause() instanceof StatementExecutionException) {
                    throw (StatementExecutionException)((Object)error.getCause());
                }
                if (error.getCause() instanceof DataStorageManagerException) {
                    throw (DataStorageManagerException)((Object)error.getCause());
                }
                if (error instanceof StatementExecutionException) {
                    throw error;
                }
                if (error instanceof DataStorageManagerException) {
                    throw error;
                }
                throw new StatementExecutionException(error);
            }
            if (!exit && transaction != null) {
                consumer.beginNewRecordsInTransactionBlock();
                Collection<Record> newRecordsForTable = transaction.getNewRecordsForTable(this.table.name);
                if (newRecordsForTable != null) {
                    newRecordsForTable.forEach(record -> {
                        if (!transaction.recordDeleted(this.table.name, record.key) && (predicate == null || predicate.evaluate((Record)record, context))) {
                            consumer.accept((Record)record, null);
                        }
                    });
                }
            }
        }
        catch (ExitLoop exitLoop) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "exit loop during scan {0}, started at {1}: {2}", new Object[]{statement, new Timestamp(_start), exitLoop.toString()});
            }
        }
        catch (StatementExecutionException err) {
            LOGGER.log(Level.SEVERE, "error during scan {0}, started at {1}: {2}", new Object[]{statement, new Timestamp(_start), err.toString()});
            throw err;
        }
        catch (HerdDBInternalException err) {
            LOGGER.log(Level.SEVERE, "error during scan {0}, started at {1}: {2}", new Object[]{statement, new Timestamp(_start), err.toString()});
            throw new StatementExecutionException(err);
        }
    }

    private Stream<Record> streamTableData(ScanStatement statement, StatementEvaluationContext context, Transaction transaction, boolean lockRequired, boolean forWrite) throws StatementExecutionException {
        statement.validateContext(context);
        Predicate predicate = statement.getPredicate();
        boolean acquireLock = transaction != null || forWrite || lockRequired;
        LocalScanPageCache lastPageRead = acquireLock ? null : new LocalScanPageCache();
        IndexOperation indexOperation = predicate != null ? predicate.getIndexOperation() : null;
        boolean primaryIndexSeek = indexOperation instanceof PrimaryIndexSeek;
        AbstractIndexManager useIndex = this.getIndexForTbleAccess(indexOperation);
        Stream<Map.Entry<Bytes, Long>> scanner = this.keyToPage.scanner(indexOperation, context, this.tableContext, useIndex);
        Stream<Record> resultFromTable = scanner.map(entry -> this.accessRecord((Map.Entry<Bytes, Long>)entry, predicate, context, transaction, lastPageRead, primaryIndexSeek, forWrite, acquireLock)).filter(r -> r != null);
        return resultFromTable;
    }

    private Stream<Record> streamTransactionData(Transaction transaction, Predicate predicate, StatementEvaluationContext context) {
        if (transaction != null) {
            transaction.touch();
            Collection<Record> newRecordsForTable = transaction.getNewRecordsForTable(this.table.name);
            if (newRecordsForTable == null || newRecordsForTable.isEmpty()) {
                return null;
            }
            return newRecordsForTable.stream().map(record -> {
                if (!transaction.recordDeleted(this.table.name, record.key) && (predicate == null || predicate.evaluate((Record)record, context))) {
                    return record;
                }
                return null;
            }).filter(r -> r != null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Record accessRecord(Map.Entry<Bytes, Long> entry, Predicate predicate, StatementEvaluationContext context, Transaction transaction, LocalScanPageCache lastPageRead, boolean primaryIndexSeek, boolean forWrite, boolean acquireLock) {
        boolean already_locked;
        Bytes key = entry.getKey();
        boolean keep_lock = false;
        boolean bl = already_locked = transaction != null && transaction.lookupLock(this.table.name, key) != null;
        LockHandle lock = acquireLock ? (forWrite ? this.lockForWrite(key, transaction) : this.lockForRead(key, transaction)) : null;
        try {
            Long pageId;
            if (transaction != null) {
                transaction.touch();
                if (transaction.recordDeleted(this.table.name, key)) {
                    Record record = null;
                    return record;
                }
                Record record = transaction.recordUpdated(this.table.name, key);
                if (record != null) {
                    if (predicate == null || predicate.evaluate(record, context)) {
                        keep_lock = true;
                        Record record2 = record;
                        return record2;
                    }
                    Record record3 = null;
                    return record3;
                }
            }
            if ((pageId = entry.getValue()) != null) {
                Record record;
                boolean pkFilterCompleteMatch = false;
                if (!primaryIndexSeek && predicate != null) {
                    Predicate.PrimaryKeyMatchOutcome outcome = predicate.matchesRawPrimaryKey(key, context);
                    if (outcome == Predicate.PrimaryKeyMatchOutcome.FAILED) {
                        Record record4 = null;
                        return record4;
                    }
                    if (outcome == Predicate.PrimaryKeyMatchOutcome.FULL_CONDITION_VERIFIED) {
                        pkFilterCompleteMatch = true;
                    }
                }
                if ((record = this.fetchRecord(key, pageId, lastPageRead)) != null && (pkFilterCompleteMatch || predicate == null || predicate.evaluate(record, context))) {
                    keep_lock = true;
                    Record record5 = record;
                    return record5;
                }
            }
            Record record = null;
            return record;
        }
        finally {
            if (transaction == null) {
                if (lock != null) {
                    this.locksManager.releaseLock(lock);
                }
            } else if (!keep_lock && !already_locked) {
                transaction.releaseLockOnKey(this.table.name, key, this.locksManager);
            }
        }
    }

    private AbstractIndexManager getIndexForTbleAccess(IndexOperation indexOperation) {
        Map<String, AbstractIndexManager> indexes;
        AbstractIndexManager useIndex = null;
        if (indexOperation != null && (indexes = this.tableSpaceManager.getIndexesOnTable(this.table.name)) != null && (useIndex = indexes.get(indexOperation.getIndexName())) != null && !useIndex.isAvailable()) {
            useIndex = null;
        }
        return useIndex;
    }

    @Override
    public List<Index> getAvailableIndexes() {
        Map<String, AbstractIndexManager> indexes = this.tableSpaceManager.getIndexesOnTable(this.table.name);
        if (indexes == null) {
            return Collections.emptyList();
        }
        return indexes.values().stream().filter(AbstractIndexManager::isAvailable).map(AbstractIndexManager::getIndex).collect(Collectors.toList());
    }

    @Override
    public KeyToPageIndex getKeyToPageIndex() {
        return this.keyToPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Record fetchRecord(Bytes key, Long pageId, LocalScanPageCache localScanPageCache) throws StatementExecutionException, DataStorageManagerException {
        DataPage dataPage;
        int maxTrials = 2;
        do {
            if ((dataPage = this.fetchDataPage(pageId, localScanPageCache)) != null) {
                Record record = dataPage.get(key);
                if (record != null) {
                    return record;
                }
                if (!dataPage.immutable) {
                    Lock lock = dataPage.pageLock.readLock();
                    lock.lock();
                    try {
                        record = dataPage.get(key);
                        if (record != null) {
                            Record record2 = record;
                            return record2;
                        }
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }
            Long relocatedPageId = this.keyToPage.get(key);
            LOGGER.log(Level.FINE, this.table.name + " fetchRecord " + key + " failed,checkPointRunning:" + this.checkPointRunning + " pageId:" + pageId + " relocatedPageId:" + relocatedPageId);
            if (relocatedPageId == null) {
                LOGGER.log(Level.FINE, "table " + this.table.name + ", activePages " + this.pageSet.getActivePages() + ", record " + key + " deleted during data access");
                return null;
            }
            pageId = relocatedPageId;
        } while (maxTrials-- != 0);
        if (dataPage != null) {
            Set<Bytes> keysForDebug = dataPage.getKeysForDebug();
            throw new DataStorageManagerException("inconsistency! table " + this.table.name + " no record in memory for " + key + " page " + pageId + ", activePages " + this.pageSet.getActivePages() + ", dataPage " + (Object)((Object)dataPage) + ", dataPageKeys =" + keysForDebug + " after many trials");
        }
        throw new DataStorageManagerException("inconsistency! table " + this.table.name + " no record in memory for " + key + " page " + pageId + ", activePages " + this.pageSet.getActivePages() + ", dataPage = null after many trials");
    }

    private DataPage fetchDataPage(Long pageId, LocalScanPageCache localScanPageCache) throws DataStorageManagerException {
        DataPage dataPage;
        if (localScanPageCache == null || !ENABLE_LOCAL_SCAN_PAGE_CACHE || this.pages.containsKey(pageId)) {
            dataPage = this.loadPageToMemory(pageId, false);
        } else if (pageId.equals(localScanPageCache.pageId)) {
            dataPage = localScanPageCache.value;
        } else {
            dataPage = (DataPage)((Object)this.pages.get(pageId));
            if (dataPage == null) {
                if (ThreadLocalRandom.current().nextInt(10) < 4) {
                    dataPage = this.loadPageToMemory(pageId, false);
                } else {
                    localScanPageCache.value = dataPage = this.temporaryLoadPageToMemory(pageId);
                    localScanPageCache.pageId = pageId;
                }
            } else {
                this.pageReplacementPolicy.pageHit((Page)dataPage);
            }
        }
        return dataPage;
    }

    @Override
    public TableManagerStats getStats() {
        return this.stats;
    }

    @Override
    public long getNextPrimaryKeyValue() {
        return this.nextPrimaryKeyValue.get();
    }

    @Override
    public boolean isSystemTable() {
        return false;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void validateAlterTable(final Table table, StatementEvaluationContext context) throws StatementExecutionException {
        ArrayList<String> columnsChangedFromNullToNotNull = new ArrayList<String>();
        for (Column c : this.table.columns) {
            Column newColumnSpecs = table.getColumn(c.name);
            if (newColumnSpecs == null) {
                LOGGER.log(Level.INFO, "Table {0}.{1} dropping column {2}", new Object[]{table.tablespace, table.name, c.name});
                continue;
            }
            if (newColumnSpecs.type == c.type) continue;
            if (ColumnTypes.isNotNullToNullConversion(c.type, newColumnSpecs.type)) {
                LOGGER.log(Level.INFO, "Table {0}.{1} making column {2} NULLABLE", new Object[]{table.tablespace, table.name, newColumnSpecs.name});
                continue;
            }
            if (!ColumnTypes.isNullToNotNullConversion(c.type, newColumnSpecs.type)) continue;
            LOGGER.log(Level.INFO, "Table {0}.{1} making column {2} NOT NULL", new Object[]{table.tablespace, table.name, newColumnSpecs.name});
            columnsChangedFromNullToNotNull.add(c.name);
        }
        for (final String column : columnsChangedFromNullToNotNull) {
            LOGGER.log(Level.INFO, "Table {0}.{1} validating column {2}, check for NULL values", new Object[]{table.tablespace, table.name, column});
            ScanStatement scan = new ScanStatement(this.table.tablespace, this.table, new Predicate(){

                @Override
                public boolean evaluate(Record record, StatementEvaluationContext context) throws StatementExecutionException {
                    return record.getDataAccessor(table).get(column) == null;
                }
            });
            scan.setLimits(new ScanLimitsImpl(1, 0));
            boolean foundOneNull = false;
            try (DataScanner scanner = this.scan(scan, context, null, false, false);){
                foundOneNull = scanner.hasNext();
            }
            catch (DataScannerException err) {
                throw new StatementExecutionException(err);
            }
            if (!foundOneNull) continue;
            throw new StatementExecutionException("Found a record in table " + table.name + " that contains a NULL value for column " + column + " ALTER command is not possible");
        }
    }

    @Override
    public void tableAltered(Table table, Transaction transaction) throws DDLException {
        ArrayList<String> droppedColumns = new ArrayList<String>();
        for (Column c : this.table.columns) {
            if (table.getColumn(c.name) != null) continue;
            droppedColumns.add(c.name);
        }
        this.table = table;
        if (!droppedColumns.isEmpty()) {
            this.pages.values().forEach(p -> p.flushRecordsCache());
        }
        if (this.table.auto_increment) {
            this.rebuildNextPrimaryKeyValue();
        }
    }

    @Override
    public long getCreatedInTransaction() {
        return this.createdInTransaction;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TableManager [table=").append(this.table).append("]");
        return builder.toString();
    }

    @Override
    public boolean isKeyToPageSortedAscending() {
        return this.keyToPageSortedAscending;
    }

    private final class TableManagerStatsImpl
    implements TableManagerStats {
        private TableManagerStatsImpl() {
        }

        @Override
        public int getLoadedpages() {
            return TableManager.this.pages.size();
        }

        @Override
        public long getLoadedPagesCount() {
            return TableManager.this.loadedPagesCount.sum();
        }

        @Override
        public long getUnloadedPagesCount() {
            return TableManager.this.unloadedPagesCount.sum();
        }

        @Override
        public long getTablesize() {
            return TableManager.this.keyToPage.size();
        }

        @Override
        public int getDirtypages() {
            return TableManager.this.pageSet.getDirtyPagesCount();
        }

        @Override
        public int getDirtyrecords() {
            int size = 0;
            for (DataPage newPage : TableManager.this.newPages.values()) {
                size += newPage.size();
            }
            return size;
        }

        @Override
        public long getDirtyUsedMemory() {
            long used = 0L;
            for (DataPage newPage : TableManager.this.newPages.values()) {
                used += newPage.getUsedMemory();
            }
            return used;
        }

        @Override
        public long getMaxLogicalPageSize() {
            return TableManager.this.maxLogicalPageSize;
        }

        @Override
        public long getBuffersUsedMemory() {
            long value = 0L;
            for (DataPage page : TableManager.this.pages.values()) {
                value += page.getUsedMemory();
            }
            return value;
        }

        @Override
        public long getKeysUsedMemory() {
            return TableManager.this.keyToPage.getUsedMemory();
        }
    }

    private static enum FlushNewPageResult {
        FLUSHED,
        ALREADY_FLUSHED,
        EMPTY_FLUSH;

    }

    static interface ScanResultOperation {
        default public void accept(Record record, LockHandle lockHandle) throws StatementExecutionException, DataStorageManagerException, LogNotAvailableException {
        }

        default public void beginNewRecordsInTransactionBlock() {
        }
    }

    private static final class CheckpointingPage {
        public static final Comparator<CheckpointingPage> ASCENDING_ORDER = (a, b) -> Long.compare(a.weight, b.weight);
        public static final Comparator<CheckpointingPage> DESCENDING_ORDER = (a, b) -> Long.compare(b.weight, a.weight);
        private final Long pageId;
        private final long weight;
        private final boolean dirty;

        public CheckpointingPage(Long pageId, long weight, boolean dirty) {
            this.pageId = pageId;
            this.weight = weight;
            this.dirty = dirty;
        }

        public String toString() {
            return this.pageId + ":" + this.weight;
        }
    }

    private static class CleanAndCompactResult {
        private final DataPage buildingPage;
        private final boolean keepFlushedPageInMemory;
        private final List<Long> flushedPages;
        private final long flushedRecords;

        public CleanAndCompactResult(DataPage buildingPage, boolean keepFlushedPageInMemory, List<Long> flushedPages, long flushedRecords) {
            this.buildingPage = buildingPage;
            this.keepFlushedPageInMemory = keepFlushedPageInMemory;
            this.flushedPages = flushedPages;
            this.flushedRecords = flushedRecords;
        }
    }

    static class ExitLoop
    extends RuntimeException {
        final boolean continueWithTransactionData;

        public ExitLoop(boolean continueWithTransactionData) {
            super(null, null, true, false);
            this.continueWithTransactionData = continueWithTransactionData;
        }
    }

    private static class PendingLogEntryWork {
        final LogEntry entry;
        final CommitLogResult pos;
        final LockHandle lockHandle;

        public PendingLogEntryWork(LogEntry entry, CommitLogResult pos, LockHandle lockHandle) {
            this.entry = entry;
            this.pos = pos;
            this.lockHandle = lockHandle;
        }
    }

    static interface StreamResultOperationStatus {
        default public void beginNewRecordsInTransactionBlock() {
        }

        default public void endNewRecordsInTransactionBlock() {
        }
    }
}

