/*
 * Decompiled with CFR 0.152.
 */
package herddb.core;

import herddb.core.ClockAdaptiveReplacement;
import herddb.core.ClockProPolicy;
import herddb.core.PageReplacementPolicy;
import herddb.core.RandomPageReplacementPolicy;
import herddb.utils.SystemProperties;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MemoryManager {
    private static final Logger LOGGER = Logger.getLogger(MemoryManager.class.getName());
    private static final String PAGE_REPLACEMENT_POLICY = SystemProperties.getStringSystemProperty((String)(MemoryManager.class.getName() + ".pageReplacementPolicy"), (String)"cp").toLowerCase(Locale.US);
    private final long maxDataUsedMemory;
    private final long maxPKUsedMemory;
    private final long maxLogicalPageSize;
    private final PageReplacementPolicy dataPageReplacementPolicy;
    private final PageReplacementPolicy pkPageReplacementPolicy;

    public MemoryManager(long maxDataUsedMemory, long maxPKUsedMemory, long maxLogicalPageSize) {
        this.maxDataUsedMemory = maxDataUsedMemory;
        this.maxPKUsedMemory = maxPKUsedMemory;
        this.maxLogicalPageSize = maxLogicalPageSize;
        if (maxDataUsedMemory < maxLogicalPageSize) {
            throw new IllegalArgumentException("Max memory for data pages (" + maxDataUsedMemory + ") must be greater or equal than page size (" + maxLogicalPageSize + ")");
        }
        if (maxPKUsedMemory < maxLogicalPageSize) {
            throw new IllegalArgumentException("Max memory for primary key index pages (" + maxPKUsedMemory + ") must be greater or equal than page size (" + maxLogicalPageSize + ")");
        }
        int dataPages = (int)(maxDataUsedMemory / maxLogicalPageSize);
        int pkPages = (int)(maxPKUsedMemory / maxLogicalPageSize);
        LOGGER.log(Level.INFO, "Maximum amount of memory for data and indexes {0}", maxDataUsedMemory / 0x100000L + " MB");
        LOGGER.log(Level.INFO, "Maximum amount of memory for primary key indexes {0}", maxPKUsedMemory / 0x100000L + " MB");
        LOGGER.log(Level.INFO, "Maximum number of loaded pages for data {0}, maximum number of loadedd pages for primary key indexes {1}", new Object[]{dataPages, pkPages});
        switch (PAGE_REPLACEMENT_POLICY) {
            case "random": {
                this.dataPageReplacementPolicy = new RandomPageReplacementPolicy(dataPages);
                this.pkPageReplacementPolicy = new RandomPageReplacementPolicy(pkPages);
                break;
            }
            case "cp": {
                this.dataPageReplacementPolicy = new ClockProPolicy(dataPages);
                this.pkPageReplacementPolicy = new ClockProPolicy(pkPages);
                break;
            }
            default: {
                this.dataPageReplacementPolicy = new ClockAdaptiveReplacement(dataPages);
                this.pkPageReplacementPolicy = new ClockAdaptiveReplacement(pkPages);
            }
        }
    }

    public long getMaxDataUsedMemory() {
        return this.maxDataUsedMemory;
    }

    public long getMaxIndexUsedMemory() {
        return this.maxPKUsedMemory;
    }

    public long getMaxLogicalPageSize() {
        return this.maxLogicalPageSize;
    }

    public PageReplacementPolicy getDataPageReplacementPolicy() {
        return this.dataPageReplacementPolicy;
    }

    public PageReplacementPolicy getPKPageReplacementPolicy() {
        return this.pkPageReplacementPolicy;
    }
}

