/*
 * Decompiled with CFR 0.152.
 */
package herddb.core;

import herddb.core.Page;
import herddb.core.TableManager;
import herddb.model.Record;
import herddb.utils.Bytes;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class DataPage
extends Page<TableManager> {
    public static final long CONSTANT_ENTRY_BYTE_SIZE = 32L;
    public final long maxSize;
    public final boolean immutable;
    private final Map<Bytes, Record> data;
    private final AtomicLong usedMemory;
    public final ReadWriteLock pageLock;
    public boolean writable;

    public static long estimateEntrySize(Bytes key, byte[] value) {
        return Record.estimateSize(key, value) + 32L;
    }

    public static long estimateEntrySize(Record record) {
        return record.getEstimatedSize() + 32L;
    }

    DataPage(TableManager owner, long pageId, long maxSize, long estimatedSize, Map<Bytes, Record> data, boolean immutable) {
        super((Page.Owner)owner, pageId);
        this.maxSize = maxSize;
        this.immutable = immutable;
        this.writable = !immutable;
        this.data = data;
        this.usedMemory = new AtomicLong(estimatedSize);
        this.pageLock = immutable ? null : new ReentrantReadWriteLock(false);
    }

    DataPage toImmutable() {
        if (this.immutable) {
            throw new IllegalStateException("page " + this.pageId + " already is immutable!");
        }
        if (this.writable) {
            throw new IllegalStateException("page " + this.pageId + " cannot be converted to immutable because still writable!");
        }
        return new DataPage((TableManager)this.owner, this.pageId, this.maxSize, this.usedMemory.get(), this.data, true);
    }

    Record remove(Bytes key) {
        if (this.immutable) {
            throw new IllegalStateException("page " + this.pageId + " is immutable!");
        }
        Record prev = this.data.remove(key);
        if (prev != null) {
            long size = DataPage.estimateEntrySize(prev);
            this.usedMemory.addAndGet(-size);
        }
        return prev;
    }

    Record get(Bytes key) {
        return this.data.get(key);
    }

    boolean put(Record record) {
        long target;
        if (this.immutable) {
            throw new IllegalStateException("page " + this.pageId + " is immutable!");
        }
        Record prev = this.data.put(record.key, record);
        long newSize = DataPage.estimateEntrySize(record);
        if (newSize > this.maxSize) {
            throw new IllegalStateException("record too big to fit in any page " + newSize + " / " + this.maxSize + " bytes");
        }
        long diff = prev == null ? newSize : newSize - DataPage.estimateEntrySize(prev);
        long old = this.usedMemory.getAndAccumulate(diff, (arg_0, arg_1) -> DataPage.lambda$put$0(target = this.maxSize - diff, diff, arg_0, arg_1));
        if (old > target) {
            this.data.remove(record.key);
            return false;
        }
        return true;
    }

    void putNoMemoryHandle(Record record) {
        if (this.immutable) {
            throw new IllegalStateException("page " + this.pageId + " is immutable!");
        }
        this.data.put(record.key, record);
    }

    void removeNoMemoryHandle(Record record) {
        if (this.immutable) {
            throw new IllegalStateException("page " + this.pageId + " is immutable!");
        }
        this.data.remove(record.key);
    }

    boolean isEmpty() {
        return this.data.isEmpty();
    }

    int size() {
        return this.data.size();
    }

    Collection<Record> getRecordsForFlush() {
        return this.data.values();
    }

    Set<Bytes> getKeysForDebug() {
        return this.data.keySet();
    }

    long getUsedMemory() {
        return this.usedMemory.get();
    }

    void setUsedMemory(long usedMemory) {
        this.usedMemory.set(usedMemory);
    }

    void clear() {
        if (this.immutable) {
            throw new IllegalStateException("page " + this.pageId + " is immutable!");
        }
        this.data.clear();
        this.usedMemory.set(0L);
    }

    public String toString() {
        return "DataPage{pageId=" + this.pageId + ", immutable=" + this.immutable + ", writable=" + this.writable + ", usedMemory=" + this.usedMemory + '}';
    }

    public int hashCode() {
        int prime = 31;
        return 31 + (int)(this.pageId ^ this.pageId >>> 32);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        DataPage other = (DataPage)((Object)obj);
        return this.pageId == other.pageId;
    }

    boolean deepEquals(DataPage other) {
        if (!this.equals((Object)other)) {
            return false;
        }
        return this.data.equals(other.data);
    }

    void flushRecordsCache() {
        this.data.values().forEach(r -> r.clearCache());
    }

    private static /* synthetic */ long lambda$put$0(long target, long diff, long curr, long change) {
        return curr > target ? curr : curr + diff;
    }
}

