/*
 * Decompiled with CFR 0.152.
 */
package herddb.cluster;

import herddb.cluster.BookkeeperCommitLogManager;
import herddb.cluster.LedgersInfo;
import herddb.cluster.ZookeeperMetadataStorageManager;
import herddb.log.CommitLog;
import herddb.log.CommitLogResult;
import herddb.log.FullRecoveryNeededException;
import herddb.log.LogEntry;
import herddb.log.LogEntryFactory;
import herddb.log.LogNotAvailableException;
import herddb.log.LogSequenceNumber;
import herddb.utils.EnsureLongIncrementAccumulator;
import herddb.utils.ExtendedDataInputStream;
import herddb.utils.SystemProperties;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.LongBinaryOperator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.client.api.LastConfirmedAndEntry;
import org.apache.bookkeeper.client.api.LedgerEntries;
import org.apache.bookkeeper.client.api.LedgerEntry;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.client.api.ReadHandle;
import org.apache.bookkeeper.client.api.WriteHandle;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.versioning.Versioned;

public class BookkeeperCommitLog
extends CommitLog {
    private static final Logger LOGGER = Logger.getLogger(BookkeeperCommitLog.class.getName());
    private static final int RECOVERY_BATCH_SIZE = SystemProperties.getIntSystemProperty((String)"herddb.commitlog.recoverybatchsize", (int)1000);
    private static final int MAX_ENTRY_TO_TAIL = SystemProperties.getIntSystemProperty((String)"herddb.commitlog.tailbatchsize", (int)10000);
    private static final int LONG_POLL_TIMEOUT = SystemProperties.getIntSystemProperty((String)"herddb.commitlog.longpolltimeout", (int)1000);
    static final String SHARED_SECRET = "herddb";
    private final BookKeeper bookKeeper;
    private final BookkeeperCommitLogManager parent;
    private final ZookeeperMetadataStorageManager metadataManager;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final String tableSpaceUUID;
    private final String tableSpaceName;
    private final String localNodeId;
    private volatile long lastApplicationWriteTs = 0L;
    private volatile CommitFileWriter writer;
    private volatile long currentLedgerId = 0L;
    private volatile long lastLedgerId = -1L;
    private final AtomicLong lastSequenceNumber = new AtomicLong(-1L);
    private LedgersInfo actualLedgersList;
    private int ensemble = 1;
    private int writeQuorumSize = 1;
    private int ackQuorumSize = 1;
    private long ledgersRetentionPeriod = 86400000L;
    private long maxLedgerSizeBytes = 0x40000000L;
    private long maxIdleTime = 0L;
    private boolean writeLedgerHeader = true;
    private volatile boolean closed = false;
    private volatile boolean failed = false;

    public LedgersInfo getActualLedgersList() {
        return this.actualLedgersList;
    }

    private void signalLogFailed() {
        this.failed = true;
    }

    public void rollNewLedger() {
        this.openNewLedger();
    }

    void forceLastAddConfirmed() {
        CommitFileWriter _writer;
        if (this.maxIdleTime <= 0L || this.closed) {
            return;
        }
        long _lastWriteTs = this.lastApplicationWriteTs;
        long idleTime = System.currentTimeMillis() - _lastWriteTs;
        if (_lastWriteTs > 0L && idleTime > this.maxIdleTime && !this.failed && !this.closed && (_writer = this.writer) != null) {
            _writer.writeNoop();
        }
    }

    public BookkeeperCommitLog(String tableSpaceUUID, String tableSpaceName, String localNodeId, ZookeeperMetadataStorageManager metadataStorageManager, BookKeeper bookkeeper, BookkeeperCommitLogManager parent) throws LogNotAvailableException {
        this.metadataManager = metadataStorageManager;
        this.tableSpaceUUID = tableSpaceUUID;
        this.tableSpaceName = tableSpaceName;
        this.localNodeId = localNodeId;
        this.bookKeeper = bookkeeper;
        this.parent = parent;
    }

    public long getLastLedgerId() {
        return this.lastLedgerId;
    }

    public int getEnsemble() {
        return this.ensemble;
    }

    public void setEnsemble(int ensemble) {
        this.ensemble = ensemble;
    }

    public int getWriteQuorumSize() {
        return this.writeQuorumSize;
    }

    public void setWriteQuorumSize(int writeQuorumSize) {
        this.writeQuorumSize = writeQuorumSize;
    }

    public int getAckQuorumSize() {
        return this.ackQuorumSize;
    }

    public void setAckQuorumSize(int ackQuorumSize) {
        this.ackQuorumSize = ackQuorumSize;
    }

    public long getLedgersRetentionPeriod() {
        return this.ledgersRetentionPeriod;
    }

    public void setLedgersRetentionPeriod(long ledgersRetentionPeriod) {
        this.ledgersRetentionPeriod = ledgersRetentionPeriod;
    }

    public long getMaxLedgerSizeBytes() {
        return this.maxLedgerSizeBytes;
    }

    public void setMaxLedgerSizeBytes(long maxLedgerSizeBytes) {
        this.maxLedgerSizeBytes = maxLedgerSizeBytes;
    }

    public long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(long maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public boolean isWriteLedgerHeader() {
        return this.writeLedgerHeader;
    }

    public void setWriteLedgerHeader(boolean writeLedgerHeader) {
        this.writeLedgerHeader = writeLedgerHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommitFileWriter getValidWriter() {
        this.lock.readLock().lock();
        try {
            CommitFileWriter _writer = this.writer;
            if (this.closed) {
                CommitFileWriter commitFileWriter = _writer;
                return commitFileWriter;
            }
            if (_writer == null || !_writer.isWritable()) {
                LOGGER.log(Level.INFO, "Writer {0} is no more writable, need to open a new writer", _writer);
                this.lock.readLock().unlock();
                this.lock.writeLock().lock();
                if (this.closed) {
                    CommitFileWriter commitFileWriter = _writer;
                    return commitFileWriter;
                }
                try {
                    _writer = this.writer;
                    if (_writer == null || !_writer.isWritable()) {
                        CommitFileWriter commitFileWriter = this.openNewLedger();
                        return commitFileWriter;
                    }
                }
                finally {
                    this.lock.writeLock().unlock();
                    this.lock.readLock().lock();
                }
            }
            CommitFileWriter commitFileWriter = _writer;
            return commitFileWriter;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public CommitLogResult log(LogEntry edit, boolean sync) {
        CompletableFuture res;
        CommitFileWriter _writer = null;
        try {
            _writer = this.getValidWriter();
        }
        catch (LogNotAvailableException errorWhileRollingLedger) {
            LOGGER.log(Level.SEVERE, "Cannot get a valid writer for " + this.tableSpaceDescription(), (Throwable)((Object)errorWhileRollingLedger));
        }
        if (this.failed) {
            res = FutureUtils.exception((Throwable)new LogNotAvailableException(new Exception("this commitlog is failed, tablespace " + this.tableSpaceDescription() + ", node " + this.localNodeId)).fillInStackTrace());
        } else if (this.closed || _writer == null) {
            res = FutureUtils.exception((Throwable)new LogNotAvailableException(new Exception("this commitlog has been closed, tablespace " + this.tableSpaceDescription() + ", node " + this.localNodeId)).fillInStackTrace());
        } else {
            res = _writer.writeEntry(edit);
            res = res.thenApply(pos -> {
                if (this.lastLedgerId == pos.ledgerId) {
                    this.lastSequenceNumber.accumulateAndGet(pos.offset, (LongBinaryOperator)EnsureLongIncrementAccumulator.INSTANCE);
                }
                this.notifyListeners((LogSequenceNumber)pos, edit);
                return pos;
            });
        }
        if (!sync) {
            return new CommitLogResult(CompletableFuture.completedFuture(null), true, false);
        }
        return new CommitLogResult(res, false, true);
    }

    private String tableSpaceDescription() {
        return this.tableSpaceName + " (" + this.tableSpaceUUID + ")";
    }

    private void handleBookKeeperFailure(Throwable cause, LogEntry edit) {
        if (cause.getCause() != null && cause instanceof CompletionException) {
            cause = cause.getCause();
        }
        if (cause.getCause() != null && cause instanceof LogNotAvailableException) {
            cause = cause.getCause();
        }
        LOGGER.log(Level.SEVERE, "bookkeeper async failure on tablespace " + this.tableSpaceDescription() + " while writing entry " + edit, cause);
        if (cause instanceof BKException.BKLedgerClosedException) {
            LOGGER.log(Level.SEVERE, "ledger has been closed, need to open a new ledger for tablespace " + this.tableSpaceDescription(), cause);
        } else if (cause instanceof BKException.BKLedgerFencedException) {
            LOGGER.log(Level.SEVERE, "this server was fenced for tablespace " + this.tableSpaceDescription() + " !", cause);
            this.signalLogFailed();
        } else if (cause instanceof org.apache.bookkeeper.client.api.BKException) {
            LOGGER.log(Level.SEVERE, "bookkeeper failure for tablespace " + this.tableSpaceDescription(), cause);
            this.signalLogFailed();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CommitFileWriter openNewLedger() throws LogNotAvailableException {
        CommitFileWriter commitFileWriter;
        block12: {
            Long pendingLedgerId = null;
            this.lock.writeLock().lock();
            try {
                this.closeCurrentWriter(true);
                this.writer = new CommitFileWriter();
                pendingLedgerId = this.writer.getLedgerId();
                this.writer.writeLedgerHeader();
                pendingLedgerId = null;
                this.currentLedgerId = this.writer.getLedgerId();
                LOGGER.log(Level.INFO, "Tablespace {1}, opened new ledger:{0}", new Object[]{this.currentLedgerId, this.tableSpaceDescription()});
                if (this.actualLedgersList.getFirstLedger() < 0L) {
                    this.actualLedgersList.setFirstLedger(this.currentLedgerId);
                }
                this.actualLedgersList.addLedger(this.currentLedgerId);
                this.metadataManager.saveActualLedgersList(this.tableSpaceUUID, this.actualLedgersList);
                commitFileWriter = this.writer;
                if (pendingLedgerId == null) break block12;
                LOGGER.log(Level.SEVERE, "Trying to delete bad ledge from metadata {0}", pendingLedgerId);
            }
            catch (LogNotAvailableException err) {
                try {
                    this.signalLogFailed();
                    throw err;
                }
                catch (Throwable throwable) {
                    if (pendingLedgerId != null) {
                        LOGGER.log(Level.SEVERE, "Trying to delete bad ledge from metadata {0}", pendingLedgerId);
                        try {
                            this.bookKeeper.deleteLedger(pendingLedgerId.longValue());
                        }
                        catch (InterruptedException ex) {
                            LOGGER.log(Level.SEVERE, "Cannot delete bad ledge from metadata " + pendingLedgerId, ex);
                            Thread.currentThread().interrupt();
                        }
                        catch (BKException ex) {
                            LOGGER.log(Level.SEVERE, "Cannot delete bad ledge from metadata " + pendingLedgerId, ex);
                        }
                    }
                    this.lock.writeLock().unlock();
                    throw throwable;
                }
            }
            try {
                this.bookKeeper.deleteLedger(pendingLedgerId.longValue());
            }
            catch (InterruptedException ex) {
                LOGGER.log(Level.SEVERE, "Cannot delete bad ledge from metadata " + pendingLedgerId, ex);
                Thread.currentThread().interrupt();
            }
            catch (BKException ex) {
                LOGGER.log(Level.SEVERE, "Cannot delete bad ledge from metadata " + pendingLedgerId, ex);
            }
        }
        this.lock.writeLock().unlock();
        return commitFileWriter;
    }

    @Override
    public boolean isRecoveryAvailable(LogSequenceNumber snapshotSequenceNumber) {
        LedgersInfo actualLedgersListFromMetadata = this.metadataManager.getActualLedgersList(this.tableSpaceUUID);
        return BookkeeperCommitLog.isRecoveryAvailable(snapshotSequenceNumber, actualLedgersListFromMetadata, this.tableSpaceDescription());
    }

    private static boolean isRecoveryAvailable(LogSequenceNumber snapshotSequenceNumber, LedgersInfo actualLedgersList, String tableSpaceDescription) {
        long snapshotLedgerId = snapshotSequenceNumber.ledgerId;
        LOGGER.log(Level.INFO, "Actual ledgers list:{0} tableSpace {1}", new Object[]{actualLedgersList, tableSpaceDescription});
        if (snapshotLedgerId > 0L && !actualLedgersList.getActiveLedgers().contains(snapshotLedgerId) && !actualLedgersList.getActiveLedgers().isEmpty()) {
            LOGGER.log(Level.SEVERE, "Actual ledgers list does not include latest snapshot ledgerid:" + snapshotLedgerId + " tablespace " + tableSpaceDescription);
            return false;
        }
        if (snapshotSequenceNumber.isStartOfTime() && !actualLedgersList.getActiveLedgers().isEmpty() && !actualLedgersList.getActiveLedgers().contains(actualLedgersList.getFirstLedger())) {
            LOGGER.log(Level.SEVERE, "Tablespace " + tableSpaceDescription + ": Local data is absent, and actual ledger list " + actualLedgersList.getActiveLedgers() + " does not contain first ledger of ever: " + actualLedgersList.getFirstLedger());
            return false;
        }
        return true;
    }

    @Override
    public void recovery(LogSequenceNumber snapshotSequenceNumber, BiConsumer<LogSequenceNumber, LogEntry> consumer, boolean fencing) throws LogNotAvailableException {
        String tableSpaceDescription = this.tableSpaceDescription();
        this.actualLedgersList = this.metadataManager.getActualLedgersList(this.tableSpaceUUID);
        LOGGER.log(Level.INFO, "Actual ledgers list:{0} tableSpace {1}", new Object[]{this.actualLedgersList, tableSpaceDescription});
        this.lastLedgerId = snapshotSequenceNumber.ledgerId;
        this.currentLedgerId = snapshotSequenceNumber.ledgerId;
        this.lastSequenceNumber.set(snapshotSequenceNumber.offset);
        LOGGER.log(Level.INFO, "recovery from latest snapshotSequenceNumber:{0} tableSpace {1}, node {2}, fencing {3}", new Object[]{snapshotSequenceNumber, tableSpaceDescription, this.localNodeId, fencing});
        if (!BookkeeperCommitLog.isRecoveryAvailable(snapshotSequenceNumber, this.actualLedgersList, tableSpaceDescription)) {
            throw new FullRecoveryNeededException("Cannot recover from BookKeeper, not enough data, plese check the logs");
        }
        for (long ledgerId : this.actualLedgersList.getActiveLedgers()) {
            try {
                Versioned result = (Versioned)FutureUtils.result((CompletableFuture)this.bookKeeper.getLedgerManager().readLedgerMetadata(ledgerId));
                LedgerMetadata metadata = (LedgerMetadata)result.getValue();
                String ledgerLeader = BookkeeperCommitLog.extractLeaderFromMetadata(metadata.getCustomMetadata());
                LOGGER.log(Level.INFO, "Ledger {0}: {1} {2} created by {3}, LastEntryId {4} Length {5}", new Object[]{String.valueOf(ledgerId), metadata.getState(), metadata.getAllEnsembles(), ledgerLeader, metadata.getLastEntryId(), metadata.getLength()});
            }
            catch (BKException.BKNoSuchLedgerExistsException | BKException.BKNoSuchLedgerExistsOnMetadataServerException e) {
                throw new FullRecoveryNeededException(new Exception("Actual ledgers list includes a not existing ledgerid:" + ledgerId + " tablespace " + tableSpaceDescription));
            }
            catch (LogNotAvailableException e) {
                throw e;
            }
            catch (Exception e) {
                throw new LogNotAvailableException(e);
            }
        }
        try {
            for (long ledgerId : this.actualLedgersList.getActiveLedgers()) {
                LedgerHandle handle;
                if (ledgerId < snapshotSequenceNumber.ledgerId) {
                    LOGGER.log(Level.FINER, "Skipping ledger {0}", ledgerId);
                    continue;
                }
                try {
                    handle = fencing ? this.bookKeeper.openLedger(ledgerId, BookKeeper.DigestType.CRC32C, SHARED_SECRET.getBytes(StandardCharsets.UTF_8)) : this.bookKeeper.openLedgerNoRecovery(ledgerId, BookKeeper.DigestType.CRC32C, SHARED_SECRET.getBytes(StandardCharsets.UTF_8));
                }
                catch (org.apache.bookkeeper.client.api.BKException errorDuringOpen) {
                    throw new LogNotAvailableException("Cannot open ledger " + ledgerId + " (fencing " + fencing + "): " + (Object)((Object)errorDuringOpen), errorDuringOpen);
                }
                try {
                    long first;
                    if (ledgerId == snapshotSequenceNumber.ledgerId) {
                        first = snapshotSequenceNumber.offset;
                        if (first == -1L) {
                            LOGGER.log(Level.INFO, "Tablespace " + tableSpaceDescription + ", recovering from latest snapshot ledger " + ledgerId + ", first entry " + first + " is not valid. Adjusting to 0");
                            first = 0L;
                        }
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, "Tablespace " + tableSpaceDescription + ", recovering from latest snapshot ledger " + ledgerId + ", starting from entry " + first);
                        }
                    } else {
                        first = 0L;
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, "Tablespace " + tableSpaceDescription + ", recovering from ledger " + ledgerId + ", starting from entry " + first);
                        }
                    }
                    long lastAddConfirmed = handle.getLastAddConfirmed();
                    String ledgerLeader = BookkeeperCommitLog.extractLeaderFromMetadata(handle.getLedgerMetadata().getCustomMetadata());
                    LOGGER.log(Level.INFO, "Tablespace " + tableSpaceDescription + ", Recovering from ledger " + ledgerId + ", first=" + first + " lastAddConfirmed=" + lastAddConfirmed + " written by " + ledgerLeader);
                    if (lastAddConfirmed < 0L) continue;
                    long b = first;
                    while (b <= lastAddConfirmed) {
                        long start = b;
                        long end = b + (long)RECOVERY_BATCH_SIZE;
                        if (end > lastAddConfirmed) {
                            end = lastAddConfirmed;
                        }
                        b = end + 1L;
                        double percent = (double)(start - first) * 100.0 / (double)(lastAddConfirmed + 1L);
                        int entriesToRead = (int)(1L + end - start);
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, "{3} From entry {0}, to entry {1} ({2} %)", new Object[]{start, end, percent, tableSpaceDescription});
                        }
                        long _start = System.currentTimeMillis();
                        int localEntryCount = 0;
                        try (LedgerEntries entries = handle.read(start, end);){
                            for (LedgerEntry entry : entries) {
                                long entryId = entry.getEntryId();
                                LogSequenceNumber number = new LogSequenceNumber(ledgerId, entryId);
                                LogEntry statusEdit = this.readLogEntry(entry);
                                this.lastLedgerId = ledgerId;
                                this.currentLedgerId = ledgerId;
                                this.lastSequenceNumber.set(entryId);
                                if (number.after(snapshotSequenceNumber)) {
                                    if (LOGGER.isLoggable(Level.FINEST)) {
                                        LOGGER.log(Level.FINEST, "rec " + this.tableSpaceName + " #" + localEntryCount + " {0}, {1}", new Object[]{number, statusEdit});
                                    }
                                    consumer.accept(number, statusEdit);
                                } else if (LOGGER.isLoggable(Level.FINEST)) {
                                    LOGGER.log(Level.FINEST, "skip " + this.tableSpaceName + " #" + localEntryCount + " {0}<{1}, {2}", new Object[]{number, snapshotSequenceNumber, statusEdit});
                                }
                                ++localEntryCount;
                            }
                        }
                        LOGGER.log(Level.FINER, this.tableSpaceDescription() + " read " + localEntryCount + " entries from ledger " + ledgerId + ", expected " + entriesToRead);
                        if (localEntryCount != entriesToRead) {
                            throw new LogNotAvailableException(this.tableSpaceDescription() + " Read " + localEntryCount + " entries, expected " + entriesToRead);
                        }
                        this.lastLedgerId = ledgerId;
                        this.lastSequenceNumber.set(end);
                        long _stop = System.currentTimeMillis();
                        LOGGER.log(Level.INFO, "{4} From entry {0}, to entry {1} ({2} %) read time {3}", new Object[]{start, end, percent, _stop - _start + " ms", tableSpaceDescription});
                    }
                }
                catch (RuntimeException err) {
                    LOGGER.log(Level.SEVERE, "Internal error while recovering tablespace " + this.tableSpaceDescription() + ": " + err, err);
                    throw err;
                }
                finally {
                    handle.close();
                }
            }
            LOGGER.log(Level.INFO, "After recovery of {0} lastSequenceNumber {1}", new Object[]{tableSpaceDescription, this.getLastSequenceNumber()});
        }
        catch (IOException | InterruptedException | org.apache.bookkeeper.client.api.BKException err) {
            LOGGER.log(Level.SEVERE, "Fatal error during recovery of " + this.tableSpaceDescription(), err);
            this.signalLogFailed();
            throw new LogNotAvailableException(err);
        }
        catch (LogNotAvailableException err) {
            LOGGER.log(Level.SEVERE, "Fatal error during recovery of " + this.tableSpaceDescription(), (Throwable)((Object)err));
            this.signalLogFailed();
            throw err;
        }
    }

    private static String extractLeaderFromMetadata(Map<String, byte[]> metadata) {
        byte[] leaderInMetadata = metadata.get("leader");
        String ledgerLeader = leaderInMetadata != null ? new String(leaderInMetadata, StandardCharsets.UTF_8) : "?";
        return ledgerLeader;
    }

    @Override
    public void startWriting() throws LogNotAvailableException {
        this.actualLedgersList = this.metadataManager.getActualLedgersList(this.tableSpaceUUID);
        this.openNewLedger();
    }

    @Override
    public void clear() throws LogNotAvailableException {
        this.currentLedgerId = 0L;
        this.metadataManager.saveActualLedgersList(this.tableSpaceUUID, new LedgersInfo());
    }

    @Override
    public void dropOldLedgers(LogSequenceNumber lastCheckPointSequenceNumber) throws LogNotAvailableException {
        if (this.ledgersRetentionPeriod <= 0L) {
            return;
        }
        LOGGER.log(Level.INFO, "dropOldLedgers lastCheckPointSequenceNumber: {0}, ledgersRetentionPeriod: {1} ,lastLedgerId: {2}, currentLedgerId: {3}, tablespace {4}, actualLedgersList {5}", new Object[]{lastCheckPointSequenceNumber, this.ledgersRetentionPeriod, this.lastLedgerId, this.currentLedgerId, this.tableSpaceDescription(), this.actualLedgersList});
        long min_timestamp = System.currentTimeMillis() - this.ledgersRetentionPeriod;
        List<Long> oldLedgers = this.actualLedgersList.getOldLedgers(min_timestamp);
        LOGGER.log(Level.INFO, "dropOldLedgers currentLedgerId: {0}, lastLedgerId: {1}, dropping ledgers before {2}: {3} tablespace {4}", new Object[]{this.currentLedgerId, this.lastLedgerId, new Timestamp(min_timestamp), oldLedgers, this.tableSpaceDescription()});
        oldLedgers.remove(this.currentLedgerId);
        oldLedgers.remove(this.lastLedgerId);
        if (oldLedgers.isEmpty()) {
            LOGGER.log(Level.INFO, "dropOldLedgers no ledger to drop now, tablespace {0}", new Object[]{this.tableSpaceDescription()});
            return;
        }
        for (long ledgerId : oldLedgers) {
            try {
                LOGGER.log(Level.INFO, "dropping ledger {0}, tablespace {1}", new Object[]{ledgerId, this.tableSpaceDescription()});
                this.actualLedgersList.removeLedger(ledgerId);
                try {
                    this.bookKeeper.deleteLedger(ledgerId);
                }
                catch (BKException.BKNoSuchLedgerExistsException | BKException.BKNoSuchLedgerExistsOnMetadataServerException error) {
                    LOGGER.log(Level.SEVERE, "error while dropping ledger " + ledgerId + " for tablespace " + this.tableSpaceDescription(), error);
                }
                this.metadataManager.saveActualLedgersList(this.tableSpaceUUID, this.actualLedgersList);
                LOGGER.log(Level.INFO, "dropping ledger {0}, finished, tablespace {1}", new Object[]{ledgerId, this.tableSpaceDescription()});
            }
            catch (InterruptedException | BKException error) {
                LOGGER.log(Level.SEVERE, "error while dropping ledger " + ledgerId + " for tablespace " + this.tableSpaceDescription(), error);
                throw new LogNotAvailableException(error);
            }
        }
    }

    @Override
    public final void close() {
        this.parent.releaseLog(this.tableSpaceUUID);
        this.lock.writeLock().lock();
        try {
            if (this.closed) {
                return;
            }
            this.closeCurrentWriter(false);
            this.closed = true;
            LOGGER.severe("closed");
        }
        finally {
            this.writer = null;
            this.lock.writeLock().unlock();
        }
    }

    private void closeCurrentWriter(boolean waitForPendingAdds) throws LogNotAvailableException {
        if (this.writer != null) {
            try {
                if (waitForPendingAdds) {
                    this.writer.waitForAllPendingWrites();
                }
                this.writer.close();
            }
            catch (LogNotAvailableException err) {
                this.signalLogFailed();
                throw err;
            }
            finally {
                this.writer = null;
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isFailed() {
        return this.failed;
    }

    public CommitLog.FollowerContext startFollowing(LogSequenceNumber lastPosition) throws LogNotAvailableException {
        return new BKFollowerContext(lastPosition);
    }

    @Override
    public void followTheLeader(LogSequenceNumber lastPosition, CommitLog.EntryAcceptor consumer, CommitLog.FollowerContext context) throws LogNotAvailableException {
        block30: {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(this.tableSpaceDescription() + " followTheLeader lastPosition:" + lastPosition);
            }
            BKFollowerContext fContext = (BKFollowerContext)context;
            try {
                fContext.ensureOpenReader(lastPosition);
                if (fContext.currentLedger == null) {
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.finer(this.tableSpaceDescription() + " no more data to read for now");
                    }
                    return;
                }
                long nextEntry = fContext.nextEntryToRead;
                long lastAddConfirmed = fContext.currentLedger.getLastAddConfirmed();
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer(this.tableSpaceDescription() + " next entry to read " + nextEntry + " from ledger " + fContext.currentLedger.getId() + " lastAddConfiremd " + lastAddConfirmed);
                }
                if (lastAddConfirmed < nextEntry) {
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.finer(this.tableSpaceDescription() + " ledger not closed but there is nothing to read by now");
                    }
                    return;
                }
                ReadHandle lh = fContext.currentLedger;
                try (LastConfirmedAndEntry entryAndLac = lh.readLastAddConfirmedAndEntry(nextEntry, (long)LONG_POLL_TIMEOUT, false);){
                    if (!entryAndLac.hasEntry()) break block30;
                    LedgerEntry e = entryAndLac.getEntry();
                    boolean canContinue = this.acceptEntryForFollower(e, consumer);
                    if (!canContinue) {
                        LOGGER.log(Level.INFO, "exit follower {0}", this.tableSpaceDescription());
                        return;
                    }
                    long startEntry = nextEntry + 1L;
                    long endEntry = entryAndLac.getLastAddConfirmed();
                    if (startEntry > endEntry) {
                        return;
                    }
                    if (endEntry - startEntry > (long)MAX_ENTRY_TO_TAIL) {
                        endEntry = startEntry + (long)MAX_ENTRY_TO_TAIL;
                    }
                    try (LedgerEntries entries = lh.read(startEntry, endEntry);){
                        for (LedgerEntry ee : entries) {
                            this.acceptEntryForFollower(ee, consumer);
                        }
                    }
                }
            }
            catch (BKException.BKClientClosedException err) {
                LOGGER.log(Level.FINE, "stop following " + this.tableSpaceDescription(), err);
            }
            catch (org.apache.bookkeeper.client.api.BKException err) {
                LOGGER.log(Level.SEVERE, this.tableSpaceDescription() + " internal BK error", err);
                throw new LogNotAvailableException(err);
            }
            catch (InterruptedException err) {
                LOGGER.log(Level.SEVERE, this.tableSpaceDescription() + " interrupted", err);
                Thread.currentThread().interrupt();
                throw new LogNotAvailableException(err);
            }
            catch (LogNotAvailableException err) {
                LOGGER.log(Level.SEVERE, this.tableSpaceDescription() + " internal error", (Throwable)((Object)err));
                throw err;
            }
            catch (Exception err) {
                LOGGER.log(Level.SEVERE, this.tableSpaceDescription() + " internal error", err);
                throw new LogNotAvailableException(err);
            }
        }
    }

    private boolean acceptEntryForFollower(LedgerEntry e, CommitLog.EntryAcceptor consumer) throws Exception {
        long entryId = e.getEntryId();
        LogEntry statusEdit = this.readLogEntry(e);
        LogSequenceNumber number = new LogSequenceNumber(e.getLedgerId(), entryId);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "{0} follow entry {1}", new Object[]{this.tableSpaceDescription(), number});
        }
        if (this.lastLedgerId == number.ledgerId) {
            this.lastSequenceNumber.accumulateAndGet(number.offset, (LongBinaryOperator)EnsureLongIncrementAccumulator.INSTANCE);
        } else {
            this.lastSequenceNumber.set(number.offset);
        }
        this.lastLedgerId = number.ledgerId;
        this.currentLedgerId = number.ledgerId;
        return consumer.accept(number, statusEdit);
    }

    private LogEntry readLogEntry(LedgerEntry e) throws IOException {
        LogEntry statusEdit;
        try (ByteBufInputStream entryData = new ByteBufInputStream(e.getEntryBuffer(), false);
             ExtendedDataInputStream in = new ExtendedDataInputStream((InputStream)entryData);){
            statusEdit = LogEntry.deserialize(in);
        }
        return statusEdit;
    }

    @Override
    public LogSequenceNumber getLastSequenceNumber() {
        return new LogSequenceNumber(this.lastLedgerId, this.lastSequenceNumber.get());
    }

    public CommitFileWriter getWriter() {
        return this.writer;
    }

    public class CommitFileWriter {
        private final WriteHandle out;
        private final long ledgerId;
        private volatile boolean errorOccurredDuringWrite;
        private final AtomicLong pendingAdds = new AtomicLong();
        private final AtomicReference<Throwable> writeError = new AtomicReference();

        private CommitFileWriter() throws LogNotAvailableException {
            try {
                HashMap<String, byte[]> metadata = new HashMap<String, byte[]>();
                metadata.put("tablespaceuuid", BookkeeperCommitLog.this.tableSpaceUUID.getBytes(StandardCharsets.UTF_8));
                metadata.put("tablespacename", BookkeeperCommitLog.this.tableSpaceName.getBytes(StandardCharsets.UTF_8));
                metadata.put("leader", BookkeeperCommitLog.this.localNodeId.getBytes(StandardCharsets.UTF_8));
                metadata.put("application", BookkeeperCommitLog.SHARED_SECRET.getBytes(StandardCharsets.UTF_8));
                metadata.put("component", "commitlog".getBytes(StandardCharsets.UTF_8));
                this.out = (WriteHandle)FutureUtils.result((CompletableFuture)BookkeeperCommitLog.this.bookKeeper.newCreateLedgerOp().withEnsembleSize(BookkeeperCommitLog.this.ensemble).withWriteQuorumSize(BookkeeperCommitLog.this.writeQuorumSize).withAckQuorumSize(BookkeeperCommitLog.this.ackQuorumSize).withDigestType(DigestType.CRC32C).withPassword(BookkeeperCommitLog.SHARED_SECRET.getBytes(StandardCharsets.UTF_8)).withCustomMetadata(metadata).execute(), (Function)BKException.HANDLER);
                this.ledgerId = this.out.getId();
                LOGGER.log(Level.INFO, "{0} created ledger {1} (" + BookkeeperCommitLog.this.ensemble + "/" + BookkeeperCommitLog.this.writeQuorumSize + "/" + BookkeeperCommitLog.this.ackQuorumSize + ") bookies: {2}", new Object[]{BookkeeperCommitLog.this.tableSpaceDescription(), this.ledgerId, this.out.getLedgerMetadata().getAllEnsembles()});
                BookkeeperCommitLog.this.lastLedgerId = this.ledgerId;
                BookkeeperCommitLog.this.lastSequenceNumber.set(-1L);
            }
            catch (BKException err) {
                throw new LogNotAvailableException(err);
            }
        }

        public long getLedgerId() {
            return this.ledgerId;
        }

        public CompletableFuture<LogSequenceNumber> writeEntry(LogEntry edit) {
            ByteBuf serialize = edit.serializeAsByteBuf();
            this.pendingAdds.incrementAndGet();
            CompletionStage res = this.out.appendAsync(serialize).handle((offset, error) -> {
                if (error == null) {
                    this.pendingAdds.decrementAndGet();
                    if (edit.type != 13) {
                        BookkeeperCommitLog.this.lastApplicationWriteTs = System.currentTimeMillis();
                    }
                    return new LogSequenceNumber(this.ledgerId, (long)offset);
                }
                this.writeError.set((Throwable)error);
                this.pendingAdds.decrementAndGet();
                this.errorOccurredDuringWrite = true;
                BookkeeperCommitLog.this.handleBookKeeperFailure(error, edit);
                throw new LogNotAvailableException((Throwable)error);
            });
            return res;
        }

        public void waitForAllPendingWrites() throws LogNotAvailableException {
            try {
                while (this.pendingAdds.get() > 0L) {
                    LOGGER.log(Level.INFO, "{0} Waiting for {1} writes to complete on ledger {2}", new Object[]{BookkeeperCommitLog.this.tableSpaceDescription(), this.pendingAdds.get(), this.ledgerId});
                    Throwable gotWriterError = this.writeError.get();
                    if (gotWriterError != null) {
                        throw new LogNotAvailableException(gotWriterError);
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (LogNotAvailableException err) {
                throw err;
            }
            catch (InterruptedException err) {
                Thread.currentThread().interrupt();
                throw new LogNotAvailableException(err);
            }
        }

        public void close() throws LogNotAvailableException {
            try {
                LOGGER.log(Level.INFO, "{0} closing ledger {1}, with LastAddConfirmed={2}, LastAddPushed={3} length={4}, errorOccurred:{5}", new Object[]{BookkeeperCommitLog.this.tableSpaceDescription(), this.out.getId(), this.out.getLastAddConfirmed(), this.out.getLastAddPushed(), this.out.getLength(), this.errorOccurredDuringWrite});
                this.out.close();
            }
            catch (InterruptedException | org.apache.bookkeeper.client.api.BKException err) {
                throw new LogNotAvailableException(err);
            }
        }

        public WriteHandle getOut() {
            return this.out;
        }

        private void writeLedgerHeader() throws LogNotAvailableException {
            if (!BookkeeperCommitLog.this.writeLedgerHeader) {
                return;
            }
            try {
                LogSequenceNumber lsn = this.writeEntry(LogEntryFactory.noop()).get();
                LOGGER.log(Level.INFO, "{0} ledger header written at {1}", new Object[]{BookkeeperCommitLog.this.tableSpaceDescription(), lsn});
            }
            catch (LogNotAvailableException t) {
                LOGGER.log(Level.SEVERE, "error", (Throwable)((Object)t));
                throw t;
            }
            catch (Exception t) {
                LOGGER.log(Level.SEVERE, "error", t);
                throw new LogNotAvailableException(t);
            }
        }

        private void writeNoop() {
            try {
                this.writeEntry(LogEntryFactory.noop());
            }
            catch (LogNotAvailableException t) {
                LOGGER.log(Level.SEVERE, "error", (Throwable)((Object)t));
            }
        }

        private boolean isWritable() {
            return !this.errorOccurredDuringWrite && !this.out.isClosed() && BookkeeperCommitLog.this.maxLedgerSizeBytes >= this.out.getLength();
        }

        public String toString() {
            return "CommitFileWriter{ledgerId=" + this.ledgerId + ", size=" + this.out.getLength() + ", errorOccurredDuringWrite=" + this.errorOccurredDuringWrite + ", pendingAdds=" + this.pendingAdds + '}';
        }
    }

    private final class BKFollowerContext
    implements CommitLog.FollowerContext {
        volatile ReadHandle currentLedger;
        volatile long nextEntryToRead;
        volatile long ledgerToTail;

        BKFollowerContext(LogSequenceNumber lastPosition) {
            this.ledgerToTail = lastPosition.ledgerId;
            this.nextEntryToRead = lastPosition.offset + 1L;
            LOGGER.log(Level.INFO, "{0} start following, first position is {1}", new Object[]{BookkeeperCommitLog.this.tableSpaceDescription(), lastPosition});
        }

        void ensureOpenReader(LogSequenceNumber currentPosition) throws org.apache.bookkeeper.client.api.BKException, InterruptedException, LogNotAvailableException {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(BookkeeperCommitLog.this.tableSpaceDescription() + " seekToNextLedger currentPosition=" + currentPosition + " ledgerToTail " + this.ledgerToTail);
            }
            if (this.currentLedger != null && this.currentLedger.getId() == this.ledgerToTail) {
                this.nextEntryToRead = currentPosition.ledgerId == this.ledgerToTail ? currentPosition.offset + 1L : 0L;
                if (this.currentLedger.getLastAddConfirmed() < this.nextEntryToRead) {
                    this.currentLedger.tryReadLastAddConfirmed();
                }
                if (this.currentLedger.isClosed() && this.currentLedger.getLastAddConfirmed() == this.nextEntryToRead - 1L) {
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.finer(BookkeeperCommitLog.this.tableSpaceDescription() + " ledger " + this.currentLedger.getId() + " is closed and we have fully read it");
                    }
                } else {
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.finer(BookkeeperCommitLog.this.tableSpaceDescription() + " seekToNextLedger keep current handle " + this.currentLedger.getId() + " nextEntry " + this.nextEntryToRead);
                    }
                    return;
                }
            }
            List<Long> actualList = BookkeeperCommitLog.this.metadataManager.getActualLedgersList(BookkeeperCommitLog.this.tableSpaceUUID).getActiveLedgers();
            Collections.sort(actualList);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(BookkeeperCommitLog.this.tableSpaceDescription() + " ledgers list " + actualList);
            }
            if (actualList.isEmpty()) {
                LOGGER.severe(BookkeeperCommitLog.this.tableSpaceDescription() + " no ledger in list?");
                return;
            }
            if (this.ledgerToTail == -1L) {
                this.ledgerToTail = actualList.get(0);
            }
            if (!actualList.contains(this.ledgerToTail)) {
                throw new LogNotAvailableException(BookkeeperCommitLog.this.tableSpaceDescription() + " First Ledger to open " + this.ledgerToTail + ", is not in the activer ledgers list " + actualList);
            }
            if (this.currentLedger == null) {
                this.currentLedger = BookkeeperCommitLog.this.bookKeeper.openLedgerNoRecovery(this.ledgerToTail, BookKeeper.DigestType.CRC32C, BookkeeperCommitLog.SHARED_SECRET.getBytes(StandardCharsets.UTF_8));
                String ledgerLeader = BookkeeperCommitLog.extractLeaderFromMetadata(this.currentLedger.getLedgerMetadata().getCustomMetadata());
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.log(Level.FINER, "{0} opened direct ledger {1} was created by {2}", new Object[]{BookkeeperCommitLog.this.tableSpaceDescription(), this.ledgerToTail, ledgerLeader});
                }
                this.nextEntryToRead = currentPosition.offset + 1L;
                return;
            }
            long nextLedger = -1L;
            for (long lId : actualList) {
                if (lId <= this.ledgerToTail) continue;
                this.ledgerToTail = lId;
                break;
            }
            if (nextLedger == -1L) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer(BookkeeperCommitLog.this.tableSpaceDescription() + " no more ledgers after " + this.ledgerToTail);
                }
                this.currentLedger = null;
                return;
            }
            this.ledgerToTail = nextLedger;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(BookkeeperCommitLog.this.tableSpaceDescription() + " start tailing " + this.ledgerToTail);
            }
            if (this.currentLedger != null) {
                this.currentLedger.close();
            }
            this.currentLedger = BookkeeperCommitLog.this.bookKeeper.openLedgerNoRecovery(this.ledgerToTail, BookKeeper.DigestType.CRC32C, BookkeeperCommitLog.SHARED_SECRET.getBytes(StandardCharsets.UTF_8));
            String ledgerLeader = BookkeeperCommitLog.extractLeaderFromMetadata(this.currentLedger.getLedgerMetadata().getCustomMetadata());
            LOGGER.log(Level.INFO, "{0} ledger {1} was created by {2}", new Object[]{BookkeeperCommitLog.this.tableSpaceDescription(), this.ledgerToTail, ledgerLeader});
            this.nextEntryToRead = 0L;
        }

        @Override
        public void close() {
            if (this.currentLedger != null) {
                try {
                    this.currentLedger.close();
                }
                catch (org.apache.bookkeeper.client.api.BKException ex) {
                    LOGGER.log(Level.FINE, null, ex);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    this.currentLedger = null;
                }
            }
        }
    }
}

