/*
 * Decompiled with CFR 0.152.
 */
package herddb.client;

import herddb.client.ClientSideMetadataProvider;
import herddb.client.ClientSideMetadataProviderException;
import herddb.model.NodeMetadata;
import herddb.model.TableSpace;
import herddb.network.ServerHostData;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class ZookeeperClientSideMetadataProvider
implements ClientSideMetadataProvider {
    private static final Logger LOG = Logger.getLogger(ZookeeperClientSideMetadataProvider.class.getName());
    private final String basePath;
    private final Supplier<ZooKeeper> zookeeperSupplier;
    private boolean ownZooKeeper;
    private static final int MAX_TRIALS = 20;
    private final Map<String, String> tableSpaceLeaders = new ConcurrentHashMap<String, String>();
    private final Map<String, ServerHostData> servers = new ConcurrentHashMap<String, ServerHostData>();

    public ZookeeperClientSideMetadataProvider(String basePath, Supplier<ZooKeeper> zookeeper) {
        this.basePath = basePath;
        this.zookeeperSupplier = zookeeper;
        this.ownZooKeeper = false;
    }

    public ZookeeperClientSideMetadataProvider(String zkAddress, int zkSessionTimeout, String basePath) {
        this(basePath, () -> {
            try {
                final CountDownLatch waitForConnection = new CountDownLatch(1);
                ZooKeeper zk = new ZooKeeper(zkAddress, zkSessionTimeout, new Watcher(){

                    public void process(WatchedEvent event) {
                        switch (event.getState()) {
                            case SyncConnected: 
                            case SaslAuthenticated: 
                            case ConnectedReadOnly: {
                                LOG.log(Level.FINE, "zk client event {0}", event);
                                waitForConnection.countDown();
                                break;
                            }
                            default: {
                                LOG.log(Level.INFO, "zk client event {0}", event);
                            }
                        }
                    }
                });
                boolean waitResult = waitForConnection.await((long)zkSessionTimeout * 2L, TimeUnit.MILLISECONDS);
                if (!waitResult) {
                    LOG.log(Level.SEVERE, "ZK session to ZK did not establish within " + (long)zkSessionTimeout * 2L + " ms");
                }
                return zk;
            }
            catch (IOException err) {
                LOG.log(Level.SEVERE, "zk client error " + err, err);
                return null;
            }
            catch (InterruptedException err) {
                LOG.log(Level.SEVERE, "zk client error " + err, err);
                Thread.currentThread().interrupt();
                return null;
            }
        });
        this.ownZooKeeper = true;
    }

    @Override
    public void requestMetadataRefresh(Exception error) {
        this.tableSpaceLeaders.clear();
        this.servers.clear();
    }

    /*
     * Exception decompiling
     */
    @Override
    public String getTableSpaceLeader(String tableSpace) throws ClientSideMetadataProviderException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [17[CATCHBLOCK]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String readAsTableSpace(ZooKeeper zooKeeper, String tableSpace) throws IOException, InterruptedException, KeeperException {
        tableSpace = tableSpace.toLowerCase();
        Stat stat = new Stat();
        byte[] result = zooKeeper.getData(this.basePath + "/tableSpaces/" + tableSpace, false, stat);
        String leader = TableSpace.deserialize((byte[])result, (Object)Integer.valueOf((int)stat.getVersion()), (long)stat.getCtime()).leaderId;
        this.tableSpaceLeaders.put(tableSpace, leader);
        return leader;
    }

    private String readAsNode(ZooKeeper zooKeeper, String tableSpace) throws IOException, InterruptedException, KeeperException {
        tableSpace = tableSpace.toLowerCase();
        Stat stat = new Stat();
        byte[] result = zooKeeper.getData(this.basePath + "/nodes/" + tableSpace, false, stat);
        NodeMetadata md = NodeMetadata.deserialize(result, (Object)stat.getVersion());
        String leader = md.nodeId;
        this.tableSpaceLeaders.put(tableSpace, leader);
        return leader;
    }

    /*
     * Exception decompiling
     */
    @Override
    public ServerHostData getServerHostData(String nodeId) throws ClientSideMetadataProviderException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index -2 out of bounds for length 61
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.PushThroughGoto.pushThroughGoto(PushThroughGoto.java:67)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.PushThroughGoto.pushThroughGoto(PushThroughGoto.java:43)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.pushThroughGoto(Op03Rewriters.java:177)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:686)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ZooKeeper getZooKeeper() throws ClientSideMetadataProviderException {
        ZooKeeper zooKeeper = this.zookeeperSupplier.get();
        if (zooKeeper == null) {
            throw new ClientSideMetadataProviderException(new Exception("ZooKeeper client is not available"));
        }
        return zooKeeper;
    }
}

