/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.ArrayList;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.util.Static;

public class SqlWindowTableFunction
extends SqlFunction {
    public static final SqlReturnTypeInference ARG0_TABLE_FUNCTION_WINDOWING = opBinding -> {
        RelDataType inputRowType = opBinding.getOperandType(0);
        ArrayList<RelDataTypeField> newFields = new ArrayList<RelDataTypeField>(inputRowType.getFieldList());
        RelDataType timestampType = opBinding.getTypeFactory().createSqlType(SqlTypeName.TIMESTAMP);
        RelDataTypeFieldImpl windowStartField = new RelDataTypeFieldImpl("window_start", newFields.size(), timestampType);
        newFields.add(windowStartField);
        RelDataTypeFieldImpl windowEndField = new RelDataTypeFieldImpl("window_end", newFields.size(), timestampType);
        newFields.add(windowEndField);
        return new RelRecordType(inputRowType.getStructKind(), newFields);
    };

    public SqlWindowTableFunction(String name) {
        super(name, SqlKind.OTHER_FUNCTION, ARG0_TABLE_FUNCTION_WINDOWING, null, null, SqlFunctionCategory.SYSTEM);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(3);
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        SqlNode operand0 = callBinding.operand(0);
        SqlValidator validator = callBinding.getValidator();
        RelDataType type = validator.getValidatedNodeType(operand0);
        if (type.getSqlTypeName() != SqlTypeName.ROW) {
            return this.throwValidationSignatureErrorOrReturnFalse(callBinding, throwOnFailure);
        }
        SqlNode operand1 = callBinding.operand(1);
        if (operand1.getKind() != SqlKind.DESCRIPTOR) {
            return this.throwValidationSignatureErrorOrReturnFalse(callBinding, throwOnFailure);
        }
        for (SqlNode descOperand : ((SqlCall)operand1).getOperandList()) {
            String colName = ((SqlIdentifier)descOperand).getSimple();
            boolean matches = false;
            for (String field : type.getFieldNames()) {
                if (!validator.getCatalogReader().nameMatcher().matches(field, colName)) continue;
                matches = true;
                break;
            }
            if (matches) continue;
            throw SqlUtil.newContextException(descOperand.getParserPosition(), Static.RESOURCE.unknownIdentifier(colName));
        }
        RelDataType type2 = validator.getValidatedNodeType(callBinding.operand(2));
        if (!SqlTypeUtil.isInterval(type2)) {
            return this.throwValidationSignatureErrorOrReturnFalse(callBinding, throwOnFailure);
        }
        return true;
    }

    private boolean throwValidationSignatureErrorOrReturnFalse(SqlCallBinding callBinding, boolean throwOnFailure) {
        if (throwOnFailure) {
            throw callBinding.newValidationSignatureError();
        }
        return false;
    }

    @Override
    public String getAllowedSignatures(String opNameToUse) {
        return this.getName() + "(TABLE table_name, DESCRIPTOR(col1, col2 ...), datetime interval)";
    }

    @Override
    public boolean argumentMustBeScalar(int ordinal) {
        return ordinal != 0;
    }
}

