/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.core;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.Optionality;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.Mappings;

public class AggregateCall {
    private final SqlAggFunction aggFunction;
    private final boolean distinct;
    private final boolean approximate;
    private final boolean ignoreNulls;
    public final RelDataType type;
    public final String name;
    private final ImmutableList<Integer> argList;
    public final int filterArg;
    public final RelCollation collation;

    @Deprecated
    public AggregateCall(SqlAggFunction aggFunction, boolean distinct, List<Integer> argList, RelDataType type, String name) {
        this(aggFunction, distinct, false, false, argList, -1, RelCollations.EMPTY, type, name);
    }

    private AggregateCall(SqlAggFunction aggFunction, boolean distinct, boolean approximate, boolean ignoreNulls, List<Integer> argList, int filterArg, RelCollation collation, RelDataType type, String name) {
        this.type = Objects.requireNonNull(type);
        this.name = name;
        this.aggFunction = Objects.requireNonNull(aggFunction);
        this.argList = ImmutableList.copyOf(argList);
        this.filterArg = filterArg;
        this.collation = Objects.requireNonNull(collation);
        this.distinct = distinct;
        this.approximate = approximate;
        this.ignoreNulls = ignoreNulls;
        Preconditions.checkArgument((aggFunction.getDistinctOptionality() != Optionality.IGNORED || !distinct ? 1 : 0) != 0, (Object)"DISTINCT has no effect for this aggregate function, so must be false");
        Preconditions.checkArgument((filterArg < 0 || aggFunction.allowsFilter() ? 1 : 0) != 0);
    }

    @Deprecated
    public static AggregateCall create(SqlAggFunction aggFunction, boolean distinct, List<Integer> argList, int groupCount, RelNode input, RelDataType type, String name) {
        return AggregateCall.create(aggFunction, distinct, false, false, argList, -1, RelCollations.EMPTY, groupCount, input, type, name);
    }

    @Deprecated
    public static AggregateCall create(SqlAggFunction aggFunction, boolean distinct, List<Integer> argList, int filterArg, int groupCount, RelNode input, RelDataType type, String name) {
        return AggregateCall.create(aggFunction, distinct, false, false, argList, filterArg, RelCollations.EMPTY, groupCount, input, type, name);
    }

    @Deprecated
    public static AggregateCall create(SqlAggFunction aggFunction, boolean distinct, boolean approximate, List<Integer> argList, int filterArg, int groupCount, RelNode input, RelDataType type, String name) {
        return AggregateCall.create(aggFunction, distinct, approximate, false, argList, filterArg, RelCollations.EMPTY, groupCount, input, type, name);
    }

    @Deprecated
    public static AggregateCall create(SqlAggFunction aggFunction, boolean distinct, boolean approximate, List<Integer> argList, int filterArg, RelCollation collation, int groupCount, RelNode input, RelDataType type, String name) {
        return AggregateCall.create(aggFunction, distinct, approximate, false, argList, filterArg, collation, groupCount, input, type, name);
    }

    public static AggregateCall create(SqlAggFunction aggFunction, boolean distinct, boolean approximate, boolean ignoreNulls, List<Integer> argList, int filterArg, RelCollation collation, int groupCount, RelNode input, RelDataType type, String name) {
        if (type == null) {
            RelDataTypeFactory typeFactory = input.getCluster().getTypeFactory();
            List<RelDataType> types = SqlTypeUtil.projectTypes(input.getRowType(), argList);
            Aggregate.AggCallBinding callBinding = new Aggregate.AggCallBinding(typeFactory, aggFunction, types, groupCount, filterArg >= 0);
            type = aggFunction.inferReturnType(callBinding);
        }
        return AggregateCall.create(aggFunction, distinct, approximate, ignoreNulls, argList, filterArg, collation, type, name);
    }

    @Deprecated
    public static AggregateCall create(SqlAggFunction aggFunction, boolean distinct, List<Integer> argList, int filterArg, RelDataType type, String name) {
        return AggregateCall.create(aggFunction, distinct, false, false, argList, filterArg, RelCollations.EMPTY, type, name);
    }

    @Deprecated
    public static AggregateCall create(SqlAggFunction aggFunction, boolean distinct, boolean approximate, List<Integer> argList, int filterArg, RelDataType type, String name) {
        return AggregateCall.create(aggFunction, distinct, approximate, false, argList, filterArg, RelCollations.EMPTY, type, name);
    }

    @Deprecated
    public static AggregateCall create(SqlAggFunction aggFunction, boolean distinct, boolean approximate, List<Integer> argList, int filterArg, RelCollation collation, RelDataType type, String name) {
        return AggregateCall.create(aggFunction, distinct, approximate, false, argList, filterArg, collation, type, name);
    }

    public static AggregateCall create(SqlAggFunction aggFunction, boolean distinct, boolean approximate, boolean ignoreNulls, List<Integer> argList, int filterArg, RelCollation collation, RelDataType type, String name) {
        boolean distinct2 = distinct && aggFunction.getDistinctOptionality() != Optionality.IGNORED;
        return new AggregateCall(aggFunction, distinct2, approximate, ignoreNulls, argList, filterArg, collation, type, name);
    }

    public final boolean isDistinct() {
        return this.distinct;
    }

    public final boolean isApproximate() {
        return this.approximate;
    }

    public final boolean ignoreNulls() {
        return this.ignoreNulls;
    }

    public final SqlAggFunction getAggregation() {
        return this.aggFunction;
    }

    public RelCollation getCollation() {
        return this.collation;
    }

    public final List<Integer> getArgList() {
        return this.argList;
    }

    public final RelDataType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public AggregateCall rename(String name) {
        if (Objects.equals(this.name, name)) {
            return this;
        }
        return new AggregateCall(this.aggFunction, this.distinct, this.approximate, this.ignoreNulls, (List<Integer>)this.argList, this.filterArg, RelCollations.EMPTY, this.type, name);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.aggFunction.toString());
        buf.append("(");
        if (this.approximate) {
            buf.append("APPROXIMATE ");
        }
        if (this.distinct) {
            buf.append(this.argList.size() == 0 ? "DISTINCT" : "DISTINCT ");
        }
        int i = -1;
        for (Integer arg : this.argList) {
            if (++i > 0) {
                buf.append(", ");
            }
            buf.append("$");
            buf.append(arg);
        }
        buf.append(")");
        if (!this.collation.equals(RelCollations.EMPTY)) {
            buf.append(" WITHIN GROUP (");
            buf.append(this.collation);
            buf.append(")");
        }
        if (this.hasFilter()) {
            buf.append(" FILTER $");
            buf.append(this.filterArg);
        }
        return buf.toString();
    }

    public boolean hasFilter() {
        return this.filterArg >= 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AggregateCall)) {
            return false;
        }
        AggregateCall other = (AggregateCall)o;
        return this.aggFunction.equals(other.aggFunction) && this.distinct == other.distinct && this.approximate == other.approximate && this.ignoreNulls == other.ignoreNulls && this.argList.equals(other.argList) && this.filterArg == other.filterArg && Objects.equals(this.collation, other.collation);
    }

    public int hashCode() {
        return Objects.hash(this.aggFunction, this.distinct, this.approximate, this.ignoreNulls, this.argList, this.filterArg, this.collation);
    }

    public Aggregate.AggCallBinding createBinding(Aggregate aggregateRelBase) {
        RelDataType rowType = aggregateRelBase.getInput().getRowType();
        return new Aggregate.AggCallBinding(aggregateRelBase.getCluster().getTypeFactory(), this.aggFunction, SqlTypeUtil.projectTypes(rowType, this.argList), aggregateRelBase.getGroupCount(), this.hasFilter());
    }

    public AggregateCall copy(List<Integer> args, int filterArg, RelCollation collation) {
        return new AggregateCall(this.aggFunction, this.distinct, this.approximate, this.ignoreNulls, args, filterArg, collation, this.type, this.name);
    }

    @Deprecated
    public AggregateCall copy(List<Integer> args, int filterArg) {
        return this.copy(args, filterArg, this.collation);
    }

    @Deprecated
    public AggregateCall copy(List<Integer> args) {
        return this.copy(args, this.filterArg, this.collation);
    }

    public AggregateCall adaptTo(RelNode input, List<Integer> argList, int filterArg, int oldGroupKeyCount, int newGroupKeyCount) {
        RelDataType newType = oldGroupKeyCount == newGroupKeyCount && argList.equals(this.argList) && filterArg == this.filterArg ? this.type : null;
        return AggregateCall.create(this.aggFunction, this.distinct, this.approximate, this.ignoreNulls, argList, filterArg, this.collation, newGroupKeyCount, input, newType, this.getName());
    }

    public AggregateCall transform(Mappings.TargetMapping mapping) {
        return this.copy(Mappings.apply2((Mapping)mapping, this.argList), this.hasFilter() ? Mappings.apply(mapping, this.filterArg) : -1, RelCollations.permute(this.collation, mapping));
    }
}

