/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.jdbc;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.adapter.jdbc.JdbcConvention;
import org.apache.calcite.adapter.jdbc.JdbcImplementor;
import org.apache.calcite.adapter.jdbc.JdbcRel;
import org.apache.calcite.adapter.jdbc.JdbcTable;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.rel2sql.SqlImplementor;

public class JdbcTableScan
extends TableScan
implements JdbcRel {
    public final JdbcTable jdbcTable;

    protected JdbcTableScan(RelOptCluster cluster, RelOptTable table, JdbcTable jdbcTable, JdbcConvention jdbcConvention) {
        super(cluster, cluster.traitSetOf((RelTrait)jdbcConvention), (List<RelHint>)ImmutableList.of(), table);
        this.jdbcTable = Objects.requireNonNull(jdbcTable);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (inputs.isEmpty());
        return new JdbcTableScan(this.getCluster(), this.table, this.jdbcTable, (JdbcConvention)this.getConvention());
    }

    @Override
    public SqlImplementor.Result implement(JdbcImplementor implementor) {
        return implementor.result(this.jdbcTable.tableName(), (Collection<SqlImplementor.Clause>)ImmutableList.of((Object)((Object)SqlImplementor.Clause.FROM)), this, null);
    }
}

