/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import org.apache.bookkeeper.client.LedgerMetadataImpl;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedgerMetadataUtils {
    static final Logger LOG = LoggerFactory.getLogger(LedgerMetadataUtils.class);

    static List<BookieSocketAddress> getCurrentEnsemble(LedgerMetadata metadata) {
        return LedgerMetadataUtils.getLastEnsembleValue(metadata);
    }

    static long getNextEnsembleChange(LedgerMetadata metadata, long entryId) {
        SortedMap<Long, ? extends List<BookieSocketAddress>> tailMap = metadata.getAllEnsembles().tailMap(entryId + 1L);
        if (tailMap.isEmpty()) {
            return -1L;
        }
        return tailMap.firstKey();
    }

    static Set<BookieSocketAddress> getBookiesInThisLedger(LedgerMetadata metadata) {
        HashSet<BookieSocketAddress> bookies = new HashSet<BookieSocketAddress>();
        for (List ensemble : metadata.getAllEnsembles().values()) {
            bookies.addAll(ensemble);
        }
        return bookies;
    }

    static List<BookieSocketAddress> getLastEnsembleValue(LedgerMetadata metadata) {
        Preconditions.checkArgument((!metadata.getAllEnsembles().isEmpty() ? 1 : 0) != 0, (Object)"Metadata should never be created with no ensembles");
        return metadata.getAllEnsembles().lastEntry().getValue();
    }

    static Long getLastEnsembleKey(LedgerMetadata metadata) {
        Preconditions.checkArgument((!metadata.getAllEnsembles().isEmpty() ? 1 : 0) != 0, (Object)"Metadata should never be created with no ensembles");
        return (Long)metadata.getAllEnsembles().lastKey();
    }

    public static boolean shouldStoreCtime(LedgerMetadata metadata) {
        return metadata instanceof LedgerMetadataImpl && ((LedgerMetadataImpl)metadata).shouldStoreCtime();
    }
}

