/*
 * Decompiled with CFR 0.152.
 */
package herddb.network.netty;

import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;

public class LocalServerRegistry {
    private static final Set<String> localServers = new ConcurrentSkipListSet<String>();

    static void registerLocalServer(String host, int port, boolean ssl) {
        localServers.add(LocalServerRegistry.composeServerKey(host, port, ssl));
    }

    private static String composeServerKey(String host, int port, boolean ssl) {
        return host + ":" + port + ":" + ssl;
    }

    static void unregisterLocalServer(String host, int port, boolean ssl) {
        localServers.remove(LocalServerRegistry.composeServerKey(host, port, ssl));
    }

    static boolean isLocalServer(String host, int port, boolean ssl) {
        return localServers.contains(LocalServerRegistry.composeServerKey(host, port, ssl));
    }
}

