/*
 * Decompiled with CFR 0.152.
 */
package herddb.network;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;

public class ServerHostData {
    private final int port;
    private final String host;
    private final String version;
    private final boolean ssl;
    private final Map<String, String> additionalData;

    public ServerHostData(String host, int port, String version, boolean ssl, Map<String, String> additionalData) {
        this.port = port;
        this.host = host;
        this.version = version;
        this.ssl = ssl;
        this.additionalData = additionalData;
    }

    public String toString() {
        return "ServerHostData{port=" + this.port + ", host=" + this.host + ", version=" + this.version + ", ssl=" + this.ssl + ", additionalData=" + this.additionalData + '}';
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    public static byte[] formatHostdata(ServerHostData data) {
        try {
            HashMap<String, String> mdata = new HashMap<String, String>();
            mdata.put("host", data.host);
            mdata.put("port", data.port + "");
            mdata.put("version", data.version);
            mdata.put("ssl", data.ssl + "");
            if (data.additionalData != null) {
                mdata.putAll(data.additionalData);
            }
            ByteArrayOutputStream oo = new ByteArrayOutputStream();
            new ObjectMapper().writeValue((OutputStream)oo, mdata);
            return oo.toByteArray();
        }
        catch (IOException impossible) {
            throw new RuntimeException(impossible);
        }
    }

    public InetSocketAddress getSocketAddress() {
        return new InetSocketAddress(this.host, this.port);
    }

    public static ServerHostData parseHostdata(byte[] oo) {
        try {
            Map data = (Map)new ObjectMapper().readValue((InputStream)new ByteArrayInputStream(oo), Map.class);
            String host = (String)data.get("host");
            String version = (String)data.get("version");
            int port = Integer.parseInt(data.get("port") + "");
            boolean ssl = "true".equals(data.get("ssl"));
            HashMap<String, String> additional = new HashMap<String, String>();
            data.forEach((k, v) -> {
                if (v != null) {
                    additional.put((String)k, v.toString());
                }
            });
            return new ServerHostData(host, port, version, ssl, additional);
        }
        catch (IOException impossible) {
            throw new RuntimeException(impossible);
        }
    }
}

