/*
 * Decompiled with CFR 0.152.
 */
package herddb.utils;

import java.security.AccessController;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SystemProperties {
    private static final Logger LOGGER = Logger.getLogger(SystemProperties.class.getName());

    public static String getStringSystemProperty(String name, String defaultvalue) {
        return SystemProperties.getProperty(name, defaultvalue);
    }

    public static int getIntSystemProperty(String name, int defaultvalue) {
        return SystemProperties.getIntSystemProperty(name, defaultvalue, "");
    }

    public static int getIntSystemProperty(String name, int defaultvalue, String description) {
        String value = SystemProperties.getProperty(name, defaultvalue + "");
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException err) {
            RuntimeException rerr = new RuntimeException("Error reading system property " + name + " =" + value, err);
            throw rerr;
        }
    }

    public static long getLongSystemProperty(String name, long defaultvalue) {
        String value = SystemProperties.getProperty(name, defaultvalue + "");
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException err) {
            RuntimeException rerr = new RuntimeException("Error reading system property " + name + " =" + value, err);
            throw rerr;
        }
    }

    public static boolean getBooleanSystemProperty(String name, boolean defaultvalue) {
        String value = SystemProperties.getProperty(name, defaultvalue + "");
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        RuntimeException rerr = new RuntimeException("Error reading system property " + name + " =" + value + " allowed only true|false");
        throw rerr;
    }

    private static String getProperty(String name, String defaultvalue) {
        String res = AccessController.doPrivileged(() -> System.getProperty(name, defaultvalue));
        LOGGER.log(Level.CONFIG, "read system property: {0}={1}", new Object[]{name, res});
        return res;
    }
}

