/*
 * Decompiled with CFR 0.152.
 */
package herddb.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ListWithMap<E> {
    private Node<E> head = null;
    private Node<E> tail = null;
    private Map<E, Node<E>> space = new HashMap<E, Node<E>>();

    public void append(E e) {
        Node<E> ref = this.tail;
        Node<E> node = new Node<E>(ref, e, null);
        this.tail = node;
        if (ref == null) {
            this.head = node;
        } else {
            ref.next = node;
        }
        this.space.put(e, node);
    }

    public int size() {
        return this.space.size();
    }

    public boolean isEmpty() {
        return this.space.isEmpty();
    }

    public E peek() {
        Node<E> ref = this.head;
        return ref == null ? null : (E)ref.item;
    }

    public E poll() {
        Node<E> ref = this.head;
        if (ref == null) {
            return null;
        }
        Object result = ref.item;
        Node next = ref.next;
        ref.item = null;
        ref.prev = null;
        ref.next = null;
        this.head = next;
        if (next == null) {
            this.tail = null;
        } else {
            next.prev = null;
        }
        this.space.remove(result);
        return result;
    }

    public boolean contains(E e) {
        return this.space.containsKey(e);
    }

    public E remove(E e) {
        Node<E> ref = this.space.remove(e);
        if (ref == null) {
            return null;
        }
        if (ref.prev == null) {
            this.head = ref.next;
        } else {
            ref.prev.next = ref.next;
        }
        if (ref.next == null) {
            this.tail = ref.prev;
        } else {
            ref.next.prev = ref.prev;
        }
        Object rem = ref.item;
        ref.item = null;
        ref.prev = null;
        ref.next = null;
        return rem;
    }

    public void clear() {
        Node<E> ref = this.head;
        while (ref != null) {
            Node next = ref.next;
            ref.item = null;
            ref.prev = null;
            ref.next = null;
            ref = next;
        }
        this.space.clear();
    }

    public List<E> toList() {
        ArrayList list = new ArrayList(this.space.size());
        Node<E> ref = this.head;
        while (ref != null) {
            list.add(ref.item);
            ref = ref.next;
        }
        return list;
    }

    private static class Node<E> {
        E item;
        Node<E> prev;
        Node<E> next;

        Node(Node<E> prev, E element, Node<E> next) {
            this.item = element;
            this.prev = prev;
            this.next = next;
        }
    }
}

