/*
 * Decompiled with CFR 0.152.
 */
package herddb.utils;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import herddb.utils.ByteArrayCursor;
import herddb.utils.CompareBytesUtils;
import herddb.utils.RawString;
import herddb.utils.SizeAwareObject;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;

@SuppressFBWarnings(value={"EI_EXPOSE_REP2", "EI_EXPOSE_REP", "UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"})
public final class Bytes
implements Comparable<Bytes>,
SizeAwareObject {
    public static final Bytes POSITIVE_INFINITY = new Bytes(new byte[0]);
    public static final Bytes EMPTY_ARRAY = new Bytes(new byte[0]);
    private static final boolean UNALIGNED = PlatformDependent.isUnaligned();
    private static final boolean HAS_UNSAFE = PlatformDependent.hasUnsafe();
    private static final boolean BIG_ENDIAN_NATIVE_ORDER = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
    private static final int CONSTANT_BYTE_SIZE = 24;
    private final byte[] buffer;
    private final int offset;
    private final int length;
    private int hashCode = -1;
    public Object deserialized;
    private static final byte[] BOOLEAN_TRUE = new byte[]{1};
    private static final byte[] BOOLEAN_FALSE = new byte[]{0};

    public static long estimateSize(byte[] value) {
        return value.length + 24;
    }

    @Override
    public long getEstimatedSize() {
        return this.length + 24;
    }

    public static byte[] string_to_array(String s) {
        return s.getBytes(StandardCharsets.UTF_8);
    }

    public static Bytes from_string(String s) {
        return new Bytes(s.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] longToByteArray(long value) {
        byte[] res = new byte[8];
        Bytes.putLong(res, 0, value);
        return res;
    }

    public static byte[] intToByteArray(int value) {
        byte[] res = new byte[4];
        Bytes.putInt(res, 0, value);
        return res;
    }

    public static byte[] doubleToByteArray(double value) {
        byte[] res = new byte[8];
        Bytes.putLong(res, 0, Double.doubleToLongBits(value));
        return res;
    }

    public static byte[] timestampToByteArray(Timestamp value) {
        byte[] res = new byte[8];
        Bytes.putLong(res, 0, value.getTime());
        return res;
    }

    @SuppressFBWarnings(value={"MS_EXPOSE_REP"})
    public static byte[] booleanToByteArray(boolean value) {
        return value ? BOOLEAN_TRUE : BOOLEAN_FALSE;
    }

    public static Bytes from_long(long value) {
        byte[] res = new byte[8];
        Bytes.putLong(res, 0, value);
        return new Bytes(res);
    }

    public static Bytes from_array(byte[] data) {
        return new Bytes(data);
    }

    public static Bytes from_array(byte[] data, int offset, int len) {
        return new Bytes(data, offset, len);
    }

    public static Bytes from_nullable_array(byte[] data) {
        if (data == null) {
            return null;
        }
        return new Bytes(data);
    }

    public byte[] to_array() {
        if (this.offset == 0 && this.buffer.length == this.length) {
            return this.buffer;
        }
        byte[] copy = new byte[this.length];
        System.arraycopy(this.buffer, this.offset, copy, 0, this.length);
        return copy;
    }

    public static Bytes from_int(int value) {
        byte[] res = new byte[4];
        Bytes.putInt(res, 0, value);
        return new Bytes(res);
    }

    public static Bytes from_timestamp(Timestamp value) {
        byte[] res = new byte[8];
        Bytes.putLong(res, 0, value.getTime());
        return new Bytes(res);
    }

    public static Bytes from_boolean(boolean value) {
        return new Bytes(Bytes.booleanToByteArray(value));
    }

    public static Bytes from_double(double value) {
        byte[] res = new byte[8];
        Bytes.putDouble(res, 0, value);
        return new Bytes(res);
    }

    public long to_long() {
        assert (this.length == 8);
        return Bytes.toLong(this.buffer, this.offset);
    }

    public RawString to_RawString() {
        return RawString.newUnpooledRawString(this.buffer, this.offset, this.length);
    }

    public int to_int() {
        assert (this.length == 4);
        return Bytes.toInt(this.buffer, this.offset);
    }

    public String to_string() {
        return new String(this.buffer, this.offset, this.length, StandardCharsets.UTF_8);
    }

    public static String to_string(byte[] data) {
        return new String(data, 0, data.length, StandardCharsets.UTF_8);
    }

    public static RawString to_rawstring(byte[] data) {
        return RawString.newUnpooledRawString(data, 0, data.length);
    }

    public Timestamp to_timestamp() {
        assert (this.length == 8);
        return Bytes.toTimestamp(this.buffer, this.offset);
    }

    public boolean to_boolean() {
        assert (this.length == 1);
        return Bytes.toBoolean(this.buffer, this.offset);
    }

    public double to_double() {
        assert (this.length == 8);
        return Bytes.toDouble(this.buffer, this.offset);
    }

    private Bytes(byte[] data) {
        this.buffer = data;
        this.offset = 0;
        this.length = this.buffer.length;
    }

    private Bytes(byte[] data, int offset, int length) {
        this.buffer = data;
        this.offset = offset;
        this.length = length;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = CompareBytesUtils.hashCode(this.buffer, this.offset, this.length);
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        try {
            Bytes other = (Bytes)obj;
            if (this.length != other.length) {
                return false;
            }
            if (other.hashCode() != this.hashCode()) {
                return false;
            }
            return CompareBytesUtils.arraysEquals(this.buffer, this.offset, this.offset + this.length, other.buffer, other.offset, other.offset + other.length);
        }
        catch (ClassCastException otherClass) {
            return false;
        }
    }

    public static void putLong(byte[] array, int index, long value) {
        if (HAS_UNSAFE && UNALIGNED) {
            PlatformDependent.putLong((byte[])array, (int)index, (long)(BIG_ENDIAN_NATIVE_ORDER ? value : Long.reverseBytes(value)));
        } else {
            array[index] = (byte)(value >>> 56);
            array[index + 1] = (byte)(value >>> 48);
            array[index + 2] = (byte)(value >>> 40);
            array[index + 3] = (byte)(value >>> 32);
            array[index + 4] = (byte)(value >>> 24);
            array[index + 5] = (byte)(value >>> 16);
            array[index + 6] = (byte)(value >>> 8);
            array[index + 7] = (byte)value;
        }
    }

    public static void putInt(byte[] array, int index, int value) {
        if (HAS_UNSAFE && UNALIGNED) {
            PlatformDependent.putInt((byte[])array, (int)index, (int)(BIG_ENDIAN_NATIVE_ORDER ? value : Integer.reverseBytes(value)));
        } else {
            array[index] = (byte)(value >>> 24);
            array[index + 1] = (byte)(value >>> 16);
            array[index + 2] = (byte)(value >>> 8);
            array[index + 3] = (byte)value;
        }
    }

    public static void putBoolean(byte[] bytes, int offset, boolean val) {
        bytes[offset] = val ? (byte)1 : 0;
    }

    public static void putDouble(byte[] bytes, int offset, double val) {
        Bytes.putLong(bytes, offset, Double.doubleToRawLongBits(val));
    }

    public static long toLong(byte[] array, int index) {
        if (HAS_UNSAFE && UNALIGNED) {
            long v = PlatformDependent.getLong((byte[])array, (int)index);
            return BIG_ENDIAN_NATIVE_ORDER ? v : Long.reverseBytes(v);
        }
        return ((long)array[index] & 0xFFL) << 56 | ((long)array[index + 1] & 0xFFL) << 48 | ((long)array[index + 2] & 0xFFL) << 40 | ((long)array[index + 3] & 0xFFL) << 32 | ((long)array[index + 4] & 0xFFL) << 24 | ((long)array[index + 5] & 0xFFL) << 16 | ((long)array[index + 6] & 0xFFL) << 8 | (long)array[index + 7] & 0xFFL;
    }

    public static int compareInt(byte[] array, int index, int value) {
        return Integer.compare(Bytes.toInt(array, index), value);
    }

    public static int compareInt(byte[] array, int index, long value) {
        return Long.compare(Bytes.toInt(array, index), value);
    }

    public static int compareLong(byte[] array, int index, int value) {
        return Long.compare(Bytes.toLong(array, index), value);
    }

    public static int compareLong(byte[] array, int index, long value) {
        return Long.compare(Bytes.toLong(array, index), value);
    }

    public static int toInt(byte[] array, int index) {
        if (HAS_UNSAFE && UNALIGNED) {
            int v = PlatformDependent.getInt((byte[])array, (int)index);
            return BIG_ENDIAN_NATIVE_ORDER ? v : Integer.reverseBytes(v);
        }
        return (array[index] & 0xFF) << 24 | (array[index + 1] & 0xFF) << 16 | (array[index + 2] & 0xFF) << 8 | array[index + 3] & 0xFF;
    }

    public static Timestamp toTimestamp(byte[] bytes, int offset) {
        long l = Bytes.toLong(bytes, offset);
        if (l < 0L) {
            return null;
        }
        return new Timestamp(l);
    }

    public static boolean toBoolean(byte[] bytes, int offset) {
        return bytes[offset] != 1;
    }

    public static double toDouble(byte[] bytes, int offset) {
        return Double.longBitsToDouble(Bytes.toLong(bytes, offset));
    }

    public static int compare(byte[] left, byte[] right) {
        return CompareBytesUtils.compare(left, right);
    }

    @Override
    public int compareTo(Bytes o) {
        if (this == POSITIVE_INFINITY) {
            return this == o ? 0 : 1;
        }
        if (o == POSITIVE_INFINITY) {
            return -1;
        }
        return CompareBytesUtils.compare(this.buffer, this.offset, this.offset + this.length, o.buffer, o.offset, o.offset + o.length);
    }

    public static boolean startsWith(byte[] left, int offset, int bufferlen, int max, byte[] right) {
        int endleft = offset + bufferlen;
        int endmax = offset + max;
        int i = offset;
        for (int j = 0; i < endleft && j < right.length && i < endmax; ++i, ++j) {
            if (left[i] == right[j]) continue;
            return false;
        }
        return true;
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int getOffset() {
        return this.offset;
    }

    public String toString() {
        if (this.buffer == null) {
            return "null";
        }
        return Bytes.arraytohexstring(this.buffer, this.offset, this.length);
    }

    public static String arraytohexstring(byte[] buffer, int offset, int length) {
        StringBuilder string = new StringBuilder();
        for (int i = offset; i < offset + length; ++i) {
            byte b = buffer[i];
            String hexString = Integer.toHexString(0xFF & b);
            string.append(hexString.length() == 1 ? "0" + hexString : hexString);
        }
        return string.toString();
    }

    public ByteArrayCursor newCursor() {
        return ByteArrayCursor.wrap(this.buffer, this.offset, this.length);
    }

    public Bytes next() {
        byte[] dst = new byte[this.length];
        System.arraycopy(this.buffer, this.offset, dst, 0, this.length);
        int idx = this.length - 1;
        while (idx > -1) {
            int n = idx--;
            dst[n] = (byte)(dst[n] + 1);
            if (dst[n] == 0) continue;
        }
        if (idx == -1) {
            throw new IllegalStateException("Cannot generate a next value for a full 1 byte array, no space for another element");
        }
        return new Bytes(dst);
    }

    public boolean startsWith(int length, byte[] prefix) {
        return Bytes.startsWith(this.buffer, this.offset, this.length, length, prefix);
    }

    public Bytes nonShared() {
        if (this.isShared()) {
            byte[] array = new byte[this.length];
            System.arraycopy(this.buffer, this.offset, array, 0, this.length);
            return new Bytes(array, 0, this.length);
        }
        return this;
    }

    public boolean isShared() {
        return this.offset != 0 || this.length != this.buffer.length;
    }
}

