/*
 * Decompiled with CFR 0.152.
 */
package herddb.index.blink;

import herddb.core.Page;
import herddb.core.PageReplacementPolicy;
import herddb.index.blink.BLinkIndexDataStorage;
import herddb.index.blink.BLinkMetadata;
import herddb.utils.BooleanHolder;
import herddb.utils.Holder;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Spliterators;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class BLink<K extends Comparable<K>, V>
implements AutoCloseable,
Page.Owner {
    private static final boolean DEBUG = false;
    private static final Logger LOGGER = Logger.getLogger(BLink.class.getName());
    static final long UNKNOWN_SIZE = 0L;
    private static final int READ_LOCK = 1;
    private static final int WRITE_LOCK = 2;
    private static final int ADD_TASK = 1;
    private static final int REMOVE_TASK = 2;
    private static final int CRITIC_MIN_CHILDREN = 2;
    private static final long VARIABLE_SIZE = -1L;
    private final Anchor<K, V> anchor;
    private final ConcurrentMap<Long, Node<K, V>> nodes;
    private final AtomicLong nextID;
    private final K positiveInfinity;
    private final long maxSize;
    private final long minSize;
    private final long constantKeySize;
    private final long constantValueSize;
    private final long constantFullSize;
    private final SizeEvaluator<K, V> evaluator;
    private final BLinkIndexDataStorage<K, V> storage;
    private final PageReplacementPolicy policy;
    private final AtomicBoolean closed;
    private final LongAdder size;
    private final LongAdder usedMemory;
    private final AtomicBoolean criticRunning = new AtomicBoolean(false);

    public BLink(long maxSize, SizeEvaluator<K, V> evaluator, PageReplacementPolicy policy, BLinkIndexDataStorage<K, V> storage) {
        this.positiveInfinity = (Comparable)evaluator.getPosiviveInfinityKey();
        if (this.positiveInfinity != evaluator.getPosiviveInfinityKey()) {
            throw new IllegalStateException("getPosiviveInfinityKey must always return the same value");
        }
        if (evaluator.isKeySizeConstant()) {
            this.constantKeySize = evaluator.constantKeySize();
            if (this.constantKeySize <= 0L) {
                throw new IllegalArgumentException("Invalid constant key size " + this.constantKeySize + ". It must be greater than 0");
            }
        } else {
            this.constantKeySize = -1L;
        }
        if (evaluator.isValueSizeConstant()) {
            this.constantValueSize = evaluator.constantValueSize();
            if (this.constantValueSize <= 0L) {
                throw new IllegalArgumentException("Invalid constant value size " + this.constantValueSize + ". It must be greater than 0");
            }
        } else {
            this.constantValueSize = -1L;
        }
        this.constantFullSize = evaluator.isKeySizeConstant() && evaluator.isValueSizeConstant() ? this.constantKeySize + this.constantValueSize : -1L;
        this.maxSize = maxSize;
        this.minSize = maxSize / 2L;
        this.evaluator = evaluator;
        this.storage = storage;
        this.policy = policy;
        this.nextID = new AtomicLong(1L);
        this.closed = new AtomicBoolean(false);
        this.size = new LongAdder();
        this.usedMemory = new LongAdder();
        this.nodes = new ConcurrentHashMap<Long, Node<K, V>>();
        Node<K, V> root = this.allocate_node(true);
        this.anchor = new Anchor<K, V>(root);
        Page.Metadata meta = policy.add(root);
        if (meta != null) {
            meta.owner.unload(meta.pageId);
        }
    }

    public BLink(long maxSize, SizeEvaluator<K, V> evaluator, PageReplacementPolicy policy, BLinkIndexDataStorage<K, V> storage, BLinkMetadata<K> metadata) {
        this.positiveInfinity = (Comparable)evaluator.getPosiviveInfinityKey();
        if (this.positiveInfinity != evaluator.getPosiviveInfinityKey()) {
            throw new IllegalStateException("getPosiviveInfinityKey must always return the same value");
        }
        if (evaluator.isKeySizeConstant()) {
            this.constantKeySize = evaluator.constantKeySize();
            if (this.constantKeySize <= 0L) {
                throw new IllegalArgumentException("Invalid constant key size " + this.constantKeySize + ". It must be greater than 0");
            }
        } else {
            this.constantKeySize = -1L;
        }
        if (evaluator.isValueSizeConstant()) {
            this.constantValueSize = evaluator.constantValueSize();
            if (this.constantValueSize <= 0L) {
                throw new IllegalArgumentException("Invalid constant data size " + this.constantValueSize + ". It must be greater than 0");
            }
        } else {
            this.constantValueSize = -1L;
        }
        this.constantFullSize = evaluator.isKeySizeConstant() && evaluator.isValueSizeConstant() ? this.constantKeySize + this.constantValueSize : -1L;
        this.maxSize = maxSize;
        this.minSize = maxSize / 2L;
        this.evaluator = evaluator;
        this.storage = storage;
        this.policy = policy;
        this.nextID = new AtomicLong(metadata.nextID);
        this.closed = new AtomicBoolean(false);
        this.size = new LongAdder();
        this.size.add(metadata.values);
        this.usedMemory = new LongAdder();
        this.nodes = new ConcurrentHashMap<Long, Node<K, V>>();
        this.convertNodeMetadata(metadata.nodes, this.nodes);
        this.anchor = new Anchor((Node)this.nodes.get(metadata.fast), metadata.fastheight, (Node)this.nodes.get(metadata.top), metadata.topheight, (Node)this.nodes.get(metadata.first));
    }

    private void convertNodeMetadata(List<BLinkMetadata.BLinkNodeMetadata<K>> nodes, Map<Long, Node<K, V>> map) {
        for (BLinkMetadata.BLinkNodeMetadata<K> metadata : nodes) {
            map.put(metadata.id, new Node(metadata, this));
        }
        for (BLinkMetadata.BLinkNodeMetadata<K> metadata : nodes) {
            Node<K, V> node = map.get(metadata.id);
            if (metadata.rightlink != -1L) {
                node.rightlink = map.get(metadata.rightlink);
            }
            if (metadata.outlink == -1L) continue;
            node.outlink = map.get(metadata.outlink);
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            for (Node node : this.nodes.values()) {
                if (node.unload(false, false)) {
                    this.policy.remove(node);
                }
                node.outlink = null;
                node.rightlink = null;
            }
            this.anchor.fast = null;
            this.anchor.top = null;
            this.nodes.clear();
            this.size.reset();
        }
    }

    public void truncate() {
        for (Node node : this.nodes.values()) {
            if (node.unload(false, false)) {
                this.policy.remove(node);
            }
            node.outlink = null;
            node.rightlink = null;
        }
        this.nodes.clear();
        this.size.reset();
        Node<K, V> root = this.allocate_node(true);
        this.anchor.reset(root);
        Page.Metadata meta = this.policy.add(root);
        if (meta != null) {
            meta.owner.unload(meta.pageId);
        }
    }

    public long size() {
        return this.size.sum();
    }

    public long getUsedMemory() {
        return this.usedMemory.sum();
    }

    public int nodes() {
        return this.nodes.size();
    }

    @Override
    public void unload(long pageId) {
        ((Node)this.nodes.get(pageId)).unload(true, false);
    }

    private boolean attemptUnload(Page.Metadata unload) {
        if (unload.owner == this) {
            return ((Node)this.nodes.get(unload.pageId)).unload(true, true);
        }
        unload.owner.unload(unload.pageId);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BLinkMetadata<K> checkpoint() throws IOException {
        LinkedList metadatas = new LinkedList();
        for (Node node : this.nodes.values()) {
            this.lock(node, 1);
            try {
                if (node.empty()) {
                    if (this.policy.remove(node)) {
                        node.unload(false, false);
                    }
                    this.nodes.remove(node.pageId);
                    continue;
                }
            }
            finally {
                this.unlock(node, 1);
                continue;
            }
            BLinkMetadata.BLinkNodeMetadata metadata = node.checkpoint();
            metadatas.add(metadata);
            if (!LOGGER.isLoggable(Level.FINER)) continue;
            LOGGER.log(Level.FINER, "node {0} has {1} keys at checkpoint", new Object[]{metadata.id, metadata.keys});
        }
        this.lock_anchor(1);
        long fast = this.anchor.fast.pageId;
        int fastheight = this.anchor.fastheight;
        long top = this.anchor.top.pageId;
        int topheight = this.anchor.topheight;
        long first = this.anchor.first.pageId;
        this.unlock_anchor(1);
        return new BLinkMetadata(this.nextID.get(), fast, fastheight, top, topheight, first, this.size.sum(), metadatas);
    }

    public V search(K v) {
        Node<K, V> n;
        Deque descent = DummyDeque.INSTANCE;
        try {
            n = this.locate_leaf(v, 1, descent);
        }
        catch (IOException ex) {
            throw new UncheckedIOException("failed to search for " + v, ex);
        }
        try {
            V search;
            V v2 = search = n.check_key(v);
            return v2;
        }
        catch (IOException ex) {
            throw new UncheckedIOException("failed to search for " + v, ex);
        }
        finally {
            this.unlock(n, 1);
        }
    }

    public Stream<Map.Entry<K, V>> scan(K from, K to) {
        Node<Object, Object> n;
        Deque descent = DummyDeque.INSTANCE;
        if (from == null) {
            this.lock_anchor(1);
            n = this.anchor.first;
            this.unlock_anchor(1);
            this.lock(n, 1);
        } else {
            try {
                n = this.locate_leaf(from, 1, descent);
            }
            catch (IOException ex) {
                throw new UncheckedIOException("failed to scan from " + from + " to " + to, ex);
            }
        }
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new ScanIterator(this, n, from, from != null, to, false), 0), false);
    }

    public Stream<Map.Entry<K, V>> scan(K from, K to, boolean toInclusive) {
        Node<Object, Object> n;
        Deque descent = DummyDeque.INSTANCE;
        if (from == null) {
            this.lock_anchor(1);
            n = this.anchor.first;
            this.unlock_anchor(1);
            this.lock(n, 1);
        } else {
            try {
                n = this.locate_leaf(from, 1, descent);
            }
            catch (IOException ex) {
                throw new UncheckedIOException("failed to scan from " + from + " to " + to, ex);
            }
        }
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new ScanIterator(this, n, from, from != null, to, toInclusive), 0), false);
    }

    public boolean insert(K v, V e, V expected) {
        boolean added;
        Node<K, V> n;
        LinkedList<ResultCouple<K, V>> descent = new LinkedList<ResultCouple<K, V>>();
        LinkedList<CriticJob> maintenance = new LinkedList<CriticJob>();
        try {
            n = this.locate_leaf(v, 2, descent);
        }
        catch (IOException ex) {
            throw new UncheckedIOException("failed to insert " + v, ex);
        }
        try {
            added = n.add_key_if(v, e, expected);
            this.normalize(n, descent, 1, maintenance);
        }
        catch (IOException ex) {
            throw new UncheckedIOException("failed to insert " + v, ex);
        }
        finally {
            this.unlock(n, 2);
        }
        if (added && expected == null) {
            this.size.increment();
        }
        this.handleMainenance(maintenance);
        return added;
    }

    public V insert(K v, V e) {
        V replaced;
        Node<K, V> n;
        LinkedList<ResultCouple<K, V>> descent = new LinkedList<ResultCouple<K, V>>();
        LinkedList<CriticJob> maintenance = new LinkedList<CriticJob>();
        try {
            n = this.locate_leaf(v, 2, descent);
        }
        catch (IOException ex) {
            throw new UncheckedIOException("failed to insert " + v, ex);
        }
        try {
            replaced = n.add_key(v, e);
            this.normalize(n, descent, 1, maintenance);
        }
        catch (IOException ex) {
            throw new UncheckedIOException("failed to insert " + v, ex);
        }
        finally {
            this.unlock(n, 2);
        }
        if (replaced == null) {
            this.size.increment();
        }
        this.handleMainenance(maintenance);
        return replaced;
    }

    public V delete(K v) {
        V delete;
        Node<K, V> n;
        LinkedList<ResultCouple<K, V>> descent = new LinkedList<ResultCouple<K, V>>();
        LinkedList<CriticJob> maintenance = new LinkedList<CriticJob>();
        try {
            n = this.locate_leaf(v, 2, descent);
        }
        catch (IOException ex) {
            throw new UncheckedIOException("failed to delete " + v, ex);
        }
        try {
            delete = n.remove_key(v);
            this.normalize(n, descent, 1, maintenance);
        }
        catch (IOException ex) {
            throw new UncheckedIOException("failed to delete " + v, ex);
        }
        finally {
            this.unlock(n, 2);
        }
        if (delete != null) {
            this.size.decrement();
        }
        this.handleMainenance(maintenance);
        return delete;
    }

    private Node<K, V> locate_leaf(K v, int lastlock, Deque<ResultCouple<K, V>> descent) throws IOException {
        ResultCouple move_right;
        this.lock_anchor(1);
        Node n = this.anchor.fast;
        int enterheight = this.anchor.fastheight;
        Object ubleftsep = this.positiveInfinity;
        this.unlock_anchor(1);
        descent.clear();
        for (int h = enterheight; h > 1; --h) {
            Node m;
            move_right = this.move_right(v, n, ubleftsep, 1);
            n = move_right.node;
            ubleftsep = move_right.ubleftsep;
            descent.push(move_right);
            try {
                ResultCouple find = n.find(v, ubleftsep);
                m = find.node;
                ubleftsep = find.ubleftsep;
            }
            catch (IOException e) {
                throw new IOException("failed to find key " + v + " on leaf " + n.pageId, e);
            }
            finally {
                this.unlock(n, 1);
            }
            n = m;
        }
        move_right = this.move_right(v, n, ubleftsep, lastlock);
        n = move_right.node;
        ubleftsep = move_right.ubleftsep;
        return n;
    }

    private ResultCouple<K, V> move_right(K v, Node<K, V> n, K ubleftsep, int rw) {
        this.lock(n, rw);
        while (n.empty() || n.rightsep().compareTo(v) < 0) {
            Node<K, V> m;
            if (n.empty()) {
                m = n.outlink();
            } else {
                m = n.rightlink();
                ubleftsep = n.rightsep();
            }
            this.unlock(n, rw);
            this.lock(m, rw);
            n = m;
        }
        return new ResultCouple<K, V>(n, ubleftsep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void normalize(Node<K, V> n, Deque<ResultCouple<K, V>> descent, int atheight, Queue<CriticJob> maintenance) throws IOException {
        if (n.too_sparse() && n.rightlink() != null) {
            K sep;
            Node<K, V> sib = n.rightlink();
            this.lock(sib, 2);
            try {
                sep = n.half_merge(sib);
            }
            finally {
                this.unlock(sib, 2);
            }
            this.spawn(() -> this.ascend(2, sep, sib, atheight + 1, this.clone(descent), maintenance), maintenance);
            this.spawn(() -> this.run_critic(), maintenance);
        }
        if (n.too_crowded()) {
            Node<K, V> newsib = this.allocate_node(n.leaf);
            K newsep = n.half_split(newsib);
            Page.Metadata meta = this.policy.add(newsib);
            if (meta != null) {
                meta.owner.unload(meta.pageId);
            }
            this.spawn(() -> this.ascend(1, newsep, newsib, atheight + 1, this.clone(descent), maintenance), maintenance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ascend(int t, K sep, Node<K, V> child, int toheight, Deque<ResultCouple<K, V>> descent, Queue<CriticJob> maintenance) throws IOException {
        ResultCouple<K, V> locate_internal = this.locate_internal(sep, toheight, descent, maintenance);
        Node n = locate_internal.node;
        Object ubleftsep = locate_internal.ubleftsep;
        try {
            while (!this.add_or_remove_link(t, sep, child, n, toheight, descent, maintenance)) {
                this.unlock(n, 2);
                this.delay(1L);
                ResultCouple move_right = this.move_right(sep, n, ubleftsep, 2);
                n = move_right.node;
                ubleftsep = move_right.ubleftsep;
            }
            this.normalize(n, descent, toheight, maintenance);
        }
        finally {
            this.unlock(n, 2);
        }
    }

    private boolean add_or_remove_link(int t, K sep, Node<K, V> child, Node<K, V> n, int atheight, Deque<ResultCouple<K, V>> descent, Queue<CriticJob> maintenance) throws IOException {
        if (t == 1) {
            return n.add_link(sep, child);
        }
        if (n.rightsep().equals(sep)) {
            K newsep;
            Node<K, V> sib = n.rightlink();
            this.lock(sib, 2);
            try {
                newsep = n.half_merge(sib);
            }
            catch (IOException ex) {
                throw new UncheckedIOException("failed to remove link from " + n.pageId + " to " + sib.pageId, ex);
            }
            finally {
                this.unlock(sib, 2);
            }
            this.spawn(() -> this.ascend(2, newsep, sib, atheight + 1, this.clone(descent), maintenance), maintenance);
        }
        return n.remove_link(sep, child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultCouple<K, V> locate_internal(K v, int toheight, Deque<ResultCouple<K, V>> descent, Queue<CriticJob> maintenance) throws IOException {
        ResultCouple move_right;
        Object ubleftsep;
        Node n;
        if (descent.isEmpty()) {
            n = null;
            ubleftsep = this.positiveInfinity;
        } else {
            ResultCouple<K, V> pop = descent.pop();
            n = pop.node;
            ubleftsep = pop.ubleftsep;
        }
        if (ubleftsep.compareTo(v) > 0) {
            int enterheight;
            this.lock_anchor(1);
            if (this.anchor.topheight < toheight) {
                this.unlock_anchor(1);
                this.lock_anchor(2);
                if (this.anchor.topheight < toheight) {
                    Node<K, V> newroot = this.allocate_node(false);
                    this.grow(newroot);
                    Page.Metadata meta = this.policy.add(newroot);
                    if (meta != null) {
                        meta.owner.unload(meta.pageId);
                    }
                    this.spawn(() -> this.run_critic(), maintenance);
                }
                this.unlock_anchor(2);
                this.lock_anchor(1);
            }
            if (this.anchor.fastheight >= toheight) {
                n = this.anchor.fast;
                enterheight = this.anchor.fastheight;
            } else {
                n = this.anchor.top;
                enterheight = this.anchor.topheight;
            }
            ubleftsep = this.positiveInfinity;
            this.unlock_anchor(1);
            descent.clear();
            for (int h = enterheight; h > toheight; --h) {
                Node m;
                move_right = this.move_right(v, n, ubleftsep, 1);
                try {
                    n = move_right.node;
                    ubleftsep = move_right.ubleftsep;
                    descent.push(move_right);
                    ResultCouple find = n.find(v, ubleftsep);
                    m = find.node;
                    ubleftsep = find.ubleftsep;
                }
                finally {
                    this.unlock(n, 1);
                }
                n = m;
            }
        }
        move_right = this.move_right(v, n, ubleftsep, 2);
        n = move_right.node;
        ubleftsep = move_right.ubleftsep;
        return move_right;
    }

    private void run_critic() throws IOException {
        int h;
        if (!this.criticRunning.compareAndSet(false, true)) {
            return;
        }
        this.lock_anchor(1);
        Node n = this.anchor.top;
        this.unlock_anchor(1);
        this.lock(n, 1);
        try {
            for (h = this.anchor.topheight; n.number_of_children() < 2 && n.rightlink() == null && h > 1; --h) {
                Node m;
                try {
                    m = n.leftmost_child();
                }
                catch (IOException e) {
                    throw new IOException("failed to find leftmost child on node " + n.pageId, e);
                }
                finally {
                    this.unlock(n, 1);
                }
                n = m;
                this.lock(n, 1);
            }
        }
        catch (IOException e) {
            throw new IOException("failed to evaluate anchor fast height", e);
        }
        finally {
            this.unlock(n, 1);
        }
        this.lock_anchor(1);
        if (this.anchor.fastheight == h) {
            this.unlock_anchor(1);
        } else {
            this.unlock_anchor(1);
            this.lock_anchor(2);
            this.anchor.fastheight = h;
            this.anchor.fast = n;
            this.unlock_anchor(2);
        }
        this.criticRunning.set(false);
    }

    private void spawn(CriticJob runnable, Queue<CriticJob> maintenance) {
        maintenance.offer(runnable);
    }

    private void handleMainenance(Queue<CriticJob> maintenance) {
        try {
            while (!maintenance.isEmpty()) {
                maintenance.poll().execute();
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException("failed to handle Blink maintenance", ex);
        }
    }

    private Deque<ResultCouple<K, V>> clone(Deque<ResultCouple<K, V>> descent) {
        return (Deque)((LinkedList)descent).clone();
    }

    private Node<K, V> allocate_node(boolean leaf) {
        Long nodeID = this.nextID.getAndIncrement();
        Node node = new Node(nodeID, leaf, this, this.positiveInfinity);
        this.nodes.put(nodeID, node);
        return node;
    }

    private void grow(Node<K, V> n) {
        n.grow(this.anchor.top);
        this.anchor.top = n;
        ++this.anchor.topheight;
    }

    private void lock_anchor(int locktype) {
        this.lock(this.anchor.lock, locktype);
    }

    private void unlock_anchor(int locktype) {
        this.unlock(this.anchor.lock, locktype);
    }

    private void lock(Node<K, V> n, int locktype) {
        this.lock(n.lock, locktype);
    }

    private void unlock(Node<K, V> n, int locktype) {
        this.unlock(n.lock, locktype);
    }

    private void lock(ReadWriteLock lock, int locktype) {
        if (locktype == 1) {
            lock.readLock().lock();
        } else {
            lock.writeLock().lock();
        }
    }

    private void unlock(ReadWriteLock lock, int locktype) {
        if (locktype == 1) {
            lock.readLock().unlock();
        } else {
            lock.writeLock().unlock();
        }
    }

    private void delay(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException soaked) {
            Thread.currentThread().interrupt();
        }
    }

    public String toString() {
        return "BLink [anchor=" + this.anchor + ", nextID=" + this.nextID + ", keys=" + this.size() + ", maxSize=" + this.maxSize + ", minSize=" + this.minSize + ", closed=" + this.closed + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toStringFull() {
        Node top = this.anchor.top;
        LinkedList<Object[]> stack = new LinkedList<Object[]>();
        HashSet<Node> seen = new HashSet<Node>();
        stack.push(new Object[]{top, 0});
        try {
            StringBuilder builder = new StringBuilder();
            while (!stack.isEmpty()) {
                LockAndUnload loadLock;
                LinkedList<Object[]> cstack;
                Object[] el = (Object[])stack.pop();
                Node node = (Node)el[0];
                int indents = (Integer)el[1];
                for (int i = 0; i < indents; ++i) {
                    builder.append("-");
                }
                builder.append("> ");
                if (seen.contains(node)) {
                    builder.append("Seen: ").append(node.pageId).append('\n');
                    continue;
                }
                seen.add(node);
                builder.append(node).append(' ');
                if (node.leaf) {
                    cstack = new LinkedList<Object[]>();
                    loadLock = node.loadAndLock(true);
                    try {
                        for (Map.Entry entry : node.map.entrySet()) {
                            builder.append(entry.getValue()).append(" <- ").append(entry.getKey()).append(" | ");
                        }
                        builder.setLength(builder.length() - 3);
                    }
                    finally {
                        loadLock.unlock();
                        if (loadLock.unload != null) {
                            loadLock.unload();
                        }
                    }
                    while (!cstack.isEmpty()) {
                        stack.push((Object[])cstack.pop());
                    }
                } else {
                    cstack = new LinkedList();
                    loadLock = node.loadAndLock(true);
                    try {
                        for (Map.Entry entry : node.map.entrySet()) {
                            builder.append(((Node)entry.getValue()).pageId).append(" <- ").append(entry.getKey()).append(" | ");
                            cstack.push(new Object[]{entry.getValue(), indents + 1});
                        }
                        builder.setLength(builder.length() - 3);
                    }
                    finally {
                        loadLock.unlock();
                        if (loadLock.unload != null) {
                            loadLock.unload();
                        }
                    }
                    while (!cstack.isEmpty()) {
                        stack.push((Object[])cstack.pop());
                    }
                }
                builder.append('\n');
            }
            return builder.toString();
        }
        catch (IOException ex) {
            throw new UncheckedIOException("failed to generate full string representation", ex);
        }
    }

    private static class Node<X extends Comparable<X>, Y>
    extends BLinkPage<X, Y> {
        static final long NODE_CONSTANT_SIZE = 408L;
        static final long ENTRY_CONSTANT_SIZE = 42L;
        long storeId;
        long flushId;
        final boolean leaf;
        final ReadWriteLock lock;
        final ReadWriteLock loadLock;
        NavigableMap<X, Object> map;
        int keys;
        long size;
        X rightsep;
        Node<X, Y> outlink;
        Node<X, Y> rightlink;
        boolean loaded;
        volatile boolean dirty;

        Node(long id, boolean leaf, BLink<X, Y> tree, X rightsep) {
            super(tree, id);
            this.storeId = -1L;
            this.flushId = -1L;
            this.leaf = leaf;
            this.rightsep = rightsep;
            this.lock = new ReentrantReadWriteLock(false);
            this.loadLock = new ReentrantReadWriteLock(false);
            this.map = Node.newNodeMap();
            this.keys = 0;
            this.size = 408L;
            this.loaded = true;
            this.dirty = true;
        }

        private static <A, B> NavigableMap<A, B> newNodeMap() {
            return new TreeMap();
        }

        Node(BLinkMetadata.BLinkNodeMetadata<X> metadata, BLink<X, Y> tree) {
            super(tree, metadata.id);
            this.storeId = metadata.storeId;
            this.flushId = -1L;
            this.leaf = metadata.leaf;
            this.rightsep = (Comparable)metadata.rightsep;
            this.lock = new ReentrantReadWriteLock(false);
            this.loadLock = new ReentrantReadWriteLock(false);
            this.map = Node.newNodeMap();
            this.keys = metadata.keys;
            this.size = metadata.bytes;
            this.loaded = false;
            this.dirty = false;
        }

        boolean empty() {
            return this.outlink != null;
        }

        boolean too_sparse() {
            return this.size < ((BLink)this.owner).minSize;
        }

        boolean too_crowded() {
            return this.size > ((BLink)this.owner).maxSize;
        }

        X rightsep() {
            return this.rightsep;
        }

        Node<X, Y> outlink() {
            return this.outlink;
        }

        Node<X, Y> rightlink() {
            return this.rightlink;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        X half_merge(Node<X, Y> right) throws IOException {
            X half_merge = this.rightsep;
            LockAndUnload<X, Y> thisLoadLock = null;
            LockAndUnload<X, Y> rightLoadLock = null;
            boolean thisUnloaded = false;
            boolean rightUnloaded = false;
            try {
                try {
                    thisLoadLock = this.loadAndLock(false);
                    thisUnloaded = thisLoadLock.unloadIfNot(right, (BLink)this.owner);
                    rightLoadLock = right.loadAndLock(false);
                    rightUnloaded = rightLoadLock.unloadIfNot(this, (BLink)this.owner);
                    this.map.putAll(right.map);
                    this.dirty = true;
                    right.map.clear();
                    right.map = Node.newNodeMap();
                    this.size += right.size - 408L;
                    right.size = 408L;
                }
                finally {
                    if (thisLoadLock != null) {
                        thisLoadLock.unlock();
                    }
                    if (rightLoadLock != null) {
                        rightLoadLock.unlock();
                    }
                    if (thisLoadLock != null && !thisUnloaded) {
                        thisLoadLock.unload();
                    }
                    if (rightLoadLock != null && !rightUnloaded) {
                        rightLoadLock.unload();
                    }
                }
            }
            catch (IOException e) {
                throw new IOException("failed to half merge " + right.pageId + " into " + this.pageId, e);
            }
            this.keys += right.keys;
            right.keys = 0;
            this.rightlink = right.rightlink;
            right.outlink = this;
            this.rightsep = right.rightsep;
            if (((BLink)this.owner).policy.remove(right)) {
                right.unload(false, false);
            }
            return half_merge;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        X half_split(Node<X, Y> right) throws IOException {
            right.rightlink = this.rightlink;
            this.rightlink = right;
            long limit = (this.size - 408L) / 2L;
            long keeping = 0L;
            int count = 0;
            Comparable lastKey = null;
            LockAndUnload<X, Y> loadLock = this.loadAndLock(true);
            try {
                boolean toright = false;
                Iterator entryIt = this.map.entrySet().iterator();
                while (entryIt.hasNext()) {
                    Map.Entry entry = entryIt.next();
                    if (toright) {
                        right.map.put((Comparable)entry.getKey(), entry.getValue());
                        entryIt.remove();
                        continue;
                    }
                    ++count;
                    keeping = this.leaf ? (keeping += ((BLink)this.owner).constantFullSize == -1L ? ((BLink)this.owner).evaluator.evaluateAll((Comparable)entry.getKey(), entry.getValue()) + 42L : ((BLink)this.owner).constantFullSize + 42L) : (keeping += ((BLink)this.owner).constantKeySize == -1L ? ((BLink)this.owner).evaluator.evaluateKey((Comparable)entry.getKey()) + 42L : ((BLink)this.owner).constantKeySize + 42L);
                    if (keeping < limit) continue;
                    toright = true;
                    lastKey = (Comparable)entry.getKey();
                }
                this.dirty = true;
            }
            finally {
                loadLock.unlock();
            }
            if (loadLock.unload != null) {
                loadLock.unload();
            }
            right.keys = this.keys - count;
            this.keys = count;
            right.size = this.size - keeping;
            this.size = keeping + 408L;
            ((BLink)this.owner).usedMemory.add(408L);
            right.rightsep = this.rightsep;
            this.rightsep = lastKey;
            return this.rightsep;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<Map.Entry<X, Y>> copyRange(X start, boolean startInclusive, X end, boolean endInclusive) throws IOException {
            LockAndUnload<X, Y> loadLock = this.loadAndLock(true);
            try {
                NavigableMap<X, Object> sub;
                if (start == null) {
                    if (startInclusive) {
                        throw new NullPointerException("Null inclusive start");
                    }
                    if (end == null) {
                        if (endInclusive) {
                            throw new NullPointerException("Null inclusive end");
                        }
                        sub = this.map;
                    } else {
                        sub = this.map.headMap(end, endInclusive);
                    }
                } else if (end == null) {
                    if (endInclusive) {
                        throw new NullPointerException("Null inclusive end");
                    }
                    sub = this.map.tailMap(start, startInclusive);
                } else {
                    sub = this.map.subMap(start, startInclusive, end, endInclusive);
                }
                ArrayList list = new ArrayList();
                for (Map.Entry entry : sub.entrySet()) {
                    list.add(new AbstractMap.SimpleImmutableEntry(entry));
                }
                ArrayList arrayList = list;
                return arrayList;
            }
            finally {
                loadLock.unlock();
                if (loadLock.unload != null) {
                    loadLock.unload();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Y check_key(X key) throws IOException {
            LockAndUnload<X, Y> loadLock = this.loadAndLock(true);
            try {
                Object v = this.map.get(key);
                return (Y)v;
            }
            finally {
                loadLock.unlock();
                if (loadLock.unload != null) {
                    loadLock.unload();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Y add_key(X key, Y value) throws IOException {
            Y old;
            LockAndUnload<X, Y> loadLock = this.loadAndLock(true);
            try {
                old = this.map.put(key, value);
                this.dirty = true;
            }
            finally {
                loadLock.unlock();
                if (loadLock.unload != null) {
                    loadLock.unload();
                }
            }
            if (old == null) {
                ++this.keys;
                long added = ((BLink)this.owner).constantFullSize == -1L ? ((BLink)this.owner).evaluator.evaluateAll(key, value) + 42L : ((BLink)this.owner).constantFullSize + 42L;
                this.size += added;
                ((BLink)this.owner).usedMemory.add(added);
            } else if (((BLink)this.owner).constantValueSize == -1L) {
                long added = ((BLink)this.owner).evaluator.evaluateValue(value) - ((BLink)this.owner).evaluator.evaluateValue(old);
                this.size += added;
                ((BLink)this.owner).usedMemory.add(added);
            }
            return old;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean add_key_if(X key, Y value, Y expected) throws IOException {
            Object old;
            LockAndUnload<X, Y> loadLock = this.loadAndLock(true);
            try {
                if (expected == null) {
                    old = this.map.putIfAbsent(key, value);
                    if (old != null) {
                        boolean bl = false;
                        return bl;
                    }
                } else {
                    BooleanHolder replaced = new BooleanHolder(false);
                    Holder hold = new Holder();
                    this.map.computeIfPresent(key, (skey, currentValue) -> {
                        if (expected.equals(currentValue)) {
                            replaced.value = true;
                            hold.value = currentValue;
                            return value;
                        }
                        return currentValue;
                    });
                    if (!replaced.value) {
                        boolean bl = false;
                        return bl;
                    }
                    old = hold.value;
                }
                this.dirty = true;
            }
            finally {
                loadLock.unlock();
                if (loadLock.unload != null) {
                    loadLock.unload();
                }
            }
            if (old == null) {
                ++this.keys;
                long added = ((BLink)this.owner).constantFullSize == -1L ? ((BLink)this.owner).evaluator.evaluateAll(key, value) + 42L : ((BLink)this.owner).constantFullSize + 42L;
                this.size += added;
                ((BLink)this.owner).usedMemory.add(added);
            } else if (((BLink)this.owner).constantValueSize == -1L) {
                long added = ((BLink)this.owner).evaluator.evaluateValue(value) - ((BLink)this.owner).evaluator.evaluateValue(old);
                this.size += added;
                ((BLink)this.owner).usedMemory.add(added);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Y remove_key(X key) throws IOException {
            Object old;
            LockAndUnload<X, Y> loadLock = this.loadAndLock(true);
            try {
                old = this.map.remove(key);
                if (old != null) {
                    this.dirty = true;
                }
            }
            finally {
                loadLock.unlock();
                if (loadLock.unload != null) {
                    loadLock.unload();
                }
            }
            if (old == null) {
                return null;
            }
            --this.keys;
            long removed = ((BLink)this.owner).constantFullSize == -1L ? ((BLink)this.owner).evaluator.evaluateAll(key, old) + 42L : ((BLink)this.owner).constantFullSize + 42L;
            this.size -= removed;
            ((BLink)this.owner).usedMemory.add(-removed);
            return (Y)old;
        }

        Node<X, Y> leftmost_child() throws IOException {
            LockAndUnload<X, Y> loadLock = this.loadAndLock(true);
            try {
                Node node = (Node)this.map.firstEntry().getValue();
                return node;
            }
            finally {
                loadLock.unlock();
                if (loadLock.unload != null) {
                    loadLock.unload();
                }
            }
        }

        int number_of_children() {
            return this.keys;
        }

        void grow(Node<X, Y> downlink) {
            this.map.put(((BLink)this.owner).positiveInfinity, downlink);
            ++this.keys;
            this.size += 42L;
            ((BLink)this.owner).usedMemory.add(42L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ResultCouple<X, Y> find(X v, X ubleftsep) throws IOException {
            LockAndUnload<X, Y> loadLock = this.loadAndLock(true);
            try {
                Map.Entry<X, Object> first = this.map.firstEntry();
                if (((Comparable)first.getKey()).compareTo(v) >= 0) {
                    ResultCouple resultCouple = new ResultCouple((Node)first.getValue(), ubleftsep);
                    return resultCouple;
                }
                Comparable key = (Comparable)this.map.lowerKey(v);
                Map.Entry<X, Object> ceiling = this.map.ceilingEntry(v);
                ResultCouple resultCouple = new ResultCouple((Node)ceiling.getValue(), key);
                return resultCouple;
            }
            finally {
                loadLock.unlock();
                if (loadLock.unload != null) {
                    loadLock.unload();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean add_link(X s, Node<X, Y> child) throws IOException {
            LockAndUnload<X, Y> loadLock = this.loadAndLock(true);
            try {
                Map.Entry<X, Object> ceiling = this.map.ceilingEntry(s);
                if (((Comparable)ceiling.getKey()).compareTo(s) == 0) {
                    boolean bl = false;
                    return bl;
                }
                this.map.put(s, ceiling.getValue());
                this.map.put((Comparable)ceiling.getKey(), child);
                this.dirty = true;
            }
            finally {
                loadLock.unlock();
                if (loadLock.unload != null) {
                    loadLock.unload();
                }
            }
            ++this.keys;
            long added = ((BLink)this.owner).constantKeySize == -1L ? ((BLink)this.owner).evaluator.evaluateKey(s) + 42L : ((BLink)this.owner).constantKeySize + 42L;
            this.size += added;
            ((BLink)this.owner).usedMemory.add(added);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean remove_link(X s, Node<X, Y> child) throws IOException {
            LockAndUnload<X, Y> loadLock = this.loadAndLock(true);
            try {
                Node pi = (Node)this.map.get(s);
                if (pi == null) {
                    boolean bl = false;
                    return bl;
                }
                Map.Entry<X, Object> eip1 = this.map.higherEntry(s);
                if (eip1.getValue().equals(child)) {
                    this.map.put((Comparable)eip1.getKey(), pi);
                    this.map.remove(s);
                    this.dirty = true;
                    --this.keys;
                    long removed = ((BLink)this.owner).constantKeySize == -1L ? ((BLink)this.owner).evaluator.evaluateKey(s) + 42L : ((BLink)this.owner).constantKeySize + 42L;
                    this.size -= removed;
                    ((BLink)this.owner).usedMemory.add(-removed);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                loadLock.unlock();
                if (loadLock.unload != null) {
                    loadLock.unload();
                }
            }
        }

        LockAndUnload<X, Y> loadAndLock(boolean doUnload) throws IOException {
            Page.Metadata unload = null;
            Lock read = this.loadLock.readLock();
            read.lock();
            if (!this.loaded) {
                read.unlock();
                Lock write = this.loadLock.writeLock();
                write.lock();
                try {
                    if (!this.loaded) {
                        this.readPage(this.flushId == -1L ? this.storeId : this.flushId);
                        this.loaded = true;
                        unload = ((BLink)this.owner).policy.add(this);
                    } else {
                        ((BLink)this.owner).policy.pageHit(this);
                    }
                    read.lock();
                }
                catch (IOException | RuntimeException err) {
                    throw new IOException("failed to read node " + this.pageId, err);
                }
                finally {
                    write.unlock();
                }
                if (doUnload && unload != null && ((BLink)this.owner).attemptUnload(unload)) {
                    unload = null;
                }
            } else {
                ((BLink)this.owner).policy.pageHit(this);
            }
            return new LockAndUnload(read, unload, this.pageId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean unload(boolean flush, boolean justTry) {
            boolean acquired;
            Lock lock = this.loadLock.writeLock();
            if (justTry) {
                acquired = lock.tryLock();
                if (!acquired) {
                    return false;
                }
            } else {
                lock.lock();
            }
            try {
                if (!this.loaded) {
                    acquired = false;
                    return acquired;
                }
                if (flush && this.dirty) {
                    try {
                        this.flush();
                    }
                    catch (IOException e) {
                        this.flushId = -1L;
                        throw new UncheckedIOException("failed to flush node " + this.pageId, e);
                    }
                }
                this.map.clear();
                this.map = null;
                this.loaded = false;
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.log(Level.FINER, "unloaded node {0}", this.pageId);
                }
                ((BLink)this.owner).usedMemory.add(-this.size);
                boolean bl = true;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        void flush() throws IOException {
            if (this.loaded && this.dirty) {
                this.flushId = this.writePage(this.flushId);
                this.dirty = false;
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.log(Level.FINER, "flush node {0}: page -> {1} with {2} keys x {3} bytes", new Object[]{this.pageId, this.flushId, this.keys, this.size});
                }
            }
        }

        BLinkMetadata.BLinkNodeMetadata<X> checkpoint() throws IOException {
            Lock lock = this.loadLock.writeLock();
            lock.lock();
            try {
                if (this.loaded && this.dirty) {
                    this.storeId = this.writePage(-1L);
                    this.flushId = -1L;
                    this.dirty = false;
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.log(Level.FINER, "checkpoint node " + this.pageId + ": newpage -> " + this.storeId + " with " + this.keys + " keys x " + this.size + " bytes");
                    }
                } else if (this.flushId != -1L) {
                    this.storeId = this.flushId;
                    this.flushId = -1L;
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.log(Level.FINER, "checkpoint node " + this.pageId + ": from existing flush -> " + this.storeId + " with " + this.keys + " keys x " + this.size + " bytes");
                    }
                }
                BLinkMetadata.BLinkNodeMetadata<X> bLinkNodeMetadata = new BLinkMetadata.BLinkNodeMetadata<X>(this.leaf, this.pageId, this.storeId, this.keys, this.size, this.outlink == null ? -1L : this.outlink.pageId, this.rightlink == null ? -1L : this.rightlink.pageId, this.rightsep);
                return bLinkNodeMetadata;
            }
            finally {
                lock.unlock();
            }
        }

        private long writePage(long pageId) throws IOException {
            if (this.leaf) {
                return this.writeLeafPage(pageId);
            }
            return this.writeNodePage(pageId);
        }

        private long writeNodePage(long pageId) throws IOException {
            HashMap pointers = new HashMap(this.keys);
            this.map.forEach((x, y) -> pointers.put(x, ((Node)y).pageId));
            if (pageId == -1L) {
                return ((BLink)this.owner).storage.createNodePage(pointers);
            }
            ((BLink)this.owner).storage.overwriteNodePage(pageId, pointers);
            return pageId;
        }

        private long writeLeafPage(long pageId) throws IOException {
            if (pageId == -1L) {
                return ((BLink)this.owner).storage.createLeafPage(this.map);
            }
            ((BLink)this.owner).storage.overwriteLeafPage(pageId, this.map);
            return pageId;
        }

        private void readPage(long pageId) throws IOException {
            if (this.leaf) {
                this.readLeafPage(pageId);
            } else {
                this.readNodePage(pageId);
            }
        }

        private void readNodePage(long pageId) throws IOException {
            HashMap<Comparable, Long> data = new HashMap<Comparable, Long>();
            ((BLink)this.owner).storage.loadNodePage(pageId, data);
            this.map = Node.newNodeMap();
            if (this.size == 0L) {
                this.size = 408L;
                data.forEach((x, y) -> {
                    Node node = (Node)((BLink)this.owner).nodes.get(y);
                    this.map.put(x, node);
                    long entrySize = x == ((BLink)this.owner).positiveInfinity ? 42L : (((BLink)this.owner).constantKeySize == -1L ? ((BLink)this.owner).evaluator.evaluateKey(x) + 42L : ((BLink)this.owner).constantKeySize + 42L);
                    this.size += entrySize;
                });
            } else {
                data.forEach((x, y) -> {
                    Node node = (Node)((BLink)this.owner).nodes.get(y);
                    this.map.put(x, node);
                });
            }
            ((BLink)this.owner).usedMemory.add(this.size);
        }

        private void readLeafPage(long pageId) throws IOException {
            this.map = Node.newNodeMap();
            ((BLink)this.owner).storage.loadLeafPage(pageId, this.map);
            if (this.size == 0L) {
                this.size = 408L;
                if (((BLink)this.owner).constantFullSize == -1L) {
                    this.map.forEach((x, y) -> this.size += ((BLink)this.owner).evaluator.evaluateAll(x, y) + 42L);
                } else {
                    this.size += (((BLink)this.owner).constantFullSize + 42L) * (long)this.map.size();
                }
            }
            ((BLink)this.owner).usedMemory.add(this.size);
        }

        public String toString() {
            return "Node [id=" + this.pageId + ", leaf=" + this.leaf + ", nkeys=" + this.keys + ", size=" + this.size + ", outlink=" + (this.outlink == null ? null : Long.valueOf(this.outlink.pageId)) + ", rightlink=" + (this.rightlink == null ? null : Long.valueOf(this.rightlink.pageId)) + ", rightsep=" + this.rightsep + "]";
        }
    }

    private static class ResultCouple<X extends Comparable<X>, Y> {
        final Node<X, Y> node;
        final X ubleftsep;

        ResultCouple(Node<X, Y> node, X ubleftsep) {
            this.node = node;
            this.ubleftsep = ubleftsep;
        }

        public String toString() {
            return "[node=" + this.node + ", ubleftsep=" + this.ubleftsep + "]";
        }
    }

    public static interface SizeEvaluator<X, Y> {
        public long evaluateKey(X var1);

        public long evaluateValue(Y var1);

        public long evaluateAll(X var1, Y var2);

        default public boolean isKeySizeConstant() {
            return false;
        }

        default public long constantKeySize() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Method constantKeySize not supported");
        }

        default public boolean isValueSizeConstant() {
            return false;
        }

        default public long constantValueSize() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Method constantValueSize not supported");
        }

        public X getPosiviveInfinityKey();
    }

    private static class Anchor<X extends Comparable<X>, Y> {
        final ReadWriteLock lock;
        Node<X, Y> fast;
        int fastheight;
        Node<X, Y> top;
        int topheight;
        Node<X, Y> first;

        public Anchor(Node<X, Y> root) {
            this(root, 1, root, 1, root);
        }

        public Anchor(Node<X, Y> fast, int fastheight, Node<X, Y> top, int topheight, Node<X, Y> first) {
            this.fast = fast;
            this.fastheight = fastheight;
            this.top = top;
            this.topheight = topheight;
            this.first = first;
            this.lock = new ReentrantReadWriteLock(false);
        }

        public void reset(Node<X, Y> root) {
            this.fast = root;
            this.fastheight = 1;
            this.top = root;
            this.topheight = 1;
            this.first = root;
        }

        public String toString() {
            return "Anchor [fast=" + this.fast.pageId + ", fastheight=" + this.fastheight + ", top=" + this.top.pageId + ", topheight=" + this.topheight + ", first=" + this.first + "]";
        }
    }

    private static class DummyDeque<E>
    implements Deque<E> {
        private static final Object[] EMPTY_ARRAY = new Object[0];
        public static final Deque INSTANCE = new DummyDeque();

        private DummyDeque() {
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public Object[] toArray() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            Arrays.fill(a, null);
            return a;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return false;
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return false;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return false;
        }

        @Override
        public void clear() {
        }

        @Override
        public void addFirst(E e) {
        }

        @Override
        public void addLast(E e) {
        }

        @Override
        public boolean offerFirst(E e) {
            return false;
        }

        @Override
        public boolean offerLast(E e) {
            return false;
        }

        @Override
        public E removeFirst() {
            return null;
        }

        @Override
        public E removeLast() {
            throw new NoSuchElementException();
        }

        @Override
        public E pollFirst() {
            return null;
        }

        @Override
        public E pollLast() {
            return null;
        }

        @Override
        public E getFirst() {
            throw new NoSuchElementException();
        }

        @Override
        public E getLast() {
            throw new NoSuchElementException();
        }

        @Override
        public E peekFirst() {
            return null;
        }

        @Override
        public E peekLast() {
            return null;
        }

        @Override
        public boolean removeFirstOccurrence(Object o) {
            return false;
        }

        @Override
        public boolean removeLastOccurrence(Object o) {
            return false;
        }

        @Override
        public boolean add(E e) {
            return false;
        }

        @Override
        public boolean offer(E e) {
            return false;
        }

        @Override
        public E remove() {
            throw new NoSuchElementException();
        }

        @Override
        public E poll() {
            return null;
        }

        @Override
        public E element() {
            throw new NoSuchElementException();
        }

        @Override
        public E peek() {
            return null;
        }

        @Override
        public void push(E e) {
        }

        @Override
        public E pop() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean remove(Object o) {
            return false;
        }

        @Override
        public boolean contains(Object o) {
            return false;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator<E> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public Iterator<E> descendingIterator() {
            return Collections.emptyIterator();
        }
    }

    private final class ScanIterator
    implements Iterator<Map.Entry<K, V>> {
        private boolean nextChecked;
        private Iterator<Map.Entry<K, V>> current;
        private Node<K, V> node;
        private K lastRead;
        private K rightsep;
        private final K end;
        private final boolean inclusive;
        final /* synthetic */ BLink this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public ScanIterator(Node<K, V> node, K start, boolean sinclusive, K end, boolean einclusive) throws UncheckedIOException {
            this.this$0 = (BLink)n;
            this.end = end;
            this.inclusive = einclusive;
            this.lastRead = start;
            this.node = node;
            try {
                List list = node.copyRange(start, sinclusive, end, einclusive);
                this.current = list.iterator();
                this.rightsep = node.rightsep;
            }
            catch (IOException e) {
                throw new UncheckedIOException("failed to copy data from node " + node.pageId, e);
            }
            finally {
                ((BLink)n).unlock(node, 1);
            }
            this.nextChecked = false;
        }

        @Override
        public boolean hasNext() {
            this.nextChecked = true;
            if (this.current != null) {
                if (this.current.hasNext()) {
                    return true;
                }
                if (this.rightsep != this.this$0.positiveInfinity) {
                    List list;
                    ResultCouple move_right = this.this$0.move_right(this.lastRead, this.node, this.rightsep, 1);
                    this.node = move_right.node;
                    if (this.node.rightsep.compareTo(this.rightsep) > 0) {
                        this.rightsep = this.node.rightsep;
                        try {
                            list = this.node.copyRange(this.lastRead, false, this.end, this.inclusive);
                            this.current = list.iterator();
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException("failed to copy data from node " + this.node.pageId, e);
                        }
                        finally {
                            this.this$0.unlock(this.node, 1);
                        }
                        if (this.current.hasNext()) {
                            return true;
                        }
                    }
                    this.node = this.jump_right(this.node, this.rightsep);
                    this.rightsep = this.node.rightsep;
                    try {
                        list = this.node.copyRange(this.lastRead, false, this.end, this.inclusive);
                        this.current = list.iterator();
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("failed to copy data from node " + this.node.pageId, e);
                    }
                    finally {
                        this.this$0.unlock(this.node, 1);
                    }
                    if (this.current.hasNext()) {
                        return true;
                    }
                }
                this.rightsep = null;
                this.lastRead = null;
                this.node = null;
                this.current = null;
                return false;
            }
            return false;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            if (!this.nextChecked && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.nextChecked = false;
            Map.Entry next = this.current.next();
            this.lastRead = (Comparable)next.getKey();
            return next;
        }

        private Node<K, V> jump_right(Node<K, V> n, K rightsep) {
            while (n.empty() || n.rightsep().compareTo(rightsep) <= 0) {
                Node m = n.empty() ? n.outlink() : n.rightlink();
                this.this$0.unlock(n, 1);
                this.this$0.lock(m, 1);
                n = m;
            }
            return n;
        }
    }

    private static interface CriticJob {
        public void execute() throws IOException;
    }

    private static class LockAndUnload<X extends Comparable<X>, Y> {
        final Lock lock;
        final Page.Metadata unload;
        final long pageId;

        public LockAndUnload(Lock lock, Page.Metadata unload, long pageId) {
            this.lock = lock;
            this.unload = unload;
            this.pageId = pageId;
        }

        public boolean unloadIfNot(Node<X, Y> node, BLink<X, Y> tree) throws IOException {
            if (this.unload == null) {
                return true;
            }
            if (node.pageId == this.unload.pageId && this.unload.owner == tree) {
                return false;
            }
            return ((BLink)tree).attemptUnload(this.unload);
        }

        public void unload() throws IOException {
            try {
                this.unload.owner.unload(this.unload.pageId);
            }
            catch (RuntimeException e) {
                throw new IOException("failed to unload " + this.unload.pageId, e);
            }
        }

        public void unlock() {
            this.lock.unlock();
        }

        public String toString() {
            return "LockAndUnload [unload=" + this.unload + "]";
        }
    }

    private static class BLinkPage<X extends Comparable<X>, Y>
    extends Page<BLink<X, Y>> {
        public BLinkPage(BLink<X, Y> owner, long pageId) {
            super(owner, pageId);
        }
    }
}

