/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.taskdefs.SignJar;
import org.apache.tools.ant.taskdefs.Taskdef;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.ant.types.resources.FileResource;
import org.netbeans.nbbuild.JarWithModuleAttributes;
import org.netbeans.nbbuild.ModuleSelector;
import org.netbeans.nbbuild.XMLUtil;
import org.xml.sax.SAXException;

public class MakeJnlp2
extends Task {
    private ResourceCollection files;
    private String alias;
    private String storePass;
    private String keystore;
    private String storeType;
    private boolean signingForce = true;
    private String signingTsaCert;
    private String signingTsaUrl;
    private String signingMaxMemory = "96m";
    private int signingRetryCount = 1;
    private int nbThreads = 1;
    private List<Property> extraManifestAttributes;
    private boolean unsignFirst;
    private List<SignJar.JarsConfig> jarsConfigs;
    private File basedir;
    private boolean pack200 = false;
    private Integer pack200Effort;
    private File targetFile;
    private String codebase = "$$codebase";
    private boolean verify;
    private String verifyExcludes;
    private String permissions = "<all-permissions/>";
    private FileSet indirectJars;
    private FileSet indirectFiles;
    private boolean signJars = true;
    private boolean processJarVersions = false;
    private Map<String, String> jarVersions;
    private Set<String> nativeLibraries;
    private Set<File> jarDirectories;
    private static final Pattern SF = Pattern.compile("META-INF/(.+)\\.SF");

    public FileSet createModules() throws BuildException {
        FileSet fs = new FileSet();
        fs.setProject(this.getProject());
        this.addConfigured((ResourceCollection)fs);
        return fs;
    }

    public void addConfigured(ResourceCollection rc) throws BuildException {
        if (this.files != null) {
            throw new BuildException("modules can be specified just once");
        }
        this.files = rc;
    }

    private SignJar createSignTask() {
        Taskdef taskdef = (Taskdef)this.getProject().createTask("taskdef");
        taskdef.setClassname(SignJar.class.getName());
        taskdef.setName("signjar");
        taskdef.execute();
        SignJar signTask = (SignJar)this.getProject().createTask("signjar");
        signTask.setAlias(this.alias);
        signTask.setStorepass(this.storePass);
        signTask.setKeystore(this.keystore);
        signTask.setStoretype(this.storeType);
        signTask.setForce(this.signingForce);
        signTask.setTsacert(this.signingTsaCert);
        signTask.setTsaurl(this.signingTsaUrl);
        signTask.setMaxmemory(this.signingMaxMemory);
        signTask.setRetryCount(this.signingRetryCount);
        signTask.setUnsignFirst(this.unsignFirst);
        signTask.setExtraManifestAttributes(this.extraManifestAttributes);
        signTask.setJarsConfigs(this.jarsConfigs);
        signTask.setBasedir(this.getBasedir());
        signTask.setPack200(this.pack200);
        signTask.setPack200Effort(this.pack200Effort);
        return signTask;
    }

    public void setDir(File t) {
        this.targetFile = t;
    }

    public void setAlias(String a) {
        this.alias = a;
    }

    public void setStorePass(String p) {
        this.storePass = p;
    }

    public void setKeystore(String k) {
        this.keystore = k;
    }

    public void setStoreType(String t) {
        this.storeType = t;
    }

    public void setCodebase(String s) {
        this.codebase = s;
    }

    public void setVerify(boolean v) {
        this.verify = v;
    }

    public void setSigningForce(boolean signingForce) {
        this.signingForce = signingForce;
    }

    public void setSigningTsaCert(String signingTsaCert) {
        this.signingTsaCert = signingTsaCert;
    }

    public void setSigningTsaUrl(String signingTsaUrl) {
        this.signingTsaUrl = signingTsaUrl;
    }

    public void setSigningMaxMemory(String signingMaxMemory) {
        this.signingMaxMemory = signingMaxMemory;
    }

    public void setSigningRetryCount(int signingRetryCount) {
        this.signingRetryCount = signingRetryCount;
    }

    public void setNbThreads(int nbThreads) {
        this.nbThreads = nbThreads;
    }

    public boolean isUnsignFirst() {
        return this.unsignFirst;
    }

    public void setUnsignFirst(boolean unsignFirst) {
        this.unsignFirst = unsignFirst;
    }

    public List<Property> getExtraManifestAttributes() {
        return this.extraManifestAttributes;
    }

    public void setExtraManifestAttributes(List<Property> extraManifestAttributes) {
        this.extraManifestAttributes = extraManifestAttributes;
    }

    public List<SignJar.JarsConfig> getJarsConfigs() {
        return this.jarsConfigs;
    }

    public void setJarsConfigs(List<SignJar.JarsConfig> jarsConfigs) {
        this.jarsConfigs = jarsConfigs;
    }

    public boolean isPack200() {
        return this.pack200;
    }

    public void setPack200(boolean pack200) {
        this.pack200 = pack200;
    }

    public Integer getPack200Effort() {
        return this.pack200Effort;
    }

    public void setPack200Effort(Integer pack200Effort) {
        this.pack200Effort = pack200Effort;
    }

    public void setVerifyExcludes(String s) {
        this.verifyExcludes = s;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public void setPermissions(String s) {
        this.permissions = s;
    }

    public void addIndirectJars(FileSet fs) {
        this.indirectJars = fs;
    }

    public void addIndirectFiles(FileSet fs) {
        this.indirectFiles = fs;
    }

    public void setSignJars(boolean s) {
        this.signJars = s;
    }

    public void setProcessJarVersions(boolean b) {
        this.processJarVersions = b;
    }

    public void setJarVersions(Map<String, String> jarVersions) {
        this.jarVersions = jarVersions;
    }

    public void setNativeLibraries(Set<String> libs) {
        this.nativeLibraries = libs;
    }

    private SignJar.JarConfigResolved signOrCopy(File from, File to) {
        final SignJar.JarConfigResolved[] jarConfigResolved = new SignJar.JarConfigResolved[1];
        if (!from.exists() && from.getParentFile().getName().equals("locale")) {
            this.log("Localization file " + from + " is referenced, but cannot be found. Skipping.", 1);
            return jarConfigResolved[0];
        }
        if (this.signJars) {
            if (to != null) {
                to.getParentFile().mkdirs();
            }
            SignJar signJar = this.createSignTask();
            signJar.setSigningListener(new SignJar.SigningListener(){

                @Override
                public void beforeSigning(SignJar.JarConfigResolved jarConfig) {
                    jarConfigResolved[0] = jarConfig;
                }
            });
            signJar.setJar(from);
            signJar.setSignedjar(to);
            signJar.execute();
        } else if (to != null) {
            Copy copy = (Copy)this.getProject().createTask("copy");
            copy.setFile(from);
            copy.setTofile(to);
            copy.execute();
        }
        if (this.processJarVersions) {
            if (this.jarDirectories == null) {
                this.jarDirectories = new HashSet<File>();
            }
            this.jarDirectories.add(new File(to.getParent()));
        }
        return jarConfigResolved[0];
    }

    public void execute() throws BuildException {
        if (this.targetFile == null) {
            throw new BuildException("Output dir must be provided");
        }
        if (this.files == null) {
            throw new BuildException("modules must be provided");
        }
        try {
            this.generateFiles();
            if (this.processJarVersions && this.jarDirectories != null && this.jarDirectories.size() > 0) {
                this.generateVersionXMLFiles();
            }
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private void generateFiles() throws IOException, BuildException {
        final HashSet<String> indirectFilePaths = new HashSet<String>();
        for (FileSet fs : new FileSet[]{this.indirectJars, this.indirectFiles}) {
            if (fs == null) continue;
            DirectoryScanner scan = fs.getDirectoryScanner(this.getProject());
            for (String f : scan.getIncludedFiles()) {
                indirectFilePaths.add(f.replace(File.pathSeparatorChar, '/'));
            }
        }
        ExecutorService executorService = Executors.newFixedThreadPool(this.nbThreads);
        final ArrayList exceptions = new ArrayList();
        Iterator fileIt = this.files.iterator();
        while (fileIt.hasNext() && exceptions.isEmpty()) {
            FileResource fr = (FileResource)fileIt.next();
            final File jar = fr.getFile();
            if (!jar.canRead()) {
                throw new BuildException("Cannot read file: " + jar);
            }
            executorService.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    JarFile theJar = null;
                    try {
                        String jarPermissions;
                        theJar = new JarFile(jar);
                        String codenamebase = JarWithModuleAttributes.extractCodeName((Attributes)theJar.getManifest().getMainAttributes());
                        if (codenamebase == null) {
                            throw new BuildException("Not a NetBeans Module: " + jar);
                        }
                        int slash = codenamebase.indexOf(47);
                        if (slash >= 0) {
                            codenamebase = codenamebase.substring(0, slash);
                        }
                        String dashcnb = codenamebase.replace('.', '-');
                        String osDep = null;
                        String bundle = theJar.getManifest().getMainAttributes().getValue("OpenIDE-Module-Localizing-Bundle");
                        Properties prop = new Properties();
                        if (bundle != null) {
                            ZipEntry en = theJar.getEntry(bundle);
                            if (en == null) {
                                throw new BuildException("Cannot find entry: " + bundle + " in file: " + jar);
                            }
                            InputStream is = theJar.getInputStream(en);
                            prop.load(is);
                            is.close();
                        }
                        String title = prop.getProperty("OpenIDE-Module-Name", codenamebase);
                        String oneline = prop.getProperty("OpenIDE-Module-Short-Description", title);
                        String shrt = prop.getProperty("OpenIDE-Module-Long-Description", oneline);
                        String osMan = theJar.getManifest().getMainAttributes().getValue("OpenIDE-Module-Requires");
                        if (osMan != null) {
                            if (osMan.indexOf("org.openide.modules.os.MacOSX") >= 0) {
                                osDep = "Mac OS X";
                            } else if (osMan.indexOf("org.openide.modules.os.Linux") >= 0) {
                                osDep = "Linux";
                            } else if (osMan.indexOf("org.openide.modules.os.Solaris") >= 0) {
                                osDep = "Solaris";
                            } else if (osMan.indexOf("org.openide.modules.os.Windows") >= 0) {
                                osDep = "Windows";
                            }
                        }
                        Map localizedFiles = MakeJnlp2.this.verifyExtensions(jar, theJar.getManifest(), dashcnb, codenamebase, MakeJnlp2.this.verify, indirectFilePaths);
                        new File(MakeJnlp2.this.targetFile, dashcnb).mkdir();
                        File signed = new File(new File(MakeJnlp2.this.targetFile, dashcnb), jar.getName());
                        SignJar.JarConfigResolved jarConfig = MakeJnlp2.this.signOrCopy(jar, signed);
                        File jnlp = new File(MakeJnlp2.this.targetFile, dashcnb + ".jnlp");
                        StringWriter writeJNLP = new StringWriter();
                        writeJNLP.write("<?xml version='1.0' encoding='UTF-8'?>\n");
                        writeJNLP.write("<!DOCTYPE jnlp PUBLIC \"-//Sun Microsystems, Inc//DTD JNLP Descriptor 6.0//EN\" \"http://java.sun.com/dtd/JNLP-6.0.dtd\">\n");
                        writeJNLP.write("<jnlp spec='1.0+' codebase='" + MakeJnlp2.this.codebase + "'>\n");
                        writeJNLP.write("  <information>\n");
                        writeJNLP.write("   <title>" + XMLUtil.toElementContent((String)title) + "</title>\n");
                        writeJNLP.write("   <vendor>NetBeans</vendor>\n");
                        writeJNLP.write("   <description kind='one-line'>" + XMLUtil.toElementContent((String)oneline) + "</description>\n");
                        writeJNLP.write("   <description kind='short'>" + XMLUtil.toElementContent((String)shrt) + "</description>\n");
                        writeJNLP.write("  </information>\n");
                        String realPermissions = MakeJnlp2.this.permissions;
                        if (jarConfig != null && jarConfig.getExtraManifestAttributes() != null && (jarPermissions = jarConfig.getExtraManifestAttributes().getValue("Permissions")) != null) {
                            realPermissions = "all-permissions".equals(jarPermissions) ? "<security><all-permissions/></security>\n" : "";
                        }
                        writeJNLP.write(realPermissions);
                        if (osDep == null) {
                            writeJNLP.write("  <resources>\n");
                        } else {
                            writeJNLP.write("  <resources os='" + osDep + "'>\n");
                        }
                        writeJNLP.write("<property name=\"jnlp.packEnabled\" value=\"" + String.valueOf(MakeJnlp2.this.pack200) + "\"/>\n");
                        writeJNLP.write(MakeJnlp2.this.constructJarHref(jar, dashcnb));
                        MakeJnlp2.this.processExtensions(jar, theJar.getManifest(), writeJNLP, dashcnb, MakeJnlp2.this.codebase, realPermissions);
                        MakeJnlp2.this.processIndirectJars(writeJNLP, dashcnb);
                        MakeJnlp2.this.processIndirectFiles(writeJNLP, dashcnb);
                        writeJNLP.write("  </resources>\n");
                        for (Map.Entry e : localizedFiles.entrySet()) {
                            String locale = (String)e.getKey();
                            List allFiles = (List)e.getValue();
                            writeJNLP.write("  <resources locale='" + locale + "'>\n");
                            for (File n : allFiles) {
                                MakeJnlp2.this.log("generating locale " + locale + " for " + n, 3);
                                String name = n.getName();
                                String clusterRootPrefix = jar.getParent() + File.separatorChar;
                                String absname = n.getAbsolutePath();
                                if (absname.startsWith(clusterRootPrefix)) {
                                    name = absname.substring(clusterRootPrefix.length()).replace(File.separatorChar, '-');
                                }
                                File t = new File(new File(MakeJnlp2.this.targetFile, dashcnb), name);
                                MakeJnlp2.this.signOrCopy(n, t);
                                writeJNLP.write(MakeJnlp2.this.constructJarHref(n, dashcnb, name));
                            }
                            writeJNLP.write("  </resources>\n");
                        }
                        writeJNLP.write("  <component-desc/>\n");
                        writeJNLP.write("</jnlp>\n");
                        writeJNLP.close();
                        Files.write((CharSequence)writeJNLP.toString(), (File)jnlp, (Charset)Charset.forName("UTF-8"));
                    }
                    catch (Exception e) {
                        exceptions.add(new BuildException((Throwable)e));
                    }
                    finally {
                        if (theJar != null) {
                            try {
                                theJar.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            });
        }
        executorService.shutdown();
        try {
            executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        if (!exceptions.isEmpty()) {
            throw (BuildException)((Object)exceptions.get(0));
        }
    }

    private Map<String, List<File>> verifyExtensions(File f, Manifest mf, String dashcnb, String codebasename, boolean verify, Set<String> indirectFilePaths) throws IOException, BuildException {
        StringTokenizer tok;
        File updateTracking;
        HashMap<String, List<File>> localizedFiles = new HashMap<String, List<File>>();
        File clusterRoot = f.getParentFile();
        String moduleDirPrefix = "";
        this.log("Verifying extensions for: " + codebasename + ", cluster root: " + clusterRoot + ", verify: " + verify, 4);
        while (!(updateTracking = new File(clusterRoot, "update_tracking")).isDirectory()) {
            moduleDirPrefix = clusterRoot.getName() + "/" + moduleDirPrefix;
            if ((clusterRoot = clusterRoot.getParentFile()) != null && clusterRoot.exists()) continue;
            if (!verify) {
                return localizedFiles;
            }
            throw new BuildException("Cannot find update_tracking directory for module " + f);
        }
        File ut = new File(updateTracking, dashcnb + ".xml");
        if (!ut.exists()) {
            throw new BuildException("The file " + ut + " for module " + codebasename + " cannot be found");
        }
        HashMap<String, String> fileToOwningModule = new HashMap<String, String>();
        try {
            ModuleSelector.readUpdateTracking((Project)this.getProject(), (String)ut.toString(), fileToOwningModule);
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
        catch (ParserConfigurationException ex) {
            throw new BuildException((Throwable)ex);
        }
        catch (SAXException ex) {
            throw new BuildException((Throwable)ex);
        }
        this.log("project files: " + fileToOwningModule, 4);
        String name = this.relative(f, clusterRoot);
        this.log("  removing: " + name, 4);
        MakeJnlp2.removeWithLocales(fileToOwningModule, name, clusterRoot, localizedFiles);
        name = "config/Modules/" + dashcnb + ".xml";
        this.log("  removing: " + name, 4);
        MakeJnlp2.removeWithLocales(fileToOwningModule, name, clusterRoot, localizedFiles);
        name = "config/ModuleAutoDeps/" + dashcnb + ".xml";
        this.log("  removing: " + name, 4);
        MakeJnlp2.removeWithLocales(fileToOwningModule, name, clusterRoot, localizedFiles);
        name = "update_tracking/" + dashcnb + ".xml";
        this.log("  removing: " + name, 4);
        MakeJnlp2.removeWithLocales(fileToOwningModule, name, clusterRoot, localizedFiles);
        String path = mf.getMainAttributes().getValue("Class-Path");
        if (path != null) {
            tok = new StringTokenizer(path, ", ");
            while (tok.hasMoreElements()) {
                String s = tok.nextToken();
                File e = new File(f.getParentFile(), s);
                String r = this.relative(e, clusterRoot);
                MakeJnlp2.removeWithLocales(fileToOwningModule, r, clusterRoot, localizedFiles);
            }
        }
        fileToOwningModule.remove("ant/nblib/" + dashcnb + ".jar");
        fileToOwningModule.remove("VERSION.txt");
        fileToOwningModule.keySet().removeAll(indirectFilePaths);
        if (this.verifyExcludes != null) {
            tok = new StringTokenizer(this.verifyExcludes, ", ");
            while (tok.hasMoreElements()) {
                MakeJnlp2.removeWithLocales(fileToOwningModule, tok.nextToken(), clusterRoot, localizedFiles);
            }
        }
        if (verify && !fileToOwningModule.isEmpty()) {
            throw new BuildException("Cannot build JNLP for module " + f + " as these files are in " + "module's NBM, but are not referenced from any path (see harness/README for properties you can define to fix):\n" + fileToOwningModule.keySet());
        }
        return localizedFiles;
    }

    private static void removeWithLocales(Map<String, String> removeFrom, String removeWhat, File clusterRoot, Map<String, List<File>> recordLocales) {
        if (removeFrom.remove(removeWhat) != null && removeWhat.endsWith(".jar")) {
            int basedir = removeWhat.lastIndexOf(47);
            String base = basedir == -1 ? "" : removeWhat.substring(0, basedir);
            String name = removeWhat.substring(basedir + 1, removeWhat.length() - 4);
            Pattern p = Pattern.compile(base + "/locale/" + name + "(|_[a-zA-Z0-9_]+)\\.jar");
            Iterator<String> it = removeFrom.keySet().iterator();
            while (it.hasNext()) {
                String s = it.next();
                Matcher m = p.matcher(s);
                if (!m.matches()) continue;
                String locale = m.group(1).substring(1);
                List<File> l = recordLocales.get(locale);
                if (l == null) {
                    l = new ArrayList<File>();
                    recordLocales.put(locale, l);
                }
                l.add(new File(clusterRoot, s.replace('/', File.separatorChar)));
                it.remove();
            }
        }
    }

    private void processExtensions(File f, Manifest mf, Writer fileWriter, String dashcnb, String codebase, String permissions) throws IOException, BuildException {
        String path;
        File nblibJar = new File(new File(new File(f.getParentFile().getParentFile(), "ant"), "nblib"), dashcnb + ".jar");
        if (nblibJar.isFile()) {
            File ext = new File(new File(this.targetFile, dashcnb), "ant-nblib-" + nblibJar.getName());
            fileWriter.write(this.constructJarHref(ext, dashcnb));
            this.signOrCopy(nblibJar, ext);
        }
        if ((path = mf.getMainAttributes().getValue("Class-Path")) == null) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(path, ", ");
        while (tok.hasMoreElements()) {
            String s = tok.nextToken();
            if (s.contains("${java.home}")) continue;
            File e = new File(f.getParentFile(), s);
            if (!e.canRead()) {
                throw new BuildException("Cannot read extension " + e + " referenced from " + f);
            }
            String n = e.getName();
            if (n.endsWith(".jar")) {
                n = n.substring(0, n.length() - 4);
            }
            File ext = new File(new File(this.targetFile, dashcnb), s.replace("../", "").replace('/', '-'));
            if (MakeJnlp2.isSigned(e) != null) {
                this.signOrCopy(e, ext);
                String extJnlpName = dashcnb + '-' + ext.getName().replaceFirst("\\.jar$", "") + ".jnlp";
                File jnlp = new File(this.targetFile, extJnlpName);
                FileWriter writeJNLP = new FileWriter(jnlp);
                writeJNLP.write("<?xml version='1.0' encoding='UTF-8'?>\n");
                writeJNLP.write("<!DOCTYPE jnlp PUBLIC \"-//Sun Microsystems, Inc//DTD JNLP Descriptor 6.0//EN\" \"http://java.sun.com/dtd/JNLP-6.0.dtd\">\n");
                writeJNLP.write("<jnlp spec='1.0+' codebase='" + codebase + "'>\n");
                writeJNLP.write("  <information>\n");
                writeJNLP.write("    <title>" + n + "</title>\n");
                writeJNLP.write("    <vendor>NetBeans</vendor>\n");
                writeJNLP.write("  </information>\n");
                writeJNLP.write(permissions + "\n");
                writeJNLP.write("  <resources>\n");
                writeJNLP.write("<property name=\"jnlp.packEnabled\" value=\"" + String.valueOf(this.pack200) + "\"/>\n");
                writeJNLP.write(this.constructJarHref(ext, dashcnb));
                writeJNLP.write("  </resources>\n");
                writeJNLP.write("  <component-desc/>\n");
                writeJNLP.write("</jnlp>\n");
                writeJNLP.close();
                fileWriter.write("    <extension name='" + e.getName().replaceFirst("\\.jar$", "") + "' href='" + extJnlpName + "'/>\n");
                continue;
            }
            this.signOrCopy(e, ext);
            fileWriter.write(this.constructJarHref(ext, dashcnb));
        }
    }

    private void processIndirectJars(Writer fileWriter, String dashcnb) throws IOException, BuildException {
        if (this.indirectJars == null) {
            return;
        }
        DirectoryScanner scan = this.indirectJars.getDirectoryScanner(this.getProject());
        for (String f : scan.getIncludedFiles()) {
            String sig;
            File jar = new File(scan.getBasedir(), f);
            String rel = f.replace(File.separatorChar, '/');
            try {
                sig = MakeJnlp2.isSigned(jar);
            }
            catch (IOException x) {
                throw new BuildException("Cannot check signature on " + jar, (Throwable)x, this.getLocation());
            }
            String rel2 = rel.endsWith(".jar") ? rel : rel.replaceFirst("(\\.zip)?$", ".jar");
            File ext = new File(new File(this.targetFile, dashcnb), rel2.replace('/', '-').replaceFirst("^modules-", ""));
            Zip jartask = (Zip)this.getProject().createTask("jar");
            jartask.setDestFile(ext);
            ZipFileSet zfs = new ZipFileSet();
            zfs.setSrc(jar);
            if (sig != null) {
                zfs.setExcludes("META-INF/" + sig + ".*");
            }
            jartask.addZipfileset(zfs);
            zfs = new ZipFileSet();
            File blank = File.createTempFile("empty", "");
            blank.deleteOnExit();
            zfs.setFile(blank);
            zfs.setFullpath("META-INF/clusterpath/" + rel);
            jartask.addZipfileset(zfs);
            jartask.execute();
            blank.delete();
            fileWriter.write(this.constructJarHref(ext, dashcnb));
            this.signOrCopy(ext, null);
        }
    }

    private void processIndirectFiles(Writer fileWriter, String dashcnb) throws IOException, BuildException {
        if (this.indirectFiles == null) {
            return;
        }
        DirectoryScanner scan = this.indirectFiles.getDirectoryScanner(this.getProject());
        LinkedHashMap<String, File> entries = new LinkedHashMap<String, File>();
        for (String f : scan.getIncludedFiles()) {
            entries.put(f.replace(File.separatorChar, '/'), new File(scan.getBasedir(), f));
        }
        if (entries.isEmpty()) {
            return;
        }
        File ext = new File(new File(this.targetFile, dashcnb), "extra-files.jar");
        Zip jartask = (Zip)this.getProject().createTask("jar");
        jartask.setDestFile(ext);
        for (Map.Entry entry : entries.entrySet()) {
            ZipFileSet zfs = new ZipFileSet();
            zfs.setFile((File)entry.getValue());
            zfs.setFullpath("META-INF/files/" + (String)entry.getKey());
            jartask.addZipfileset(zfs);
        }
        jartask.execute();
        fileWriter.write(this.constructJarHref(ext, dashcnb));
        this.signOrCopy(ext, null);
    }

    private String relative(File file, File root) {
        String sroot;
        String sfile = file.toString().replace(File.separatorChar, '/');
        if (sfile.startsWith(sroot = (root.toString() + File.separator).replace(File.separatorChar, '/'))) {
            try {
                String result = new URI(null, sfile.substring(sroot.length()), null).normalize().getPath();
                return result;
            }
            catch (URISyntaxException x) {
                throw new BuildException((Throwable)x, this.getLocation());
            }
        }
        return sfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String isSigned(File f) throws IOException {
        JarFile jar = new JarFile(f);
        try {
            Enumeration<JarEntry> en = jar.entries();
            while (en.hasMoreElements()) {
                Matcher m = SF.matcher(en.nextElement().getName());
                if (!m.matches()) continue;
                String string = m.group(1);
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            jar.close();
        }
    }

    private String getJarVersion(JarFile jar) throws IOException {
        String version = jar.getManifest().getMainAttributes().getValue("OpenIDE-Module-Specification-Version");
        if (version == null) {
            version = jar.getManifest().getMainAttributes().getValue("Specification-Version");
        }
        if (version == null && this.jarVersions != null) {
            version = this.jarVersions.get(jar.getName());
        }
        return version;
    }

    private String constructJarHref(File f, String dashcnb) throws IOException {
        return this.constructJarHref(f, dashcnb, f.getName());
    }

    private String constructJarHref(File f, String dashcnb, String name) throws IOException {
        String tag = "jar";
        if (this.nativeLibraries != null && this.nativeLibraries.contains(name)) {
            tag = "nativelib";
        }
        if (this.processJarVersions) {
            if (!f.exists()) {
                throw new BuildException("JAR file " + f + " does not exist, cannot extract required versioning info.");
            }
            JarFile extJar = new JarFile(f);
            String version = this.getJarVersion(extJar);
            if (version != null) {
                return "    <" + tag + " href='" + dashcnb + '/' + name + "' version='" + version + "' size='" + f.length() + "'/>\n";
            }
        }
        return "    <" + tag + " href='" + dashcnb + '/' + name + "'/>\n";
    }

    private void generateVersionXMLFiles() throws IOException {
        FileSet fs = new FileSet();
        fs.setIncludes("**/*.jar");
        for (File directory : this.jarDirectories) {
            fs.setDir(directory);
            DirectoryScanner scan = fs.getDirectoryScanner(this.getProject());
            StringWriter writeVersionXML = new StringWriter();
            writeVersionXML.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            writeVersionXML.append("<jnlp-versions>\n");
            for (String jarName : scan.getIncludedFiles()) {
                File jar = new File(scan.getBasedir(), jarName);
                JarFile jarFile = new JarFile(jar);
                String version = this.getJarVersion(jarFile);
                if (version != null) {
                    writeVersionXML.append("    <resource>\n        <pattern>\n            <name>");
                    writeVersionXML.append(jar.getName());
                    writeVersionXML.append("</name>\n            <version-id>");
                    writeVersionXML.append(version);
                    writeVersionXML.append("</version-id>\n        </pattern>\n        <file>");
                    writeVersionXML.append(jar.getName());
                    writeVersionXML.append("</file>\n    </resource>\n");
                    continue;
                }
                writeVersionXML.append("    <!-- No version found for ");
                writeVersionXML.append(jar.getName());
                writeVersionXML.append(" -->\n");
            }
            writeVersionXML.append("</jnlp-versions>\n");
            writeVersionXML.close();
            File versionXML = new File(directory, "version.xml");
            FileWriter w = new FileWriter(versionXML);
            w.write(writeVersionXML.toString());
            w.close();
        }
    }
}

