/*
 * Decompiled with CFR 0.152.
 */
package org.bitstrings.maven.nbm.utils;

import com.google.common.io.Closer;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

public final class JarUtils {
    public static final String MANIFEST_JAR_ENTRY = "META-INF/MANIFEST.MF";
    public static final String MANIFEST_ATTR_PERMISSIONS = "Permissions";
    public static final String MANIFEST_ATTR_CODEBASE = "Codebase";
    public static final String MANIFEST_ATTR_APPLICATION_NAME = "Application-Name";
    public static final String MANIFEST_ATTR_TRUSTED_ONLY = "Trusted-Only";
    public static final String MANIFEST_ATTR_TRUSTED_LIBRARY = "Trusted-Library";
    public static final String MANIFEST_ATTR_APPLICATION_LIBRARY_ALLOWABLE_CODEBASE = "Application-Library-Allowable-Codebase";
    public static final String MANIFEST_ATTR_CALLER_ALLOWABLE_CODEBASE = "Caller-Allowable-Codebase";

    private JarUtils() {
    }

    public static void unsignArchive(File jarFile) throws IOException {
        JarUtils.archiveModifier(jarFile, null, null, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void archiveModifier(File inJar, File outJar, Integer compressionLevel, boolean unsign, Attributes attributes) throws IOException {
        File workJar = outJar == null ? new File(inJar.getAbsolutePath() + ".tmp") : outJar;
        Closer closer = Closer.create();
        try {
            JarInputStream jis = (JarInputStream)closer.register((Closeable)new JarInputStream(new BufferedInputStream(new FileInputStream(inJar))));
            Manifest manifest = JarUtils.getManifest(inJar);
            if (unsign) {
                Map<String, Attributes> entries = manifest.getEntries();
                entries.clear();
            }
            if (attributes != null && !attributes.isEmpty()) {
                manifest.getMainAttributes().putAll((Map<?, ?>)attributes);
            }
            JarOutputStream jos = (JarOutputStream)closer.register((Closeable)new JarOutputStream((OutputStream)new FileOutputStream(workJar), manifest));
            if (compressionLevel != null) {
                jos.setLevel(compressionLevel);
            }
            JarEntry je = jis.getNextJarEntry();
            while (je != null) {
                if (!(unsign && JarUtils.isSignatureFile(je.getName()) || je.getName().equals(MANIFEST_JAR_ENTRY))) {
                    jos.putNextEntry(new JarEntry(je.getName()));
                    IOUtil.copy((InputStream)jis, (OutputStream)jos);
                }
                je = jis.getNextJarEntry();
            }
        }
        finally {
            closer.close();
        }
        if (outJar == null) {
            FileUtils.rename((File)workJar, (File)inJar);
        }
    }

    private static boolean isSignatureFile(String entryName) {
        if (entryName.regionMatches(true, 0, "META-INF", 0, 8) && (entryName = entryName.replace('\\', '/')).indexOf(47) == 8 && entryName.lastIndexOf(47) == 8) {
            if (entryName.regionMatches(true, entryName.length() - 3, ".SF", 0, 3)) {
                return true;
            }
            if (entryName.regionMatches(true, entryName.length() - 4, ".DSA", 0, 4)) {
                return true;
            }
            if (entryName.regionMatches(true, entryName.length() - 4, ".RSA", 0, 4)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Manifest getManifest(File file) throws IOException {
        Closer closer = Closer.create();
        try {
            JarInputStream jis = (JarInputStream)closer.register((Closeable)new JarInputStream(new BufferedInputStream(new FileInputStream(file))));
            Manifest manifest = jis.getManifest();
            if (manifest != null) {
                Manifest manifest2 = new Manifest(manifest);
                return manifest2;
            }
            JarEntry je = jis.getNextJarEntry();
            while (je != null) {
                if (je.getName().equals(MANIFEST_JAR_ENTRY)) {
                    Manifest manifest3 = new Manifest(jis);
                    return manifest3;
                }
                je = jis.getNextJarEntry();
            }
        }
        finally {
            closer.close();
        }
        return new Manifest();
    }

    public static void main(String[] args) throws Exception {
        System.out.println(new URI("file:as").getScheme());
    }
}

