/*
 * Decompiled with CFR 0.152.
 */
package org.bitstrings.maven.nbm.utils;

import com.google.common.io.Closer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.SortedMap;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class JarPack200 {
    public static final String DEFAULT_GZIPPED_PACKED_FILE_SUFFIX = "pack.gz";
    public static final String DEFAULT_PACKED_FILE_SUFFIX = "pack";
    private final Pack200.Packer packer;
    private final Pack200.Unpacker unpacker;
    private boolean useGZip = true;

    public JarPack200() {
        this.packer = JarPack200.getDefaultPacker();
        this.unpacker = JarPack200.getDefaultUnpacker();
    }

    public JarPack200(int effort) {
        this.packer = JarPack200.getDefaultPacker(effort);
        this.unpacker = JarPack200.getDefaultUnpacker();
    }

    public JarPack200(Pack200.Packer packer, Pack200.Unpacker unpacker) {
        this.packer = packer;
        this.unpacker = unpacker;
    }

    public void pack(File sourceJarFile, File targetFile) throws IOException {
        this.pack(this.packer, sourceJarFile, targetFile, this.useGZip);
    }

    protected void pack(File sourceJarFile, File targetFile, boolean useGZip) throws IOException {
        this.pack(this.packer, sourceJarFile, targetFile, useGZip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pack(Pack200.Packer packer, File sourceJarFile, File targetFile, boolean useGZip) throws IOException {
        Closer closer = Closer.create();
        try {
            JarFile jarFile = new JarFile(sourceJarFile);
            OutputStream targetOut = (OutputStream)closer.register((Closeable)(useGZip ? new GZIPOutputStream((OutputStream)new FileOutputStream(targetFile), 4096) : new BufferedOutputStream(new FileOutputStream(targetFile), 4096)));
            packer.pack(jarFile, targetOut);
        }
        finally {
            closer.close();
        }
    }

    public void unpack(File sourceFile, File targetJarFile) throws IOException {
        this.unpack(this.unpacker, sourceFile, targetJarFile, this.useGZip);
    }

    protected void unpack(File sourceFile, File targetJarFile, boolean isGZip) throws IOException {
        this.unpack(this.unpacker, sourceFile, targetJarFile, isGZip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unpack(Pack200.Unpacker unpacker, File sourceFile, File targetJarFile, boolean isGZip) throws IOException {
        Closer closer = Closer.create();
        try {
            InputStream jarIn = (InputStream)closer.register((Closeable)(isGZip ? new GZIPInputStream((InputStream)new FileInputStream(sourceFile), 4096) : new BufferedInputStream(new FileInputStream(sourceFile), 4096)));
            JarOutputStream jarOut = (JarOutputStream)closer.register((Closeable)new JarOutputStream(new FileOutputStream(targetJarFile)));
            unpacker.unpack(jarIn, jarOut);
        }
        finally {
            closer.close();
        }
    }

    public void repack(File sourceJarFile) throws IOException {
        this.repack(sourceJarFile, sourceJarFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repack(File sourceJarFile, File targetJarFile) throws IOException {
        if (targetJarFile == null) {
            targetJarFile = sourceJarFile;
        }
        File tempFile = File.createTempFile("pack200", ".repack.pack.gz");
        tempFile.deleteOnExit();
        try {
            this.pack(sourceJarFile, tempFile, false);
            this.unpack(tempFile, targetJarFile, false);
        }
        finally {
            tempFile.delete();
        }
    }

    public File getPackedFileFromJarFile(String jarFile) {
        return new File(jarFile.concat("." + (this.useGZip ? DEFAULT_GZIPPED_PACKED_FILE_SUFFIX : DEFAULT_PACKED_FILE_SUFFIX)));
    }

    public File getPackedFileFromJarFile(File jarFile) {
        return this.getPackedFileFromJarFile(jarFile.getAbsolutePath());
    }

    public static Pack200.Packer getDefaultPacker() {
        return JarPack200.getDefaultPacker(-1);
    }

    public static Pack200.Packer getDefaultPacker(int effort) {
        Pack200.Packer packer = DefaultProperties.populatePacker(Pack200.newPacker());
        if (effort > -1) {
            packer.properties().put("pack.effort", String.valueOf(effort));
        }
        return packer;
    }

    public static Pack200.Unpacker getDefaultUnpacker() {
        return Pack200.newUnpacker();
    }

    public static final class DefaultProperties {
        public static final String SEGMENT_LIMIT = "-1";

        private DefaultProperties() {
        }

        public static Pack200.Packer populatePacker(Pack200.Packer packer) {
            SortedMap packerProps = packer.properties();
            packerProps.put("pack.segment.limit", SEGMENT_LIMIT);
            return packer;
        }
    }
}

