/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import com.google.common.base.Objects;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.AbstractJarSignerTask;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.taskdefs.condition.IsSigned;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileProvider;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.Restrict;
import org.apache.tools.ant.types.resources.selectors.And;
import org.apache.tools.ant.types.resources.selectors.Name;
import org.apache.tools.ant.types.resources.selectors.Not;
import org.apache.tools.ant.types.resources.selectors.ResourceSelector;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.IdentityMapper;
import org.apache.tools.ant.util.ResourceUtils;
import org.bitstrings.maven.nbm.utils.JarPack200;
import org.bitstrings.maven.nbm.utils.JarUtils;

public class SignJar
extends AbstractJarSignerTask {
    private SigningListener jarListener;
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    protected String sigfile;
    protected File signedjar;
    protected boolean internalsf;
    protected boolean sectionsonly;
    private boolean preserveLastModified;
    protected boolean lazy;
    protected File destDir;
    private FileNameMapper mapper;
    protected String tsaurl;
    protected String tsacert;
    private boolean force = false;
    private String sigAlg;
    private String digestAlg;
    private int retryCount = 1;
    private boolean unsignFirst;
    private List<Property> extraManifestAttributes;
    private List<JarsConfig> jarsConfigs;
    private File basedir;
    private boolean destFlatten;
    private boolean pack200 = false;
    private Integer pack200Effort;
    private JarPack200 jarPack200;
    public static final String ERROR_TODIR_AND_SIGNEDJAR = "'destdir' and 'signedjar' cannot both be set";
    public static final String ERROR_TOO_MANY_MAPPERS = "Too many mappers";
    public static final String ERROR_SIGNEDJAR_AND_PATHS = "You cannot specify the signed JAR when using paths or filesets";
    public static final String ERROR_BAD_MAP = "Cannot map source file to anything sensible: ";
    public static final String ERROR_MAPPER_WITHOUT_DEST = "The destDir attribute is required if a mapper is set";
    public static final String ERROR_NO_ALIAS = "alias attribute must be set";
    public static final String ERROR_NO_STOREPASS = "storepass attribute must be set";

    public void setSigningListener(SigningListener jarListener) {
        this.jarListener = jarListener;
    }

    public SigningListener getJarListener() {
        return this.jarListener;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public void setSigfile(String sigfile) {
        this.sigfile = sigfile;
    }

    public void setSignedjar(File signedjar) {
        this.signedjar = signedjar;
    }

    public void setInternalsf(boolean internalsf) {
        this.internalsf = internalsf;
    }

    public void setSectionsonly(boolean sectionsonly) {
        this.sectionsonly = sectionsonly;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public void add(FileNameMapper newMapper) {
        if (this.mapper != null) {
            throw new BuildException(ERROR_TOO_MANY_MAPPERS);
        }
        this.mapper = newMapper;
    }

    public FileNameMapper getMapper() {
        return this.mapper;
    }

    public String getTsaurl() {
        return this.tsaurl;
    }

    public void setTsaurl(String tsaurl) {
        this.tsaurl = tsaurl;
    }

    public String getTsacert() {
        return this.tsacert;
    }

    public void setTsacert(String tsacert) {
        this.tsacert = tsacert;
    }

    public void setForce(boolean b) {
        this.force = b;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setSigAlg(String sigAlg) {
        this.sigAlg = sigAlg;
    }

    public String getSigAlg() {
        return this.sigAlg;
    }

    public void setDigestAlg(String digestAlg) {
        this.digestAlg = digestAlg;
    }

    public String getDigestAlg() {
        return this.digestAlg;
    }

    public boolean isUnsignFirst() {
        return this.unsignFirst;
    }

    public void setUnsignFirst(boolean unsignFirst) {
        this.unsignFirst = unsignFirst;
    }

    public List<Property> getExtraManifestAttributes() {
        return this.extraManifestAttributes;
    }

    public void setExtraManifestAttributes(List<Property> extraManifestAttributes) {
        this.extraManifestAttributes = extraManifestAttributes;
    }

    public List<JarsConfig> getJarsConfigs() {
        return this.jarsConfigs;
    }

    public void setJarsConfigs(List<JarsConfig> jarsConfigs) {
        this.jarsConfigs = jarsConfigs;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public boolean isDestFlatten() {
        return this.destFlatten;
    }

    public void setDestFlatten(boolean destFlatten) {
        this.destFlatten = destFlatten;
    }

    public boolean isPack200() {
        return this.pack200;
    }

    public void setPack200(boolean pack200) {
        this.pack200 = pack200;
    }

    public Integer getPack200Effort() {
        return this.pack200Effort;
    }

    public void setPack200Effort(Integer pack200Effort) {
        this.pack200Effort = pack200Effort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        boolean hasMapper;
        boolean hasJar = this.jar != null;
        boolean hasSignedJar = this.signedjar != null;
        boolean hasDestDir = this.destDir != null;
        boolean bl = hasMapper = this.mapper != null;
        if (!hasJar && !this.hasResources()) {
            throw new BuildException("jar must be set through jar attribute or nested filesets");
        }
        if (null == this.alias) {
            throw new BuildException(ERROR_NO_ALIAS);
        }
        if (null == this.storepass) {
            throw new BuildException(ERROR_NO_STOREPASS);
        }
        if (hasDestDir && hasSignedJar) {
            throw new BuildException(ERROR_TODIR_AND_SIGNEDJAR);
        }
        if (this.hasResources() && hasSignedJar) {
            throw new BuildException(ERROR_SIGNEDJAR_AND_PATHS);
        }
        if (!hasDestDir && hasMapper) {
            throw new BuildException(ERROR_MAPPER_WITHOUT_DEST);
        }
        if (this.pack200) {
            this.jarPack200 = this.pack200Effort == null ? new JarPack200() : new JarPack200(this.pack200Effort);
        }
        this.beginExecution();
        try {
            Attributes globalExtraManifestAttributes = this.buildManifestAttributes(this.extraManifestAttributes);
            JarConfigResolved defaultJarsConfigInternal = new JarConfigResolved(this.unsignFirst, globalExtraManifestAttributes);
            if (hasJar && hasSignedJar) {
                FileResource source = new FileResource(this.getProject(), this.jar);
                this.signOneJar(this.jar, this.signedjar, (JarConfigResolved)Objects.firstNonNull((Object)this.buildJarsConfigInternalMap((ResourceCollection)source, globalExtraManifestAttributes).get(source.getName()), (Object)defaultJarsConfigInternal));
                return;
            }
            Path sources = this.createUnifiedSourcePath();
            Object destMapper = hasMapper ? this.mapper : new IdentityMapper();
            Map<String, JarConfigResolved> jarsConfigsMap = this.buildJarsConfigInternalMap((ResourceCollection)sources, globalExtraManifestAttributes);
            for (Resource r : sources) {
                FileResource fr = ResourceUtils.asFileResource((FileProvider)((FileProvider)r.as(FileProvider.class)));
                if (this.getBasedir() != null) {
                    fr.setBaseDir(this.getBasedir());
                }
                File toDir = hasDestDir ? this.destDir : fr.getBaseDir();
                String[] destFilenames = destMapper.mapFileName(fr.getName());
                if (destFilenames == null || destFilenames.length != 1) {
                    throw new BuildException(ERROR_BAD_MAP + fr.getFile());
                }
                File destFile = new File(toDir, destFilenames[0]);
                this.signOneJar(fr.getFile(), destFile, (JarConfigResolved)Objects.firstNonNull((Object)jarsConfigsMap.get(fr.getName()), (Object)defaultJarsConfigInternal));
            }
        }
        finally {
            this.endExecution();
        }
    }

    private void signOneJar(File jarSource, File jarTarget, JarConfigResolved jarConfig) throws BuildException {
        File targetFile = jarTarget;
        if (targetFile == null) {
            targetFile = jarSource;
        }
        if (this.isUpToDate(jarSource, targetFile)) {
            return;
        }
        long lastModified = jarSource.lastModified();
        if (this.destFlatten) {
            targetFile = new File(this.destDir, targetFile.getName());
        }
        boolean unsignFirstCombined = jarConfig.unsignFirst;
        Attributes manifestAttributes = jarConfig.extraManifestAttributes;
        File realSource = jarSource;
        File tmpJar = null;
        if (unsignFirstCombined || manifestAttributes != null && !manifestAttributes.isEmpty()) {
            try {
                tmpJar = File.createTempFile(jarSource.getName(), ".tmp.jar");
                tmpJar.deleteOnExit();
                JarUtils.archiveModifier(jarSource, tmpJar, null, unsignFirstCombined, manifestAttributes);
                jarSource = tmpJar;
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }
        if (this.jarListener != null) {
            this.jarListener.beforeSigning(jarConfig);
        }
        if (this.pack200) {
            try {
                this.jarPack200.repack(jarSource);
            }
            catch (IOException e) {
                throw new BuildException("Unable to repack " + jarSource, (Throwable)e);
            }
        }
        for (int tries = 1; tries <= this.retryCount; ++tries) {
            ExecTask cmd = this.createJarSigner();
            this.setCommonOptions(cmd);
            this.bindToKeystore(cmd);
            if (null != this.sigfile) {
                this.addValue(cmd, "-sigfile");
                String value = this.sigfile;
                this.addValue(cmd, value);
            }
            try {
                if (!FILE_UTILS.areSame(jarSource, targetFile)) {
                    this.addValue(cmd, "-signedjar");
                    this.addValue(cmd, targetFile.getPath());
                }
            }
            catch (IOException ioex) {
                throw new BuildException((Throwable)ioex);
            }
            if (this.internalsf) {
                this.addValue(cmd, "-internalsf");
            }
            if (this.sectionsonly) {
                this.addValue(cmd, "-sectionsonly");
            }
            if (this.sigAlg != null) {
                this.addValue(cmd, "-sigalg");
                this.addValue(cmd, this.sigAlg);
            }
            if (this.digestAlg != null) {
                this.addValue(cmd, "-digestalg");
                this.addValue(cmd, this.digestAlg);
            }
            this.addTimestampAuthorityCommands(cmd);
            this.addValue(cmd, jarSource.getPath());
            this.addValue(cmd, this.alias);
            this.log("Signing archive" + (tries == 1 ? "" : " (try:" + tries + ")") + ": " + realSource.getAbsolutePath() + " to " + targetFile.getAbsolutePath() + " as " + this.alias);
            try {
                cmd.execute();
                break;
            }
            catch (BuildException e) {
                this.log(e, 2);
                if (tries != this.retryCount) continue;
                throw e;
            }
        }
        if (this.preserveLastModified) {
            FILE_UTILS.setFileLastModified(targetFile, lastModified);
        }
        if (this.pack200) {
            File packedFile = this.jarPack200.getPackedFileFromJarFile(targetFile);
            try {
                this.jarPack200.pack(targetFile, packedFile);
            }
            catch (IOException e) {
                throw new BuildException("Unable to repack " + jarSource, (Throwable)e);
            }
            if (this.preserveLastModified) {
                FILE_UTILS.setFileLastModified(packedFile, lastModified);
            }
        }
        if (tmpJar != null) {
            tmpJar.delete();
        }
    }

    private void addTimestampAuthorityCommands(ExecTask cmd) {
        if (this.tsaurl != null) {
            this.addValue(cmd, "-tsa");
            this.addValue(cmd, this.tsaurl);
        }
        if (this.tsacert != null) {
            this.addValue(cmd, "-tsacert");
            this.addValue(cmd, this.tsacert);
        }
    }

    protected boolean isUpToDate(File jarFile, File signedjarFile) {
        if (this.isForce() || null == jarFile || !jarFile.exists()) {
            return false;
        }
        File destFile = signedjarFile;
        if (destFile == null) {
            destFile = jarFile;
        }
        if (jarFile.equals(destFile)) {
            if (this.lazy) {
                return this.isSigned(jarFile);
            }
            return false;
        }
        return FILE_UTILS.isUpToDate(jarFile, destFile);
    }

    protected boolean isSigned(File file) {
        try {
            return IsSigned.isSigned((File)file, (String)(this.sigfile == null ? this.alias : this.sigfile));
        }
        catch (IOException e) {
            this.log(e.toString(), 3);
            return false;
        }
    }

    public void setPreserveLastModified(boolean preserveLastModified) {
        this.preserveLastModified = preserveLastModified;
    }

    private Attributes buildManifestAttributes(List<Property> properties) {
        Attributes manifestAttributes = null;
        if (properties != null && !properties.isEmpty()) {
            manifestAttributes = new Attributes();
            for (Property property : properties) {
                manifestAttributes.putValue(property.getName(), property.getValue());
            }
        }
        return manifestAttributes;
    }

    private Map<String, JarConfigResolved> buildJarsConfigInternalMap(ResourceCollection sources, Attributes moreExtraManifestAttributes) {
        LinkedHashMap<String, JarConfigResolved> jarConfigResolvedMap = new LinkedHashMap<String, JarConfigResolved>();
        if (this.jarsConfigs != null) {
            for (JarsConfig jarsConfig : this.jarsConfigs) {
                boolean unsignFirstCombined = (Boolean)Objects.firstNonNull((Object)jarsConfig.getUnsignFirst(), (Object)this.unsignFirst);
                Attributes extraManifestAttributes = this.buildManifestAttributes(jarsConfig.getExtraManifestAttributes());
                if (extraManifestAttributes == null) {
                    extraManifestAttributes = moreExtraManifestAttributes;
                } else if (moreExtraManifestAttributes != null) {
                    extraManifestAttributes.putAll((Map<?, ?>)moreExtraManifestAttributes);
                }
                Restrict restrict = new Restrict();
                restrict.setProject(this.getProject());
                restrict.add(sources);
                And patternFilter = new And();
                if (jarsConfig.getIncludes() != null) {
                    Name includesFilter = new Name();
                    includesFilter.setName(jarsConfig.getIncludes());
                    patternFilter.add((ResourceSelector)includesFilter);
                }
                if (jarsConfig.getExcludes() != null) {
                    Name excludes = new Name();
                    excludes.setName(jarsConfig.getExcludes());
                    Not excludesFilter = new Not();
                    excludesFilter.add((ResourceSelector)excludes);
                    patternFilter.add((ResourceSelector)excludesFilter);
                }
                if (patternFilter.hasSelectors()) {
                    restrict.add((ResourceSelector)patternFilter);
                }
                for (Resource resource : restrict) {
                    FileResource fr = ResourceUtils.asFileResource((FileProvider)((FileProvider)resource.as(FileProvider.class)));
                    if (this.getBasedir() != null) {
                        fr.setBaseDir(this.getBasedir());
                    }
                    jarConfigResolvedMap.put(fr.getName(), new JarConfigResolved(unsignFirstCombined, extraManifestAttributes));
                }
            }
        }
        return jarConfigResolvedMap;
    }

    public static class JarsConfig {
        private String includes;
        private String excludes;
        private Boolean unsignFirst;
        private List<Property> extraManifestAttributes;

        public String getIncludes() {
            return this.includes;
        }

        public void setIncludes(String includes) {
            this.includes = includes;
        }

        public String getExcludes() {
            return this.excludes;
        }

        public Boolean getUnsignFirst() {
            return this.unsignFirst;
        }

        public void setUnsignFirst(Boolean unsignFirst) {
            this.unsignFirst = unsignFirst;
        }

        public void setExcludes(String excludes) {
            this.excludes = excludes;
        }

        public List<Property> getExtraManifestAttributes() {
            return this.extraManifestAttributes;
        }

        public void setExtraManifestAttributes(List<Property> extraManifestAttributes) {
            this.extraManifestAttributes = extraManifestAttributes;
        }
    }

    public static class JarConfigResolved {
        private boolean unsignFirst;
        private Attributes extraManifestAttributes;

        public JarConfigResolved(boolean unsignFirst, Attributes extraManifestAttributes) {
            this.unsignFirst = unsignFirst;
            this.extraManifestAttributes = extraManifestAttributes;
        }

        public boolean isUnsignFirst() {
            return this.unsignFirst;
        }

        public Attributes getExtraManifestAttributes() {
            return this.extraManifestAttributes;
        }
    }

    public static interface SigningListener {
        public void beforeSigning(JarConfigResolved var1);
    }
}

