/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.leito.sqlformatter;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.Statements;
import net.sf.jsqlparser.statement.insert.Insert;
import org.bitbucket.leito.sqlformatter.InsertStatementFormatter;

public class SqlFormatter {
    private Map<String, InsertStatementFormatter> insertStatements = new LinkedHashMap<String, InsertStatementFormatter>();

    public String format(String sql) throws JSQLParserException {
        Statements stmt = CCJSqlParserUtil.parseStatements((String)sql);
        List statements = stmt.getStatements();
        for (Statement statement : statements) {
            if (statement instanceof Insert) {
                Insert insert = (Insert)statement;
                String tableName = insert.getTable().getName();
                this.addInsertStatement(tableName);
                this.addRowValues(tableName, (List<Column>)insert.getColumns(), insert.getItemsList());
                continue;
            }
            throw new UnsupportedOperationException("Statement not supported: " + statement.getClass());
        }
        return this.formatInsertStatements();
    }

    private void addInsertStatement(String tableName) {
        this.insertStatements.putIfAbsent(tableName, new InsertStatementFormatter(tableName));
    }

    private void addRowValues(String tableName, List<Column> columns, ItemsList itemsList) {
        if (itemsList instanceof ExpressionList) {
            ExpressionList values2 = (ExpressionList)itemsList;
            this.addRowValues(tableName, columns, values2);
        } else if (itemsList instanceof MultiExpressionList) {
            MultiExpressionList mel = (MultiExpressionList)itemsList;
            mel.getExprList().forEach(values -> this.addRowValues(tableName, columns, (ExpressionList)values));
        } else {
            throw new UnsupportedOperationException("Type not supported: " + itemsList.getClass());
        }
    }

    private void addRowValues(String tableName, List<Column> columns, ExpressionList values) {
        InsertStatementFormatter table = this.insertStatements.get(tableName);
        table.addRowValues(columns, values);
    }

    private String formatInsertStatements() {
        StringBuilder sb = new StringBuilder();
        for (InsertStatementFormatter insertStatement : this.insertStatements.values()) {
            sb.append(insertStatement.format());
            sb.append("\n\n");
        }
        return sb.toString();
    }
}

